/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.untable;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.untable.UNTDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class SSUEventNameDescriptor
extends UNTDescriptor {
    private final String iso639LanguageCode;
    private final int nameLength;
    private final DVBString name;
    private final DVBString text;

    public SSUEventNameDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.iso639LanguageCode = Utils.getISO8859_1String(b, 2, 3);
        this.nameLength = Utils.getInt(b, 5, 1, 255);
        this.name = new DVBString(b, 5);
        this.text = new DVBString(b, 6 + this.nameLength);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new KVP("ISO_639_language_code", this.iso639LanguageCode));
        t.add(new KVP("name_length", this.nameLength));
        t.add(new KVP("name", this.name));
        t.add(new KVP("text", this.text));
        return t;
    }
}

