/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.untable;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.untable.UNTDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class SSULocationDescriptor
extends UNTDescriptor {
    private final int data_broadcast_id;
    private int association_tag;
    private final byte[] privateDataByte;

    public SSULocationDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.data_broadcast_id = Utils.getInt(b, offset + 2, 2, 65535);
        int t = 0;
        if (this.data_broadcast_id == 10) {
            this.association_tag = Utils.getInt(b, offset + 4, 2, 65535);
            t += 2;
        }
        this.privateDataByte = Utils.copyOfRange(b, offset + 4 + t, offset + this.descriptorLength + 2);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("data_broadcast_id", this.data_broadcast_id, Utils.getDataBroadCastIDString(this.data_broadcast_id))));
        if (this.data_broadcast_id == 10) {
            t.add(new DefaultMutableTreeNode(new KVP("association_tag", this.association_tag, null)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("private_data_byte", this.privateDataByte, null)));
        return t;
    }
}

