/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.dsmcc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.BIOPMessage;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.BIOPName;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.IOR;
import nl.digitalekabeltelevisie.util.Utils;

public class BIOPDirectoryMessage
extends BIOPMessage {
    protected byte[] objectInfo_data_byte;
    protected int serviceContextList_count;
    private final List<ServiceContext> serviceContextList = new ArrayList<ServiceContext>();
    protected long messageBody_length;
    protected int bindings_count;
    private final List<Binding> bindingList = new ArrayList<Binding>();

    public BIOPDirectoryMessage(byte[] data, int offset) {
        super(data, offset);
        int i;
        this.objectInfo_data_byte = Arrays.copyOfRange(data, this.byte_counter, this.byte_counter + this.objectInfo_length);
        this.byte_counter += this.objectInfo_length;
        this.serviceContextList_count = Utils.getInt(data, this.byte_counter, 1, 255);
        ++this.byte_counter;
        for (i = 0; i < this.serviceContextList_count; ++i) {
            long context_id = Utils.getLong(data, this.byte_counter, 4, -1L);
            this.byte_counter += 4;
            int context_data_length = Utils.getInt(data, this.byte_counter, 2, 65535);
            this.byte_counter += 2;
            byte[] context_data_byte = Arrays.copyOfRange(data, this.byte_counter, this.byte_counter + context_data_length);
            this.byte_counter += context_data_length;
            ServiceContext serviceContext = new ServiceContext(context_id, context_data_length, context_data_byte);
            this.serviceContextList.add(serviceContext);
        }
        this.messageBody_length = Utils.getLong(data, this.byte_counter, 4, -1L);
        this.byte_counter += 4;
        this.bindings_count = Utils.getInt(data, this.byte_counter, 2, 65535);
        this.byte_counter += 2;
        for (i = 0; i < this.bindings_count; ++i) {
            Binding binding = new Binding(data, this.byte_counter);
            this.bindingList.add(binding);
            this.byte_counter += binding.length();
        }
    }

    @Override
    public KVP getJTreeNode(int modus, String label) {
        KVP t = super.getJTreeNode(modus, label);
        t.add(new KVP("objectInfo_data_byte", this.objectInfo_data_byte));
        t.add(new KVP("serviceContextList_count", this.serviceContextList_count));
        Utils.addListJTree(t, this.serviceContextList, modus, "ServiceContextList");
        t.add(new KVP("messageBody_length", this.messageBody_length));
        t.add(new KVP("bindings_count", this.bindings_count));
        Utils.addListJTree(t, this.bindingList, modus, "Bindings");
        return t;
    }

    @Override
    public KVP getJTreeNode(int modus) {
        return this.getJTreeNode(modus, "");
    }

    public static String getBindingTypeString(int bindingType) {
        if (bindingType == 1) {
            return "nobject";
        }
        if (bindingType == 2) {
            return "ncontext";
        }
        return null;
    }

    public byte[] getObjectInfo_data_byte() {
        return this.objectInfo_data_byte;
    }

    public int getServiceContextList_count() {
        return this.serviceContextList_count;
    }

    public List<ServiceContext> getServiceContextList() {
        return this.serviceContextList;
    }

    public long getMessageBody_length() {
        return this.messageBody_length;
    }

    public int getBindings_count() {
        return this.bindings_count;
    }

    public List<Binding> getBindingList() {
        return this.bindingList;
    }

    public record ServiceContext(long context_id, int context_data_length, byte[] context_data_byte) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            KVP t = new KVP("ServiceContext");
            t.add(new KVP("context_id", this.context_id));
            t.add(new KVP("context_data_length", this.context_data_length));
            t.add(new KVP("context_data_byte", this.context_data_byte));
            return t;
        }
    }

    public static class Binding
    implements TreeNode {
        private final BIOPName biopName;
        private final int bindingType;
        private final IOR ior;
        private final int objectInfo_length;
        private final byte[] objectInfo_data_byte;
        private int len = 0;

        public Binding(byte[] data, int offset) {
            this.biopName = new BIOPName(data, offset);
            this.len = this.biopName.getLen();
            this.bindingType = Utils.getInt(data, offset + this.len, 1, 255);
            ++this.len;
            this.ior = new IOR(data, offset + this.len);
            this.len += this.ior.getLength();
            this.objectInfo_length = Utils.getInt(data, offset + this.len, 2, 65535);
            this.len += 2;
            this.objectInfo_data_byte = Arrays.copyOfRange(data, offset + this.len, offset + this.len + this.objectInfo_length);
            this.len += this.objectInfo_length;
        }

        @Override
        public KVP getJTreeNode(int modus) {
            KVP t = new KVP("Binding", this.biopName.getName());
            t.add(this.biopName.getJTreeNode(modus));
            t.add(new KVP("bindingType", this.bindingType, BIOPDirectoryMessage.getBindingTypeString(this.bindingType)));
            t.add(this.ior.getJTreeNode(modus));
            return t;
        }

        public int length() {
            return this.len;
        }

        public BIOPName getBiopName() {
            return this.biopName;
        }

        public int getBindingType() {
            return this.bindingType;
        }

        public IOR getIor() {
            return this.ior;
        }

        public int getObjectInfo_length() {
            return this.objectInfo_length;
        }

        public byte[] getObjectInfo_data_byte() {
            return this.objectInfo_data_byte;
        }

        public int getLen() {
            return this.len;
        }
    }
}

