/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.dsmcc;

import java.util.ArrayList;
import java.util.List;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.dsmcc.DSMCCDescriptorFactory;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.Tap;
import nl.digitalekabeltelevisie.util.Utils;

public class BIOPModuleInfo
implements TreeNode {
    private final long moduleTimeOut;
    private final long blockTimeOut;
    private final long minBlockTime;
    private final int taps_count;
    private List<Tap> taps = new ArrayList<Tap>();
    private final int userInfoLength;
    private List<Descriptor> descriptors;

    public BIOPModuleInfo(byte[] data, int offset) {
        this.moduleTimeOut = Utils.getLong(data, offset, 4, -1L);
        this.blockTimeOut = Utils.getLong(data, offset + 4, 4, -1L);
        this.minBlockTime = Utils.getLong(data, offset + 8, 4, -1L);
        this.taps_count = Utils.getInt(data, offset + 12, 1, 255);
        int off = offset + 13;
        for (int i = 0; i < this.taps_count; ++i) {
            Tap tap = new Tap(data, off);
            this.taps.add(tap);
            off += tap.getSelector_length() + 7;
        }
        this.userInfoLength = Utils.getInt(data, off, 1, 255);
        this.descriptors = DSMCCDescriptorFactory.buildDescriptorList(data, off + 1, this.userInfoLength);
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = new KVP("BIOP::ModuleInfo");
        t.add(new KVP("ModuleTimeOut", this.moduleTimeOut));
        t.add(new KVP("BlockTimeOut", this.blockTimeOut));
        t.add(new KVP("MinBlockTime", this.minBlockTime));
        t.add(new KVP("taps_count", this.taps_count));
        t.addList(this.taps, modus, "BIOP::Taps");
        t.add(new KVP("userInfoLength", this.userInfoLength));
        t.addList(this.descriptors, modus, "descriptors");
        return t;
    }

    public long getModuleTimeOut() {
        return this.moduleTimeOut;
    }

    public long getBlockTimeOut() {
        return this.blockTimeOut;
    }

    public long getMinBlockTime() {
        return this.minBlockTime;
    }

    public int getTaps_count() {
        return this.taps_count;
    }

    public List<Tap> getTaps() {
        return this.taps;
    }

    public int getUserInfoLength() {
        return this.userInfoLength;
    }

    public List<Descriptor> getDescriptors() {
        return this.descriptors;
    }
}

