/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.dsmcc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.util.Utils;

public class BIOPName
implements TreeNode {
    private final int nameComponents_count;
    private final List<NameComponent> nameComponents = new ArrayList<NameComponent>();
    private int len = 0;

    public BIOPName(byte[] data, int r) {
        this.nameComponents_count = Utils.getInt(data, r, 1, 255);
        ++this.len;
        for (int i = 0; i < this.nameComponents_count; ++i) {
            int id_length = Utils.getInt(data, r + this.len, 1, 255);
            ++this.len;
            byte[] id_data_byte = Arrays.copyOfRange(data, r + this.len, r + this.len + id_length);
            this.len += id_length;
            int kind_length = Utils.getInt(data, r + this.len, 1, 255);
            ++this.len;
            byte[] kind_data_byte = Arrays.copyOfRange(data, r + this.len, r + this.len + kind_length);
            this.len += kind_length;
            NameComponent nameComponent = new NameComponent(id_length, id_data_byte, kind_length, kind_data_byte);
            this.nameComponents.add(nameComponent);
        }
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = new KVP("BIOP::Name");
        t.add(new KVP("nameComponents_count", this.nameComponents_count));
        t.addList(this.nameComponents, modus, "Name Components");
        return t;
    }

    public int getNameComponents_count() {
        return this.nameComponents_count;
    }

    public List<NameComponent> getNameComponents() {
        return this.nameComponents;
    }

    public int getLen() {
        return this.len;
    }

    public String getName() {
        String r = null;
        NameComponent comp = this.nameComponents.getFirst();
        if (comp != null) {
            byte[] b = Arrays.copyOfRange(comp.id_data_byte(), 0, comp.id_length() - 1);
            r = Utils.toSafeString(b);
        }
        return r;
    }

    public record NameComponent(int id_length, byte[] id_data_byte, int kind_length, byte[] kind_data_byte) implements TreeNode
    {
        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("NameComponent"));
            t.add(new DefaultMutableTreeNode(new KVP("id_length", this.id_length, null)));
            t.add(new DefaultMutableTreeNode(new KVP("id_data_byte", this.id_data_byte, null)));
            t.add(new DefaultMutableTreeNode(new KVP("kind_length", this.kind_length, null)));
            t.add(new DefaultMutableTreeNode(new KVP("kind_data_byte", this.kind_data_byte, null)));
            return t;
        }
    }
}

