/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.dsmcc;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.DSMCC_DownLoadDataMessageSection;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.DSMCC_StreamDescriptorList;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.DSMCC_UNMessageSection;
import nl.digitalekabeltelevisie.data.mpeg.psi.AbstractPSITabel;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSectionExtendedSyntax;

public class DSMCC
extends AbstractPSITabel {
    private final Map<Integer, DSMCC_UNMessageSection[]> unMessages = new HashMap<Integer, DSMCC_UNMessageSection[]>();
    private final Map<Integer, DSMCC_DownLoadDataMessageSection[]> downloadMessages = new HashMap<Integer, DSMCC_DownLoadDataMessageSection[]>();
    private final Map<Integer, DSMCC_StreamDescriptorList[]> eventStreams = new HashMap<Integer, DSMCC_StreamDescriptorList[]>();
    private int pid = 0;
    private boolean isObjectCarousel = true;
    private static final Logger logger = Logger.getLogger(DSMCC.class.getName());

    public DSMCC(PSI parent, boolean isObjectCarousel) {
        super(parent);
        this.isObjectCarousel = isObjectCarousel;
    }

    public void update(TableSectionExtendedSyntax section) {
        this.pid = section.getParentPID().getPid();
        int tableID = section.getTableId();
        switch (tableID) {
            case 59: {
                int tableIdExt = section.getTableIdExtension();
                DSMCC_UNMessageSection[] sections = this.unMessages.get(tableIdExt);
                DSMCC_UNMessageSection unMessage = new DSMCC_UNMessageSection(section.getRaw_data(), section.getParentPID(), this.isObjectCarousel);
                if (sections == null) {
                    sections = new DSMCC_UNMessageSection[section.getSectionLastNumber() + 1];
                    this.unMessages.put(tableIdExt, sections);
                }
                if (sections[section.getSectionNumber()] == null) {
                    sections[section.getSectionNumber()] = unMessage;
                    break;
                }
                DSMCC_UNMessageSection last = sections[section.getSectionNumber()];
                DSMCC.updateSectionVersion(unMessage, last);
                break;
            }
            case 60: {
                int moduleID = section.getTableIdExtension();
                DSMCC_DownLoadDataMessageSection downloadMessage = new DSMCC_DownLoadDataMessageSection(section.getRaw_data(), section.getParentPID());
                DSMCC_DownLoadDataMessageSection[] sections = this.downloadMessages.computeIfAbsent(moduleID, k -> new DSMCC_DownLoadDataMessageSection[section.getSectionLastNumber() + 1]);
                if (section.getSectionNumber() <= section.getSectionLastNumber()) {
                    if (section.getSectionLastNumber() >= sections.length) {
                        sections = Arrays.copyOf(sections, section.getSectionLastNumber() + 1);
                        this.downloadMessages.put(moduleID, sections);
                    }
                    if (sections[section.getSectionNumber()] == null) {
                        sections[section.getSectionNumber()] = downloadMessage;
                        break;
                    }
                    DSMCC_DownLoadDataMessageSection last = sections[section.getSectionNumber()];
                    DSMCC.updateSectionVersion(downloadMessage, last);
                    break;
                }
                logger.info("SectionNumber > lastSectionNumber: pid:" + this.pid + ",section.getSectionNumber:" + section.getSectionNumber() + " section.getSectionLastNumber:" + section.getSectionLastNumber() + ",tableID:" + tableID);
                break;
            }
            case 61: {
                int eventID = section.getTableIdExtension();
                DSMCC_StreamDescriptorList streamDescriptorListSection = new DSMCC_StreamDescriptorList(section.getRaw_data(), section.getParentPID());
                DSMCC_StreamDescriptorList[] sections = this.eventStreams.computeIfAbsent(eventID, k -> new DSMCC_StreamDescriptorList[section.getSectionLastNumber() + 1]);
                if (sections[section.getSectionNumber()] == null) {
                    sections[section.getSectionNumber()] = streamDescriptorListSection;
                    break;
                }
                DSMCC_StreamDescriptorList last = sections[section.getSectionNumber()];
                DSMCC.updateSectionVersion(streamDescriptorListSection, last);
                break;
            }
            default: {
                logger.info("Unhandled tableId: pid:" + this.pid + ",section.getSectionNumber:" + section.getSectionNumber() + " section.getSectionLastNumber:" + section.getSectionLastNumber() + ",tableID:" + tableID);
            }
        }
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP n;
        TableSectionExtendedSyntax[] sections;
        KVP t = new KVP("DSM-CC PID", this.pid);
        TreeSet<Integer> s = new TreeSet<Integer>(this.unMessages.keySet());
        for (Integer type : s) {
            sections = this.unMessages.get(type);
            n = new KVP("DSM-CC UN-Message", type);
            for (DSMCC_UNMessageSection dSMCC_UNMessageSection : sections) {
                if (dSMCC_UNMessageSection == null) continue;
                DSMCC.addSectionVersionsToJTree(n, dSMCC_UNMessageSection, modus);
            }
            t.add(n);
        }
        s = new TreeSet<Integer>(this.downloadMessages.keySet());
        for (Integer type : s) {
            sections = this.downloadMessages.get(type);
            n = new KVP("DSM-CC DownloadMessage ModuleID", type);
            for (TableSectionExtendedSyntax tableSectionExtendedSyntax : sections) {
                if (tableSectionExtendedSyntax == null) continue;
                DSMCC.addSectionVersionsToJTree(n, tableSectionExtendedSyntax, modus);
            }
            t.add(n);
        }
        s = new TreeSet<Integer>(this.eventStreams.keySet());
        for (Integer type : s) {
            sections = this.eventStreams.get(type);
            n = new KVP("DSM-CC Stream Descriptor List", type);
            for (TableSectionExtendedSyntax tableSectionExtendedSyntax : sections) {
                if (tableSectionExtendedSyntax == null) continue;
                DSMCC.addSectionVersionsToJTree(n, tableSectionExtendedSyntax, modus);
            }
            t.add(n);
        }
        return t;
    }

    public DSMCC_UNMessageSection getDSI() {
        DSMCC_UNMessageSection[] res = this.unMessages.get(0);
        if (res == null) {
            res = this.unMessages.get(1);
        }
        if (res != null) {
            return res[0];
        }
        return null;
    }

    public DSMCC_UNMessageSection getDII(int transactionID) {
        DSMCC_UNMessageSection[] res = this.unMessages.get(transactionID);
        if (res == null) {
            res = this.unMessages.get(transactionID ^ 1);
        }
        if (res != null) {
            return res[0];
        }
        return null;
    }

    public DSMCC_DownLoadDataMessageSection[] getDDM(int modId) {
        return this.downloadMessages.get(modId);
    }

    public byte[] getDDMbytes(int modId) {
        DSMCC_DownLoadDataMessageSection[] sections = this.downloadMessages.get(modId);
        if (sections == null) {
            return null;
        }
        int len = 0;
        for (DSMCC_DownLoadDataMessageSection s : sections) {
            if (s != null) {
                len += s.getPayLoadLength();
                continue;
            }
            return null;
        }
        byte[] res = new byte[len];
        int i = 0;
        for (DSMCC_DownLoadDataMessageSection s : sections) {
            int thisLen = s.getPayLoadLength();
            System.arraycopy(s.getPayLoad(), 0, res, i, thisLen);
            i += thisLen;
        }
        return res;
    }

    public byte[] getDDMbytes(DSMCC_UNMessageSection.ModuleInfo moduleInfo) {
        int modId = moduleInfo.getModuleId();
        int version = moduleInfo.getModuleVersion();
        DSMCC_DownLoadDataMessageSection[] sections = this.downloadMessages.get(modId);
        if (sections == null) {
            return null;
        }
        int len = 0;
        for (DSMCC_DownLoadDataMessageSection s : sections) {
            if (s == null) {
                return null;
            }
            while (s != null && s.getModuleVersion() != version) {
                s = (DSMCC_DownLoadDataMessageSection)s.getNextVersion();
            }
            if (s != null && s.getModuleVersion() == version) {
                len += s.getPayLoadLength();
                continue;
            }
            return null;
        }
        if ((long)len != moduleInfo.getModuleSize()) {
            return null;
        }
        byte[] res = new byte[len];
        int i = 0;
        DSMCC_DownLoadDataMessageSection[] dSMCC_DownLoadDataMessageSectionArray = sections;
        int n = dSMCC_DownLoadDataMessageSectionArray.length;
        for (int j = 0; j < n; ++j) {
            DSMCC_DownLoadDataMessageSection s;
            for (s = dSMCC_DownLoadDataMessageSectionArray[j]; s != null && s.getModuleVersion() != version; s = (DSMCC_DownLoadDataMessageSection)s.getNextVersion()) {
            }
            if (s != null) {
                int thisLen = s.getPayLoadLength();
                System.arraycopy(s.getPayLoad(), 0, res, i, thisLen);
                i += thisLen;
                continue;
            }
            return null;
        }
        return res;
    }

    public int getPid() {
        return this.pid;
    }
}

