/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.dsmcc;

import java.util.List;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DescriptorFactory;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSectionExtendedSyntax;

public class DSMCC_StreamDescriptorList
extends TableSectionExtendedSyntax {
    private List<Descriptor> descriptorList;

    public DSMCC_StreamDescriptorList(PsiSectionData raw_data, PID parent) {
        super(raw_data, parent);
        this.descriptorList = DescriptorFactory.buildDescriptorList(raw_data.getData(), 8, this.sectionLength - 9, this);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("DSMCC_StreamDescriptorList section=");
        b.append(this.getSectionNumber()).append(", lastSection=").append(this.getSectionLastNumber());
        return b.toString();
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = (KVP)super.getJTreeNode(modus);
        t.addList(this.descriptorList, modus, "descriptors");
        return t;
    }

    @Override
    protected String getTableIdExtensionDescription(int tableIdExtension) {
        int type = (tableIdExtension & 0xC000) >> 14;
        return switch (type) {
            case 0 -> "Section carries a single \"do it now\" event, eventID=" + (tableIdExtension & 0x3FFF);
            case 1 -> "Section carries NPT reference descriptors";
            case 2 -> "Section carries one or more other stream descriptors";
            case 3 -> "reserved for future use";
            default -> "Illegal value";
        };
    }

    public List<Descriptor> getDescriptorList() {
        return this.descriptorList;
    }

    public void setDescriptorList(List<Descriptor> descriptorList) {
        this.descriptorList = descriptorList;
    }
}

