/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.dsmcc;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.AssociationTagDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.CarouselIdentifierDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DataBroadcastIDDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.StreamIdentifierDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.DSMCC;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.ServiceDSMCC;
import nl.digitalekabeltelevisie.data.mpeg.psi.AbstractPSITabel;
import nl.digitalekabeltelevisie.data.mpeg.psi.PMTs;
import nl.digitalekabeltelevisie.data.mpeg.psi.PMTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSectionExtendedSyntax;
import nl.digitalekabeltelevisie.util.PreferencesManager;

public class DSMCCs
extends AbstractPSITabel {
    private static final Logger logger = Logger.getLogger(DSMCCs.class.getName());
    private final PMTs pmts;
    private final Map<Integer, DSMCC> dsmccs = new TreeMap<Integer, DSMCC>();
    private final Map<Integer, ServiceDSMCC> objectCarousels = new TreeMap<Integer, ServiceDSMCC>();

    public DSMCCs(PSI parentPSI) {
        super(parentPSI);
        this.pmts = parentPSI.getPmts();
    }

    public void update(TableSectionExtendedSyntax section) {
        int pid = section.getParentPID().getPid();
        DataType dataType = this.determineDataTypeFromPSI(pid);
        if (dataType == DataType.UNKNOW) {
            logger.warning("Not supported type; pid:" + pid);
            return;
        }
        DSMCC dsmcc = this.dsmccs.computeIfAbsent(pid, k -> new DSMCC(this.parentPSI, dataType == DataType.OBJECT_CAROUSEL));
        dsmcc.update(section);
        if (dataType == DataType.OBJECT_CAROUSEL) {
            for (PMTsection[] pmtTable : this.pmts) {
                PMTsection pmt = pmtTable[0];
                List<PMTsection.Component> componentsList = pmt.getComponentenList();
                for (PMTsection.Component component : componentsList) {
                    if (component.getElementaryPID() != pid) continue;
                    int programNumber = pmt.getProgramNumber();
                    ServiceDSMCC carousel = this.objectCarousels.computeIfAbsent(programNumber, k -> new ServiceDSMCC(programNumber));
                    int associationTag = -1;
                    List<Descriptor> componentDescriptorList = component.getComponentDescriptorList();
                    List<AssociationTagDescriptor> associationDescriptorsList = Descriptor.findGenericDescriptorsInList(componentDescriptorList, AssociationTagDescriptor.class);
                    if (!associationDescriptorsList.isEmpty()) {
                        associationTag = associationDescriptorsList.getFirst().getAssociationTag();
                    } else {
                        List<StreamIdentifierDescriptor> streamidentifierDescriptorsList = Descriptor.findGenericDescriptorsInList(componentDescriptorList, StreamIdentifierDescriptor.class);
                        if (!streamidentifierDescriptorsList.isEmpty()) {
                            associationTag = streamidentifierDescriptorsList.getFirst().getComponentTag();
                        }
                    }
                    if (associationTag < 0) continue;
                    carousel.addDSMCC(associationTag, dsmcc);
                    List<DataBroadcastIDDescriptor> dataBroadcastIdDescriptorsList = Descriptor.findGenericDescriptorsInList(componentDescriptorList, DataBroadcastIDDescriptor.class);
                    if (dataBroadcastIdDescriptorsList.isEmpty()) continue;
                    int dataBroadCastId = dataBroadcastIdDescriptorsList.getFirst().getDataBroadcastId();
                    carousel.addBootPID(associationTag, dataBroadCastId);
                    List<CarouselIdentifierDescriptor> carouselIdentifierDescriptorsList = Descriptor.findGenericDescriptorsInList(componentDescriptorList, CarouselIdentifierDescriptor.class);
                    if (carouselIdentifierDescriptorsList.isEmpty()) continue;
                    CarouselIdentifierDescriptor carouselIdentifierDescriptor = carouselIdentifierDescriptorsList.getFirst();
                    carousel.setCarouselIdentifierDescriptor(associationTag, carouselIdentifierDescriptor);
                }
            }
        }
    }

    private DataType determineDataTypeFromPSI(int pid) {
        for (PMTsection[] pmtTable : this.pmts) {
            PMTsection pmt = pmtTable[0];
            if (!pmt.hasComponentWithPid(pid)) continue;
            List<PMTsection.Component> comps = pmt.getComponentenList();
            for (PMTsection.Component c1 : comps) {
                List<DataBroadcastIDDescriptor> dataBroadcastIdDescriptorsList = Descriptor.findGenericDescriptorsInList(c1.getComponentDescriptorList(), DataBroadcastIDDescriptor.class);
                if (dataBroadcastIdDescriptorsList.isEmpty()) continue;
                DataBroadcastIDDescriptor dataBroadcastIDDescriptor = dataBroadcastIdDescriptorsList.getFirst();
                if (dataBroadcastIDDescriptor.describesObjectCarousel()) {
                    return DataType.OBJECT_CAROUSEL;
                }
                if (!dataBroadcastIDDescriptor.describesSSU()) continue;
                return DataType.SSU;
            }
        }
        return DataType.UNKNOW;
    }

    @Override
    public KVP getJTreeNode(int modus) {
        if (!PreferencesManager.isEnableDSMCC()) {
            return new KVP("DSM-CCs (not enabled, select 'Settings -> Enable DSM-CC' to enable )");
        }
        KVP t = new KVP("DSM-CCs");
        this.dsmccs.values().parallelStream().map(k -> k.getJTreeNode(modus)).forEachOrdered(t::add);
        this.objectCarousels.values().parallelStream().map(k -> k.getJTreeNode(modus)).forEachOrdered(t::add);
        return t;
    }

    private static enum DataType {
        UNKNOW,
        SSU,
        OBJECT_CAROUSEL,
        OTHER;

    }
}

