/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.dsmcc;

import java.util.ArrayList;
import java.util.List;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.LiteComponent;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.Tap;
import nl.digitalekabeltelevisie.util.Utils;

public class DSMConnBinder
extends LiteComponent {
    protected int taps_count;
    protected List<Tap> taps = new ArrayList<Tap>();

    public DSMConnBinder(byte[] data, int offset) {
        super(data, offset);
        this.taps_count = Utils.getInt(data, offset + 5, 1, 255);
        for (int i = 0; i < this.taps_count; ++i) {
            Tap tap = new Tap(data, offset + 6 + i * 17);
            this.taps.add(tap);
        }
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = new KVP("DSM::ConnBinder");
        t.add(new KVP("component_tag", this.component_tag, DSMConnBinder.getComponentTagString((int)this.component_tag)));
        t.add(new KVP("component_data_length", this.component_data_length));
        t.add(new KVP("taps_count", this.taps_count));
        t.addList(this.taps, modus, "BIOP::Taps");
        return t;
    }

    public int getTaps_count() {
        return this.taps_count;
    }

    public List<Tap> getTaps() {
        return this.taps;
    }
}

