/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.dsmcc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.TaggedProfile;
import nl.digitalekabeltelevisie.util.Utils;

public class IOR
implements TreeNode {
    private final long type_id_length;
    private byte[] type_id = null;
    private final long taggedProfiles_count;
    private List<TaggedProfile> profiles = null;
    private final int length;
    public static final byte[] TYPE_DIRECTORY = new byte[]{100, 105, 114, 0};
    public static final byte[] TYPE_FILE = new byte[]{102, 105, 108, 0};
    public static final byte[] TYPE_STREAM = new byte[]{115, 116, 114, 0};
    public static final byte[] TYPE_SERVICEGATEWAY = new byte[]{115, 114, 103, 0};
    public static final byte[] TYPE_STREAMEVENT = new byte[]{115, 116, 101, 0};

    public IOR(byte[] privateDataByte, int offset) {
        this.type_id_length = Utils.getLong(privateDataByte, offset + 0, 4, -1L);
        this.type_id = Arrays.copyOfRange(privateDataByte, offset + 4, offset + 4 + (int)this.type_id_length);
        this.taggedProfiles_count = Utils.getLong(privateDataByte, offset + 4 + (int)this.type_id_length, 4, -1L);
        this.profiles = new ArrayList<TaggedProfile>((int)this.taggedProfiles_count);
        int r = 8 + (int)this.type_id_length;
        int i = 0;
        while ((long)i < this.taggedProfiles_count) {
            TaggedProfile tp = new TaggedProfile(privateDataByte, offset + r);
            r = (int)((long)r + (tp.getProfile_data_length() + 8L));
            this.profiles.add(tp);
            ++i;
        }
        this.length = r;
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = new KVP("IOP::IOR");
        t.add(new KVP("type_id_length", this.type_id_length));
        t.add(new KVP("type_id", this.type_id, IOR.getTypeIdString(this.type_id)));
        t.add(new KVP("taggedProfiles_count", this.taggedProfiles_count));
        Utils.addListJTree(t, this.profiles, modus, "TaggedProfiles");
        return t;
    }

    public static String getTypeIdString(byte[] typeId) {
        if (Utils.equals(typeId, 0, typeId.length, TYPE_DIRECTORY, 0, TYPE_DIRECTORY.length)) {
            return "DSM::Directory";
        }
        if (Utils.equals(typeId, 0, typeId.length, TYPE_FILE, 0, TYPE_FILE.length)) {
            return "DSM::File";
        }
        if (Utils.equals(typeId, 0, typeId.length, TYPE_STREAM, 0, TYPE_STREAM.length)) {
            return "DSM::Stream";
        }
        if (Utils.equals(typeId, 0, typeId.length, TYPE_SERVICEGATEWAY, 0, TYPE_SERVICEGATEWAY.length)) {
            return "DSM::ServiceGateway";
        }
        if (Utils.equals(typeId, 0, typeId.length, TYPE_STREAMEVENT, 0, TYPE_STREAMEVENT.length)) {
            return "DSM::StreamEvent";
        }
        return null;
    }

    public long getType_id_length() {
        return this.type_id_length;
    }

    public byte[] getType_id() {
        return this.type_id;
    }

    public long getTaggedProfiles_count() {
        return this.taggedProfiles_count;
    }

    public List<TaggedProfile> getProfiles() {
        return this.profiles;
    }

    public int getLength() {
        return this.length;
    }
}

