/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.dsmcc;

import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.util.Utils;

public class LiteComponent
implements TreeNode {
    protected long component_tag;
    protected int component_data_length;

    public LiteComponent(byte[] data, int offset) {
        this.component_tag = Utils.getLong(data, offset, 4, -1L);
        this.component_data_length = Utils.getInt(data, offset + 4, 1, 255);
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = new KVP("LiteComponent");
        t.add(new KVP("component_tag", this.component_tag, LiteComponent.getComponentTagString((int)this.component_tag)));
        t.add(new KVP("component_data_length", this.component_data_length));
        return t;
    }

    public static String getComponentTagString(int tag) {
        return switch (tag) {
            case 1230196480 -> "TAG_MIN";
            case 1230196481 -> "TAG_CHILD";
            case 1230196482 -> "TAG_OPTIONS";
            case 1230196483 -> "TAG_LITE_MIN";
            case 1230196484 -> "TAG_LITE_CHILD";
            case 1230196485 -> "TAG_LITE_OPTIONS";
            case 1230196486 -> "TAG_BIOP";
            case 1230196487 -> "TAG_ONC";
            case 1230196544 -> "TAG_ConnBinder";
            case 1230196545 -> "TAG_IIOPAddr";
            case 1230196546 -> "TAG_Addr";
            case 1230196547 -> "TAG_NameId";
            case 1230196548 -> "TAG_IntfCode";
            case 1230196549 -> "TAG_ObjectKey";
            case 1230196550 -> "TAG_ServiceLocation";
            case 1230196560 -> "TAG_ObjectLocation";
            case 1230196568 -> "TAG_Intf";
            default -> "unknown";
        };
    }

    public long getComponentTag() {
        return this.component_tag;
    }

    public int getComponentDataLength() {
        return this.component_data_length;
    }
}

