/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.dsmcc;

import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.DSMCC_UNMessageSection;
import nl.digitalekabeltelevisie.util.Utils;

public class Tap
implements TreeNode {
    private final int id;
    private final int use;
    private final int association_tag;
    private final int selector_length;
    private int selector_type;
    private long transactionId;
    private long timeout;

    public Tap(byte[] data, int offset) {
        this.id = Utils.getInt(data, offset, 2, 65535);
        this.use = Utils.getInt(data, offset + 2, 2, 65535);
        this.association_tag = Utils.getInt(data, offset + 4, 2, 65535);
        this.selector_length = Utils.getInt(data, offset + 6, 1, 255);
        if (this.use == 22) {
            this.selector_type = Utils.getInt(data, offset + 7, 2, 65535);
            this.transactionId = Utils.getLong(data, offset + 9, 4, -1L);
            this.timeout = Utils.getLong(data, offset + 13, 4, -1L);
        }
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = new KVP("BIOP::Tap");
        t.add(new KVP("id", this.id));
        t.add(new KVP("use", this.use, Tap.getUseString(this.use)));
        t.add(new KVP("association_tag", this.association_tag));
        t.add(new KVP("selector_length", this.selector_length));
        if (this.use == 22) {
            t.add(new KVP("selector_type", this.selector_type));
            t.add(new KVP("transactionId", this.transactionId, DSMCC_UNMessageSection.getTransactionIDString(this.transactionId)));
            t.add(new KVP("timeout", this.timeout));
        }
        return t;
    }

    public static String getUseString(int use) {
        return switch (use) {
            case 0 -> "UNKNOWN";
            case 1 -> "MPEG_TS_UP_USE";
            case 2 -> "MPEG_TS_DOWN_USE";
            case 3 -> "MPEG_ES_UP_USE";
            case 4 -> "MPEG_ES_DOWN_USE";
            case 5 -> "DOWNLOAD_CTRL_USE";
            case 6 -> "DOWNLOAD_CTRL_UP_USE";
            case 7 -> "DOWNLOAD_CTRL_DOWN_USE";
            case 8 -> "DOWNLOAD_DATA_USE";
            case 9 -> "DOWNLOAD_DATA_UP_USE";
            case 10 -> "DOWNLOAD_DATA_DOWN_USE";
            case 11 -> "STR_NPT_USE";
            case 12 -> "STR_STATUS_AND_EVENT_USE";
            case 13 -> "STR_EVENT_USE";
            case 14 -> "STR_STATUS_USE";
            case 15 -> "RPC_USE";
            case 16 -> "IP_USE";
            case 17 -> "SDB_CTRL_USE";
            case 21 -> "T120_TAP reserved";
            case 22 -> "BIOP_DELIVERY_PARA_USE";
            case 23 -> "BIOP_OBJECT_USE";
            case 24 -> "BIOP_ES_USE";
            case 25 -> "BIOP_PROGRAM_USE";
            case 26 -> "BIOP_DNL_CTRL_USE";
            default -> "unknown";
        };
    }

    public int getId() {
        return this.id;
    }

    public int getUse() {
        return this.use;
    }

    public int getAssociation_tag() {
        return this.association_tag;
    }

    public int getSelector_length() {
        return this.selector_length;
    }

    public int getSelector_type() {
        return this.selector_type;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public long getTimeout() {
        return this.timeout;
    }
}

