/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class PesHeader
implements TreeNode {
    private static final LookUpList stream_id_extension_list = new LookUpList.Builder().add(0, "IPMP control information stream").add(1, "IPMP stream").add(2, 15, "ISO/IEC 14496-17 text stream").add(16, 31, "ISO/IEC 23002-3 auxiliary video stream").add(32, 63, "reserved_data_stream").add(64, "private_stream").add(65, "AVS3 video sequence stream").add(66, "AVS3 video library stream").add(67, 78, "may be used by AVS standards in the future").add(79, "AVS3 audio stream").add(80, 127, "private_stream").build();
    private final byte[] data;
    private final int offset;
    private int stream_id;
    private int pes_packet_length;
    private int markerBits;
    private int pes_scrambling_control;
    private int pes_priority;
    private int data_alignment_indicator;
    private int copyright;
    private int original_or_copy;
    private int pts_dts_flags;
    private int escr_flag;
    private int es_rate_flag;
    private int dsm_trick_mode_flag;
    private int additional_copy_info_flag;
    private int pes_crc_flag;
    private int pes_extension_flag;
    private int pes_header_data_length;
    private long pts;
    private long dts;
    private byte[] escr;
    private int es_rate;
    private int trick_mode_control;
    private int trick_mode_detail;
    private int additional_copy_info;
    private int previous_PES_packet_CRC;
    private int pes_private_data_flag;
    private int pack_header_field_flag;
    private int program_packet_sequence_counter_flag;
    private int p_std_buffer_flag;
    private int reserved;
    private int pes_extension_flag_2;
    private byte[] pes_private_data;
    private int pack_field_length;
    private byte[] pack_header;
    private AdDescriptor adDescriptor;
    private int program_packet_sequence_counter;
    private int mpeg1_mpeg2_identifier;
    private int original_stuff_length;
    private int p_std_buffer_scale;
    private int p_std_buffer_size;
    private int pes_extension_field_length;
    private int stream_id_extension_flag;
    private int stream_id_extension;
    private int tref_extension_flag;
    private int reserved_extension2;
    private long tref;

    public PesHeader(byte[] data, int offset) {
        this.data = data;
        this.offset = offset;
        this.stream_id = Utils.getInt(data, offset + 3, 1, 255);
        this.pes_packet_length = Utils.getInt(data, offset + 4, 2, 65535);
        if (PesHeader.hasExtendedHeader(this.stream_id)) {
            this.markerBits = Utils.getInt(data, offset + 6, 1, 192) >> 6;
            this.pes_scrambling_control = Utils.getInt(data, offset + 6, 1, 48) >> 4;
            this.pes_priority = Utils.getInt(data, offset + 6, 1, 8) >> 3;
            this.data_alignment_indicator = Utils.getInt(data, offset + 6, 1, 4) >> 2;
            this.copyright = Utils.getInt(data, offset + 6, 1, 2) >> 1;
            this.original_or_copy = Utils.getInt(data, offset + 6, 1, 1);
            this.pts_dts_flags = Utils.getInt(data, offset + 7, 1, 192) >> 6;
            this.escr_flag = Utils.getInt(data, offset + 7, 1, 32) >> 5;
            this.es_rate_flag = Utils.getInt(data, offset + 7, 1, 16) >> 4;
            this.dsm_trick_mode_flag = Utils.getInt(data, offset + 7, 1, 8) >> 3;
            this.additional_copy_info_flag = Utils.getInt(data, offset + 7, 1, 4) >> 2;
            this.pes_crc_flag = Utils.getInt(data, offset + 7, 1, 2) >> 1;
            this.pes_extension_flag = Utils.getInt(data, offset + 7, 1, 1);
            this.pes_header_data_length = Utils.getInt(data, offset + 8, 1, 255);
            int off = offset + 9;
            if (PesHeader.hasPTS(this.pts_dts_flags)) {
                this.pts = PesHeader.getTimeStamp(data, off);
                off += 5;
            }
            if (this.pts_dts_flags == 3) {
                this.dts = PesHeader.getTimeStamp(data, off);
                off += 5;
            }
            if (this.escr_flag == 1) {
                this.escr = Utils.getBytes(data, off, 6);
                off += 6;
            }
            if (this.es_rate_flag == 1) {
                this.es_rate = Utils.getInt(data, off, 3, 0xFFFFFE) >> 1;
                off += 3;
            }
            if (this.dsm_trick_mode_flag == 1) {
                this.trick_mode_control = Utils.getInt(data, off, 1, 224) >> 5;
                this.trick_mode_detail = Utils.getInt(data, off, 1, 31);
                ++off;
            }
            if (this.additional_copy_info_flag == 1) {
                this.additional_copy_info = Utils.getInt(data, off, 1, 127);
                ++off;
            }
            if (this.pes_crc_flag == 1) {
                this.previous_PES_packet_CRC = Utils.getInt(data, off, 2, 65535);
                off += 2;
            }
            if (this.pes_extension_flag == 1) {
                this.pes_private_data_flag = Utils.getInt(data, off, 1, 128) >> 7;
                this.pack_header_field_flag = Utils.getInt(data, off, 1, 64) >> 6;
                this.program_packet_sequence_counter_flag = Utils.getInt(data, off, 1, 32) >> 5;
                this.p_std_buffer_flag = Utils.getInt(data, off, 1, 16) >> 4;
                this.reserved = Utils.getInt(data, off, 1, 14) >> 1;
                this.pes_extension_flag_2 = Utils.getInt(data, off, 1, 1);
                ++off;
                if (this.pes_private_data_flag == 1) {
                    this.pes_private_data = Utils.getBytes(data, off, 16);
                    off += 16;
                    if (Utils.indexOf(this.pes_private_data, new byte[]{68, 84, 71, 65, 68}, 0) == 1) {
                        this.adDescriptor = new AdDescriptor(this, this.pes_private_data);
                    }
                }
                if (this.pack_header_field_flag == 1) {
                    this.pack_field_length = Utils.getInt(data, off, 1, 255);
                    this.pack_header = Utils.getBytes(data, ++off, this.pack_field_length);
                    off += this.pack_field_length;
                }
                if (this.program_packet_sequence_counter_flag == 1) {
                    this.program_packet_sequence_counter = Utils.getInt(data, off, 1, 127);
                    this.mpeg1_mpeg2_identifier = Utils.getInt(data, off + 1, 1, 64) >> 6;
                    this.original_stuff_length = Utils.getInt(data, off + 1, 1, 63);
                    off += 2;
                }
                if (this.p_std_buffer_flag == 1) {
                    this.p_std_buffer_scale = Utils.getInt(data, off, 1, 32) >> 5;
                    this.p_std_buffer_size = Utils.getInt(data, off, 2, 8191);
                    off += 2;
                }
                if (this.pes_extension_flag_2 == 1) {
                    this.pes_extension_field_length = Utils.getInt(data, off, 1, 127);
                    this.stream_id_extension_flag = Utils.getInt(data, ++off, 1, 128) >> 7;
                    if (this.stream_id_extension_flag == 0) {
                        this.stream_id_extension = Utils.getInt(data, off, 1, 127);
                    } else {
                        this.reserved_extension2 = Utils.getInt(data, off, 1, 126) >> 1;
                        this.tref_extension_flag = Utils.getInt(data, off, 1, 1);
                        ++off;
                        if (this.tref_extension_flag == 0) {
                            this.tref = PesHeader.getTimeStamp(data, off);
                            off += 5;
                        }
                    }
                }
            }
        }
    }

    public boolean isValidPesHeader() {
        return this.data.length >= this.offset + 2 && this.data[this.offset] == 0 && this.data[this.offset + 1] == 0 && this.data[this.offset + 2] == 1;
    }

    public int getStreamID() {
        return this.stream_id;
    }

    public int getPesPacketLength() {
        return this.pes_packet_length;
    }

    public void addToJtree(DefaultMutableTreeNode t, int modus) {
        try {
            t.add(new DefaultMutableTreeNode(new KVP("stream_id", this.stream_id, PesHeader.getStreamIDDescription(this.stream_id))));
            t.add(new DefaultMutableTreeNode(new KVP("PES_packet_length", this.pes_packet_length, null)));
            if (PesHeader.hasExtendedHeader(this.stream_id)) {
                t.add(new DefaultMutableTreeNode(new KVP("markerBits", this.markerBits, null)));
                t.add(new DefaultMutableTreeNode(new KVP("pes_scrambling_control", this.pes_scrambling_control, this.pes_scrambling_control == 0 ? "Not scrambled" : "User-defined")));
                t.add(new DefaultMutableTreeNode(new KVP("pes_priority", this.pes_priority, this.pes_priority == 1 ? "higher" : "normal")));
                t.add(new DefaultMutableTreeNode(new KVP("data_alignment_indicator", this.data_alignment_indicator, this.data_alignment_indicator == 1 ? "PES packet header is immediately followed by the video start code or audio syncword indicated in the data_stream_alignment_descriptor" : "alignment not defined")));
                t.add(new DefaultMutableTreeNode(new KVP("copyright", this.copyright, this.copyright == 1 ? "packet payload is protected by copyright" : "not defined whether the material is protected by copyright")));
                t.add(new DefaultMutableTreeNode(new KVP("original_or_copy", this.original_or_copy, this.original_or_copy == 1 ? "contents of the associated PES packet payload is an original" : "contents of the associated PES packet payload is a copy")));
                t.add(new DefaultMutableTreeNode(new KVP("pts_dts_flags", this.pts_dts_flags, PesHeader.getPts_dts_flagsString(this.pts_dts_flags))));
                t.add(new DefaultMutableTreeNode(new KVP("escr_flag", this.escr_flag, this.escr_flag == 1 ? "ESCR base and extension fields are present" : "no ESCR fields are present")));
                t.add(new DefaultMutableTreeNode(new KVP("es_rate_flag", this.es_rate_flag, this.es_rate_flag == 1 ? "ES_rate field is present" : "no ES_rate field is present")));
                t.add(new DefaultMutableTreeNode(new KVP("dsm_trick_mode_flag", this.dsm_trick_mode_flag, this.dsm_trick_mode_flag == 1 ? "8-bit trick mode field is present" : "8-bit trick mode field is not present")));
                t.add(new DefaultMutableTreeNode(new KVP("additional_copy_info_flag", this.additional_copy_info_flag, this.additional_copy_info_flag == 1 ? "additional_copy_info field is present" : "additional_copy_info field is not present")));
                t.add(new DefaultMutableTreeNode(new KVP("pes_crc_flag", this.pes_crc_flag, this.pes_crc_flag == 1 ? "CRC field is present" : "CRC field is not present")));
                t.add(new DefaultMutableTreeNode(new KVP("pes_extension_flag", this.pes_extension_flag, this.pes_extension_flag == 1 ? "extension field is present" : "extension field is not present")));
                t.add(new DefaultMutableTreeNode(new KVP("pes_header_data_length", this.pes_header_data_length, null)));
                if (PesHeader.hasPTS(this.pts_dts_flags)) {
                    t.add(new DefaultMutableTreeNode(new KVP("pts", this.pts, Utils.printTimebase90kHz(this.pts))));
                }
                if (this.pts_dts_flags == 3) {
                    t.add(new DefaultMutableTreeNode(new KVP("dts", this.dts, Utils.printTimebase90kHz(this.dts))));
                }
                if (this.escr_flag == 1) {
                    t.add(new DefaultMutableTreeNode(new KVP("escr", this.escr, null)));
                }
                if (this.es_rate_flag == 1) {
                    t.add(new DefaultMutableTreeNode(new KVP("es_rate", this.es_rate, null)));
                }
                if (this.dsm_trick_mode_flag == 1) {
                    t.add(new DefaultMutableTreeNode(new KVP("trick_mode_control", this.trick_mode_control, null)));
                    t.add(new DefaultMutableTreeNode(new KVP("trick_mode_detail", this.trick_mode_detail, null)));
                }
                if (this.additional_copy_info_flag == 1) {
                    t.add(new DefaultMutableTreeNode(new KVP("additional_copy_info", this.additional_copy_info, null)));
                }
                if (this.pes_crc_flag == 1) {
                    t.add(new DefaultMutableTreeNode(new KVP("previous_PES_packet_CRC", this.previous_PES_packet_CRC, null)));
                }
                if (this.pes_extension_flag == 1) {
                    t.add(new DefaultMutableTreeNode(new KVP("PES_private_data_flag", this.pes_private_data_flag, null)));
                    t.add(new DefaultMutableTreeNode(new KVP("pack_header_field_flag", this.pack_header_field_flag, null)));
                    t.add(new DefaultMutableTreeNode(new KVP("program_packet_sequence_counter_flag", this.program_packet_sequence_counter_flag, null)));
                    t.add(new DefaultMutableTreeNode(new KVP("P-STD_buffer_flag", this.p_std_buffer_flag, null)));
                    t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
                    t.add(new DefaultMutableTreeNode(new KVP("PES_extension_flag_2", this.pes_extension_flag_2, null)));
                    if (this.pes_private_data_flag == 1) {
                        DefaultMutableTreeNode privateDataNode = new DefaultMutableTreeNode(new KVP("PES_private_data", this.pes_private_data, null));
                        t.add(privateDataNode);
                        if (this.adDescriptor != null) {
                            privateDataNode.add(this.adDescriptor.getJTreeNode(modus));
                        }
                    }
                    if (this.pack_header_field_flag == 1) {
                        t.add(new DefaultMutableTreeNode(new KVP("pack_field_length", this.pack_field_length, null)));
                        t.add(new DefaultMutableTreeNode(new KVP("pack_header", this.pack_header, null)));
                    }
                    if (this.program_packet_sequence_counter_flag == 1) {
                        t.add(new DefaultMutableTreeNode(new KVP("program_packet_sequence_counter", this.program_packet_sequence_counter, null)));
                        t.add(new DefaultMutableTreeNode(new KVP("MPEG1_MPEG2_identifier", this.mpeg1_mpeg2_identifier, null)));
                        t.add(new DefaultMutableTreeNode(new KVP("original_stuff_length", this.original_stuff_length, null)));
                    }
                    if (this.p_std_buffer_flag == 1) {
                        t.add(new DefaultMutableTreeNode(new KVP("P-STD_buffer_scale", this.p_std_buffer_scale, null)));
                        t.add(new DefaultMutableTreeNode(new KVP("P-STD_buffer_size", this.p_std_buffer_size, null)));
                    }
                    if (this.pes_extension_flag_2 == 1) {
                        t.add(new DefaultMutableTreeNode(new KVP("pes_extension_field_length", this.pes_extension_field_length, null)));
                        t.add(new DefaultMutableTreeNode(new KVP("stream_id_extension_flag", this.stream_id_extension_flag, null)));
                        if (this.stream_id_extension_flag == 0) {
                            t.add(new DefaultMutableTreeNode(new KVP("stream_id_extension", this.stream_id_extension, PesHeader.getStreamIdExtensionString(this.stream_id_extension))));
                        } else {
                            t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved_extension2, null)));
                            t.add(new DefaultMutableTreeNode(new KVP("tref_extension_flag", this.tref_extension_flag, null)));
                            if (this.tref_extension_flag == 0) {
                                t.add(new DefaultMutableTreeNode(new KVP("TREF", this.tref, Utils.printTimebase90kHz(this.tref))));
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            t.add(new DefaultMutableTreeNode(GuiUtils.getErrorKVP("Error parsing PESHeader")));
        }
    }

    private static String getStreamIdExtensionString(int stream_id_extension_) {
        return stream_id_extension_list.get(stream_id_extension_);
    }

    static boolean hasPTS(int pts_dts_flags) {
        return pts_dts_flags == 2 || pts_dts_flags == 3;
    }

    public boolean hasPTS() {
        return PesHeader.hasPTS(this.getPts_dts_flags());
    }

    public static boolean hasExtendedHeader(int stream_id) {
        return stream_id != 188 && stream_id != 190 && stream_id != 191 && stream_id != 240 && stream_id != 241 && stream_id != 255 && stream_id != 242 && stream_id != 248;
    }

    public boolean hasExtendedHeader() {
        return PesHeader.hasExtendedHeader(this.getStreamID());
    }

    public long getDts() {
        return this.dts;
    }

    public long getPts() {
        return this.pts;
    }

    public final int getPes_header_data_length() {
        return this.pes_header_data_length;
    }

    public int getPes_extension_flag() {
        return this.pes_extension_flag;
    }

    public int getPes_crc_flag() {
        return this.pes_crc_flag;
    }

    public int getAdditional_copy_info_flag() {
        return this.additional_copy_info_flag;
    }

    public int getDsm_trick_mode_flag() {
        return this.dsm_trick_mode_flag;
    }

    public int getEs_rate_flag() {
        return this.es_rate_flag;
    }

    public int getEscr_flag() {
        return this.escr_flag;
    }

    public final int getPts_dts_flags() {
        return this.pts_dts_flags;
    }

    public int getOriginal_or_copy() {
        return this.original_or_copy;
    }

    public int getCopyright() {
        return this.copyright;
    }

    public int getData_alignment_indicator() {
        return this.data_alignment_indicator;
    }

    public int getPes_priority() {
        return this.pes_priority;
    }

    public int getPes_scrambling_control() {
        return this.pes_scrambling_control;
    }

    public int getMarkerBits() {
        return this.markerBits;
    }

    public static final long getTimeStamp(byte[] array, int offset) {
        long ts = Utils.getLong(array, offset, 1, 14L) << 29;
        ts |= Utils.getLong(array, offset + 1, 2, 65534L) << 14;
        return ts |= Utils.getLong(array, offset + 3, 2, 65534L) >> 1;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("Pes Header"));
        this.addToJtree(t, modus);
        return t;
    }

    public static String getPts_dts_flagsString(int pts_dts_flags) {
        switch (pts_dts_flags) {
            case 0: {
                return "no PTS or DTS fields shall be present in the PES packet header";
            }
            case 1: {
                return "forbidden value";
            }
            case 2: {
                return "PTS fields shall be present in the PES packet header";
            }
            case 3: {
                return "both the PTS fields and DTS fields shall be present in the PES packet header";
            }
        }
        return "illegal value (program error)";
    }

    public static String getStreamIDDescription(int streamId) {
        if (192 <= streamId && streamId < 224) {
            return "ISO/IEC 13818-3 or ISO/IEC 11172-3 or ISO/IEC 13818-7 or ISO/IEC 14496-3 or ISO/IEC 23008-3 audio stream number " + Integer.toHexString(streamId & 0x1F);
        }
        if (224 <= streamId && streamId < 240) {
            return "Rec. ITU-T H.262 | ISO/IEC 13818-2, ISO/IEC 11172-2, ISO/IEC 14496-2, Rec. ITU-T H.264 | ISO/IEC 14496-10, Rec. ITU-T H.265 | ISO/IEC 23008-2, Rec. ITU-T H.266 | ISO/IEC 23090-3 or ISO/IEC 23094-1 video stream number " + Integer.toHexString(streamId & 0xF);
        }
        switch (streamId) {
            case 188: {
                return "program_stream_map";
            }
            case 189: {
                return "private_stream_1";
            }
            case 190: {
                return "padding_stream";
            }
            case 191: {
                return "private_stream_2";
            }
            case 240: {
                return "ECM_stream";
            }
            case 241: {
                return "EMM_stream";
            }
            case 242: {
                return "DSMCC_stream";
            }
            case 243: {
                return "ISO/IEC_13522_stream";
            }
            case 244: {
                return "ITU-T Rec. H.222.1 type A";
            }
            case 245: {
                return "ITU-T Rec. H.222.1 type B";
            }
            case 246: {
                return "ITU-T Rec. H.222.1 type C";
            }
            case 247: {
                return "ITU-T Rec. H.222.1 type D";
            }
            case 248: {
                return "ITU-T Rec. H.222.1 type E";
            }
            case 249: {
                return "ancillary_stream";
            }
            case 250: {
                return "ISO/IEC14496-1_SL-packetized_stream";
            }
            case 251: {
                return "ISO/IEC14496-1_FlexMux_stream";
            }
            case 252: {
                return "metadata stream";
            }
            case 253: {
                return "extended_stream_id";
            }
            case 254: {
                return "reserved data stream";
            }
            case 255: {
                return "program_stream_directory";
            }
        }
        return "??";
    }

    class AdDescriptor
    implements TreeNode {
        private int ad_descriptor_length;
        private byte[] ad_text_tag;
        private int version_text_tag;
        private int ad_fade_byte;
        private int ad_pan_byte;
        private int ad_gain_byte_center;
        private int ad_gain_byte_front;
        private int ad_gain_byte_surround;

        AdDescriptor(PesHeader this$0, byte[] data) {
            this.ad_descriptor_length = Utils.getInt(data, 0, 1, 15);
            this.ad_text_tag = Utils.getBytes(data, 1, 5);
            this.version_text_tag = Utils.getInt(data, 6, 1, 255);
            this.ad_fade_byte = Utils.getInt(data, 7, 1, 255);
            this.ad_pan_byte = Utils.getInt(data, 8, 1, 255);
            if (this.version_text_tag == 50) {
                this.ad_gain_byte_center = Utils.getInt(data, 9, 1, 255);
                this.ad_gain_byte_front = Utils.getInt(data, 10, 1, 255);
                this.ad_gain_byte_surround = Utils.getInt(data, 11, 1, 255);
            }
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("AD_descriptor"));
            t.add(new DefaultMutableTreeNode(new KVP("AD_descriptor_length", this.ad_descriptor_length, null)));
            t.add(new DefaultMutableTreeNode(new KVP("AD_text_tag", this.ad_text_tag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("version_text_tag", this.version_text_tag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("AD_fade_byte", this.ad_fade_byte, null)));
            t.add(new DefaultMutableTreeNode(new KVP("AD_pan_byte", this.ad_pan_byte, null)));
            if (this.version_text_tag == 50) {
                t.add(new DefaultMutableTreeNode(new KVP("AD_gain_byte center", this.ad_gain_byte_center, null)));
                t.add(new DefaultMutableTreeNode(new KVP("AD_gain_byte front", this.ad_gain_byte_front, null)));
                t.add(new DefaultMutableTreeNode(new KVP("AD_gain_byte surround", this.ad_gain_byte_surround, null)));
            }
            return t;
        }
    }
}

