/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.ac3;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.ac3.AbstractAC3SyncFrame;

public class AC3SyncFrame
extends AbstractAC3SyncFrame
implements TreeNode {
    private int xbsi1e;
    private int xbsi2e;
    private int xbsi2;
    private int encinfo;

    public AC3SyncFrame(byte[] data, int offset) {
        super(data, offset);
        this.syncword = this.bs.readBits(16);
        this.crc1 = this.bs.readBits(16);
        this.fscod = this.bs.readBits(2);
        this.frmsizecod = this.bs.readBits(6);
        this.bsid = this.bs.readBits(5);
        this.bsmod = this.bs.readBits(3);
        this.acmod = this.bs.readBits(3);
        if ((this.acmod & 1) != 0 && this.acmod != 1) {
            this.cmixlev = this.bs.readBits(2);
        }
        if ((this.acmod & 4) != 0) {
            this.surmixlev = this.bs.readBits(2);
        }
        if (this.acmod == 2) {
            this.dsurmod = this.bs.readBits(2);
        }
        this.lfeon = this.bs.readBits(1);
        this.dialnorm = this.bs.readBits(5);
        this.compre = this.bs.readBits(1);
        if (this.compre == 1) {
            this.compr = this.bs.readBits(8);
        }
        this.langcode = this.bs.readBits(1);
        if (this.langcode == 1) {
            this.langcod = this.bs.readBits(8);
        }
        this.audprodie = this.bs.readBits(1);
        if (this.audprodie == 1) {
            this.mixlevel = this.bs.readBits(5);
            this.roomtyp = this.bs.readBits(2);
        }
        if (this.acmod == 0) {
            this.dialnorm2 = this.bs.readBits(5);
            this.compr2e = this.bs.readBits(1);
            if (this.compr2e == 1) {
                this.compr2 = this.bs.readBits(8);
            }
            this.langcod2e = this.bs.readBits(1);
            if (this.langcod2e == 1) {
                this.langcod2 = this.bs.readBits(8);
            }
            this.audprodi2e = this.bs.readBits(1);
            if (this.audprodi2e == 1) {
                this.mixlevel2 = this.bs.readBits(5);
                this.roomtyp2 = this.bs.readBits(2);
            }
        }
        this.copyrightb = this.bs.readBits(1);
        this.origbs = this.bs.readBits(1);
        if (this.bsid != 6) {
            this.timecod1e = this.bs.readBits(1);
            if (this.timecod1e == 1) {
                this.timecod1 = this.bs.readBits(14);
            }
            this.timecod2e = this.bs.readBits(1);
            if (this.timecod2e == 1) {
                this.timecod2 = this.bs.readBits(14);
            }
        } else {
            this.xbsi1e = this.bs.readBits(1);
            if (this.xbsi1e == 1) {
                this.dmixmod = this.bs.readBits(2);
                this.ltrtcmixlev = this.bs.readBits(3);
                this.ltrtsurmixlev = this.bs.readBits(3);
                this.lorocmixlev = this.bs.readBits(3);
                this.lorosurmixlev = this.bs.readBits(3);
            }
            this.xbsi2e = this.bs.readBits(1);
            if (this.xbsi2e == 1) {
                this.dsurexmod = this.bs.readBits(2);
                this.dheadphonmod = this.bs.readBits(2);
                this.adconvtyp = this.bs.readBits(1);
                this.xbsi2 = this.bs.readBits(8);
                this.encinfo = this.bs.readBits(1);
            }
        }
        this.addbsie = this.bs.readBits(1);
        if (this.addbsie == 1) {
            this.addbsil = this.bs.readBits(6);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("AC3 SyncFrame"));
        s.add(new DefaultMutableTreeNode(new KVP("syncword", this.syncword, "must be 0x0B77")));
        s.add(new DefaultMutableTreeNode(new KVP("crc1", this.crc1, null)));
        s.add(new DefaultMutableTreeNode(new KVP("fscod", this.fscod, "Sample rate code: " + AC3SyncFrame.getSampleRateCodeString(this.fscod))));
        s.add(new DefaultMutableTreeNode(new KVP("frmsizecod", this.frmsizecod, "Frame size code: " + AC3SyncFrame.getFrmsizecodString(this.fscod, this.frmsizecod))));
        s.add(new DefaultMutableTreeNode(new KVP("bsid", this.bsid, AC3SyncFrame.getBsidString(this.bsid))));
        s.add(new DefaultMutableTreeNode(new KVP("bsmod", this.bsmod, "Bit stream mode: " + AC3SyncFrame.getBsModString(this.bsmod, this.acmod))));
        s.add(new DefaultMutableTreeNode(new KVP("acmod", this.acmod, "Audio coding mode: " + AC3SyncFrame.getACModString(this.acmod))));
        if ((this.acmod & 1) != 0 && this.acmod != 1) {
            s.add(new DefaultMutableTreeNode(new KVP("cmixlev", this.cmixlev, "Centre mix level: " + AC3SyncFrame.getCentreMixLevelString(this.cmixlev))));
        }
        if ((this.acmod & 4) != 0) {
            s.add(new DefaultMutableTreeNode(new KVP("surmixlev", this.surmixlev, "Surround mix level: " + AC3SyncFrame.getSurroundMixLevelString(this.surmixlev))));
        }
        if (this.acmod == 2) {
            s.add(new DefaultMutableTreeNode(new KVP("dsurmod", this.dsurmod, "Dolby Surround mode: " + AC3SyncFrame.getDsurmodString(this.dsurmod))));
        }
        s.add(new DefaultMutableTreeNode(new KVP("lfeon", this.lfeon, AC3SyncFrame.getLfeOnString(this.lfeon))));
        s.add(new DefaultMutableTreeNode(new KVP("dialnorm", this.dialnorm, AC3SyncFrame.getDialNormString(this.dialnorm))));
        s.add(new DefaultMutableTreeNode(new KVP("compre", this.compre, AC3SyncFrame.getCompreString(this.compre))));
        if (this.compre == 1) {
            s.add(new DefaultMutableTreeNode(new KVP("compr", this.compr, "Compression gain word")));
        }
        s.add(new DefaultMutableTreeNode(new KVP("langcode", this.langcode, this.langcode == 1 ? "Language code exists" : "langcod does not exist in the bit stream")));
        if (this.langcode == 1) {
            s.add(new DefaultMutableTreeNode(new KVP("langcod", this.langcod, null)));
        }
        s.add(new DefaultMutableTreeNode(new KVP("audprodie", this.audprodie, this.audprodie == 1 ? "mixlevel and roomtyp fields exist" : "No audio production information exists")));
        if (this.audprodie == 1) {
            s.add(new DefaultMutableTreeNode(new KVP("mixlevel", this.mixlevel, "Mixing level: " + (80 + this.mixlevel) + " dB")));
            s.add(new DefaultMutableTreeNode(new KVP("roomtyp", "Room type: " + this.roomtyp, AC3SyncFrame.getRoomTypeString(this.roomtyp))));
        }
        if (this.acmod == 0) {
            s.add(new DefaultMutableTreeNode(new KVP("dialnorm2", this.dialnorm2, AC3SyncFrame.getDialNormString(this.dialnorm2))));
            s.add(new DefaultMutableTreeNode(new KVP("compre2", this.compr2e, this.compr2e == 1 ? "Compression gain word exists" : "No compression gain word exists")));
            if (this.compr2e == 1) {
                s.add(new DefaultMutableTreeNode(new KVP("compr2", this.compr2, "Compression gain word")));
            }
            s.add(new DefaultMutableTreeNode(new KVP("langcod2e", this.langcod2e, "Language code exists")));
            if (this.langcod2e == 1) {
                s.add(new DefaultMutableTreeNode(new KVP("langcod2", this.langcod2, null)));
            }
            s.add(new DefaultMutableTreeNode(new KVP("audprodi2e", this.audprodi2e, this.audprodi2e == 1 ? "following two data fields exist indicating information about the audio production for Ch2" : "No audio production information exists for Ch2")));
            if (this.audprodi2e == 1) {
                s.add(new DefaultMutableTreeNode(new KVP("mixlevel2", this.mixlevel2, "peak mixing level during the final audio mixing session: " + (80 + this.mixlevel2) + " dB")));
                s.add(new DefaultMutableTreeNode(new KVP("roomtyp2", this.roomtyp2, AC3SyncFrame.getRoomTypeString(this.roomtyp))));
            }
        }
        s.add(new DefaultMutableTreeNode(new KVP("copyrightb", this.copyrightb, this.copyrightb == 1 ? "protected by copyright" : "not indicated as protected")));
        s.add(new DefaultMutableTreeNode(new KVP("origbs", this.origbs, this.origbs == 1 ? "original bit stream" : "copy of another bit stream")));
        if (this.bsid != 6) {
            s.add(new DefaultMutableTreeNode(new KVP("timecod1e", this.timecod1e, null)));
            if (this.timecod1e == 1) {
                s.add(new DefaultMutableTreeNode(new KVP("timecod1", this.timecod1, null)));
            }
            s.add(new DefaultMutableTreeNode(new KVP("timecod2e", this.timecod2e, null)));
            if (this.timecod2e == 1) {
                s.add(new DefaultMutableTreeNode(new KVP("timecod2", this.timecod2, null)));
            }
        } else {
            s.add(new DefaultMutableTreeNode(new KVP("xbsi1e", this.xbsi1e, "Extra bitstream information #1 " + AC3SyncFrame.doesExistString(this.xbsi1e))));
            if (this.xbsi1e == 1) {
                s.add(new DefaultMutableTreeNode(new KVP("dmixmod", this.dmixmod, "Preferred stereo downmix mode: " + AC3SyncFrame.getDmixmodString(this.dmixmod))));
                s.add(new DefaultMutableTreeNode(new KVP("ltrtcmixlev", this.ltrtcmixlev, "Lt/Rt center mix level: " + AC3SyncFrame.getCmixlevString(this.ltrtcmixlev))));
                s.add(new DefaultMutableTreeNode(new KVP("ltrtsurmixlev", this.ltrtsurmixlev, "Lt/Rt surround mix level: " + AC3SyncFrame.getSurmixlevString(this.ltrtsurmixlev))));
                s.add(new DefaultMutableTreeNode(new KVP("lorocmixlev", this.lorocmixlev, "Lo/Ro center mix level: " + AC3SyncFrame.getCmixlevString(this.lorocmixlev))));
                s.add(new DefaultMutableTreeNode(new KVP("lorosurmixlev", this.lorosurmixlev, "Lo/Ro surround mix level: " + AC3SyncFrame.getSurmixlevString(this.lorosurmixlev))));
            }
            s.add(new DefaultMutableTreeNode(new KVP("xbsi2e", this.xbsi2e, "Extra bit stream information #2 " + AC3SyncFrame.doesExistString(this.xbsi2e))));
            if (this.xbsi2e == 1) {
                s.add(new DefaultMutableTreeNode(new KVP("dsurexmod", this.dsurexmod, "Dolby Surround EX mode: " + AC3SyncFrame.getDsurexmodString(this.dsurexmod))));
                s.add(new DefaultMutableTreeNode(new KVP("dheadphonmod", this.dheadphonmod, "Dolby Headphone mode: " + AC3SyncFrame.getDheadphonmodString(this.dheadphonmod))));
                s.add(new DefaultMutableTreeNode(new KVP("adconvtyp", this.adconvtyp, "A/D converter type: " + (this.adconvtyp == 1 ? "HDCD" : "standard"))));
                s.add(new DefaultMutableTreeNode(new KVP("xbsi2", this.xbsi2, "Extra bit stream information, reserved for future assignment. shall be set to 0")));
                s.add(new DefaultMutableTreeNode(new KVP("encinfo", this.encinfo, "Encoder information, reserved for use by the encoder")));
            }
        }
        s.add(new DefaultMutableTreeNode(new KVP("addbsie", this.addbsie, this.addbsie == 1 ? "Additional bit stream information exists" : "Additional bit stream information does not exist")));
        if (this.addbsie == 1) {
            s.add(new DefaultMutableTreeNode(new KVP("addbsil", this.addbsil, "Additional bit stream information length")));
        }
        return s;
    }

    public int getXbsi1e() {
        return this.xbsi1e;
    }

    public int getXbsi2e() {
        return this.xbsi2e;
    }

    public int getXbsi2() {
        return this.xbsi2;
    }

    public int getEncinfo() {
        return this.encinfo;
    }
}

