/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.ac3;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PesPacketData;
import nl.digitalekabeltelevisie.data.mpeg.pes.GeneralPesHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.ac3.AC3PESDataField;
import nl.digitalekabeltelevisie.data.mpeg.pes.ac3.EAC3SyncFrame;
import nl.digitalekabeltelevisie.util.Utils;

public class EAC3Handler
extends GeneralPesHandler {
    private final List<EAC3SyncFrame> ac3Frames = new ArrayList<EAC3SyncFrame>();

    @Override
    protected void processPesDataBytes(PesPacketData pesData) {
        AC3PESDataField ac3PesDataField = new AC3PESDataField(pesData);
        this.pesPackets.add(ac3PesDataField);
        this.copyIntoBuf(ac3PesDataField);
        int i = this.bufStart;
        int end = this.bufStart;
        while (i < this.pesDataBuffer.length && i >= 0 && end >= 0) {
            if ((i = Utils.indexOf(this.pesDataBuffer, new byte[]{11, 119}, i)) < 0 || (end = Utils.indexOf(this.pesDataBuffer, new byte[]{11, 119}, i + 2)) <= 0) continue;
            EAC3SyncFrame frame = new EAC3SyncFrame(this.pesDataBuffer, i);
            this.ac3Frames.add(frame);
            this.bufStart = end;
            i = end;
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode s = super.getJTreeNode(modus);
        Utils.addListJTree(s, this.ac3Frames, modus, "EAC3 SyncFrames");
        return s;
    }
}

