/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.util.Utils;

public class AncillaryData
implements TreeNode {
    private byte[] data_byte;
    private final int sync;
    private final int data_field_length;

    public AncillaryData(byte[] data, int offset, int len) {
        this.sync = Utils.getInt(data, offset + len - 1, 1, 255);
        this.data_field_length = Utils.getInt(data, offset + len - 2, 1, 255);
        if (this.data_field_length > 0) {
            this.data_byte = new byte[this.data_field_length];
            for (int i = 0; i < this.data_field_length; ++i) {
                this.data_byte[i] = data[offset + len - 3 - i];
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("AncillaryData"));
        s.add(new DefaultMutableTreeNode(new KVP("sync", this.sync, AncillaryData.getSync(this.sync))));
        s.add(new DefaultMutableTreeNode(new KVP("data_field_length", this.data_field_length, null)));
        if (this.data_byte != null) {
            s.add(new DefaultMutableTreeNode(new KVP("data_byte", this.data_byte, null)));
        }
        return s;
    }

    private static String getSync(int s) {
        switch (s) {
            case 173: {
                return "announcement_switching_data_sync";
            }
            case 253: {
                return "UECP_data_sync";
            }
            case 254: {
                return "scale_factor_error_check data_sync";
            }
        }
        return "illegal value";
    }

    public byte[] getDataByte() {
        return this.data_byte;
    }

    public int getSync() {
        return this.sync;
    }

    public int getDataFieldLength() {
        return this.data_field_length;
    }
}

