/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio.aac;

import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.aac.GASpecificConfig;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.LookUpList;

public class AudioSpecificConfig
implements TreeNode {
    private static final Logger logger = Logger.getLogger(AudioSpecificConfig.class.getName());
    private static LookUpList samplingFrequencyList = new LookUpList.Builder().add(0, "96000").add(1, "88200").add(2, "64000").add(3, "48000").add(4, "44100").add(5, "32000").add(6, "24000").add(7, "22050").add(8, "16000").add(9, "12000").add(10, "11025").add(11, "8000").add(12, "7350").add(13, "reserved").add(14, "reserved").add(15, "escape value").build();
    private static LookUpList audio_object_type_list = new LookUpList.Builder().add(0, "Null").add(1, "AAC main").add(2, "AAC LC").add(3, "AAC SSR").add(4, "AAC LTP").add(5, "(Reserved)").add(6, "AAC Scalable").add(7, "TwinVQ").add(8, "CELP").add(9, "HVXC").add(10, "(Reserved)").add(11, "(Reserved)").add(12, "TTSI").add(13, "Main synthetic").add(14, "Wavetable synthesis").add(15, "General MIDI").add(16, "Algorithmic Synthesis and Audio FX").add(17, "ER AAC LC").add(18, "(Reserved)").add(19, "AAC LTP").add(20, "ER AAC scalable").add(21, "ER TwinVQ").add(22, "ER BSAC").add(23, "ER AAC LD").add(24, "ER CELP").add(25, "ER HVXC").add(26, "ER HILN").add(27, "ER Parametric").add(28, 31, "(Reserved)").build();
    private int audioObjectType;
    private int samplingFrequencyIndex;
    private int samplingFrequency;
    private int channelConfiguration;
    private int extensionAudioObjectType;
    private int sbrPresentFlag;
    private GASpecificConfig gASpecificConfig;
    private int extensionSamplingFrequencyIndex;
    private int extensionSamplingFrequency;

    public AudioSpecificConfig(BitSource bitSource) {
        this.audioObjectType = this.getAudioObjectType(bitSource);
        this.samplingFrequencyIndex = bitSource.readBits(4);
        if (this.samplingFrequencyIndex == 15) {
            this.samplingFrequency = bitSource.readBits(24);
        }
        this.channelConfiguration = bitSource.readBits(4);
        this.sbrPresentFlag = -1;
        if (this.audioObjectType == 5) {
            this.extensionAudioObjectType = this.audioObjectType;
            this.sbrPresentFlag = 1;
            this.extensionSamplingFrequencyIndex = bitSource.readBits(4);
            if (this.extensionSamplingFrequencyIndex == 15) {
                this.extensionSamplingFrequency = bitSource.readBits(24);
            }
            this.audioObjectType = this.getAudioObjectType(bitSource);
        } else {
            this.extensionAudioObjectType = 0;
        }
        switch (this.audioObjectType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                this.gASpecificConfig = new GASpecificConfig(bitSource, this.samplingFrequencyIndex, this.channelConfiguration, this.audioObjectType);
                break;
            }
            default: {
                logger.info("not implemented audioObjectType:" + this.audioObjectType);
            }
        }
    }

    private int getAudioObjectType(BitSource bitSource) {
        this.audioObjectType = bitSource.readBits(5);
        if (this.audioObjectType == 31) {
            int audioObjectTypeExt = bitSource.readBits(6);
            this.audioObjectType = 32 + audioObjectTypeExt;
        }
        return this.audioObjectType;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("AudioSpecificConfig"));
        t.add(new DefaultMutableTreeNode(new KVP("audioObjectType", this.audioObjectType, audio_object_type_list.get(this.audioObjectType))));
        t.add(new DefaultMutableTreeNode(new KVP("samplingFrequencyIndex", this.samplingFrequencyIndex, samplingFrequencyList.get(this.samplingFrequencyIndex))));
        if (this.samplingFrequencyIndex == 15) {
            t.add(new DefaultMutableTreeNode(new KVP("samplingFrequency", this.samplingFrequency, null)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("channelConfiguration", this.channelConfiguration, null)));
        switch (this.audioObjectType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                t.add(this.gASpecificConfig.getJTreeNode(modus));
                break;
            }
            default: {
                t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("not implemented audioObjectType:" + this.audioObjectType)));
            }
        }
        return t;
    }

    public int getAudioObjectType() {
        return this.audioObjectType;
    }

    public int getSamplingFrequencyIndex() {
        return this.samplingFrequencyIndex;
    }

    public int getSamplingFrequency() {
        return this.samplingFrequency;
    }

    public int getChannelConfiguration() {
        return this.channelConfiguration;
    }

    public int getExtensionAudioObjectType() {
        return this.extensionAudioObjectType;
    }

    public int getSbrPresentFlag() {
        return this.sbrPresentFlag;
    }

    public GASpecificConfig getgASpecificConfig() {
        return this.gASpecificConfig;
    }

    public int getExtensionSamplingFrequencyIndex() {
        return this.extensionSamplingFrequencyIndex;
    }

    public int getExtensionSamplingFrequency() {
        return this.extensionSamplingFrequency;
    }
}

