/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio.aac;

import java.util.List;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.aac.PayloadLengthInfo;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.aac.StreamMuxConfig;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.BitSource;

public class PayloadMux
implements TreeNode {
    byte[][] payLoadList = new byte[64][];
    private StreamMuxConfig streamMuxConfig;
    private static final Logger logger = Logger.getLogger(PayloadMux.class.getName());

    public PayloadMux(BitSource bitSource, StreamMuxConfig streamMuxConfig, PayloadLengthInfo payloadLengthInfo) {
        this.streamMuxConfig = streamMuxConfig;
        int[] muxSlotLengthBytes = payloadLengthInfo.getMuxSlotLengthBytes();
        if (streamMuxConfig.getAllStreamsSameTimeFraming() == 1) {
            int[][] streamID = streamMuxConfig.getStreamID();
            List<StreamMuxConfig.ProgramConfig> programConfigList = streamMuxConfig.getProgramConfigList();
            for (int prog = 0; prog <= streamMuxConfig.getNumProgram(); ++prog) {
                StreamMuxConfig.ProgramConfig programConfig = programConfigList.get(prog);
                for (int lay = 0; lay <= programConfig.getNumLayer(); ++lay) {
                    int lengthPayload = muxSlotLengthBytes[streamID[prog][lay]];
                    byte[] payload = new byte[lengthPayload];
                    for (int i = 0; i < lengthPayload; ++i) {
                        payload[i] = (byte)bitSource.readBits(8);
                    }
                    this.payLoadList[streamID[prog][lay]] = payload;
                }
            }
        } else {
            logger.warning("! allStreamsSameTimeFraming not implemented");
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("PayloadMux"));
        if (this.streamMuxConfig.getAllStreamsSameTimeFraming() == 1) {
            int[][] streamID = this.streamMuxConfig.getStreamID();
            List<StreamMuxConfig.ProgramConfig> programConfigList = this.streamMuxConfig.getProgramConfigList();
            for (int prog = 0; prog <= this.streamMuxConfig.getNumProgram(); ++prog) {
                StreamMuxConfig.ProgramConfig programConfig = programConfigList.get(prog);
                for (int lay = 0; lay <= programConfig.getNumLayer(); ++lay) {
                    byte[] payload = this.payLoadList[streamID[prog][lay]];
                    t.add(new DefaultMutableTreeNode(new KVP("payload [streamID[" + prog + "][" + lay + "]]", payload, "streamID[" + prog + "][" + lay + "]]=" + streamID[prog][lay])));
                }
            }
        } else {
            t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("! allStreamsSameTimeFraming")));
        }
        return t;
    }

    public byte[][] getPayLoadList() {
        return this.payLoadList;
    }
}

