/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4.AC4PresentationSubstreamInfo;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4.AC4SgiSpecifier;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4.AC4Toc;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4.EmdfInfo;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class AC4PresentationV1Info
implements TreeNode {
    private static final Logger logger = Logger.getLogger(AC4PresentationV1Info.class.getName());
    LookUpList presentation_config_list = new LookUpList.Builder().add(0, "music and effects + dialogue").add(1, "Main + dialogue enhancement").add(2, "Main + associate").add(3, "music and effects + dialogue + associate").add(4, "Main + dialogue enhancement + associate").add(5, "Arbitrary substream groups").add(6, "EMDF only").build();
    private AC4Toc parentAc4Toc;
    private int b_single_substream_group;
    private int presentation_config;
    private int presentation_version;
    private int b_add_emdf_substreams;
    private int mdcompat;
    private int b_presentation_id;
    private int presentation_id;
    private int multiplier_bit;
    private int b_multiplier;
    private int frame_rate_fraction;
    private int frame_rate_factor;
    private int b_frame_rate_fraction;
    private int b_frame_rate_fraction_is_4;
    private int b_presentation_filter;
    private int b_enable_presentation;
    private List<AC4SgiSpecifier> ac4_sgi_specifier_list = new ArrayList<AC4SgiSpecifier>();
    private int n_substream_groups;
    private int b_multi_pid;
    private int b_pre_virtualized;
    private EmdfInfo emdf_info;
    private AC4PresentationSubstreamInfo ac4_presentation_substream_info;
    private int n_add_emdf_substreams;
    private List<EmdfInfo> substreamsEmdfInfo = new ArrayList<EmdfInfo>();
    private int n_substream_groups_minus2;

    public AC4PresentationV1Info(BitSource bs, AC4Toc parent) {
        this.parentAc4Toc = parent;
        this.b_single_substream_group = bs.readBits(1);
        if (this.b_single_substream_group != 1) {
            this.presentation_config = bs.readBits(3);
            if (this.presentation_config == 7) {
                this.presentation_config += bs.variable_bits(2);
            }
        }
        if (this.parentAc4Toc.getBitstream_version() != 1) {
            this.presentation_version = AC4PresentationV1Info.getPresentationVersion(bs);
        }
        if (this.b_single_substream_group != 1 && this.presentation_config == 6) {
            this.b_add_emdf_substreams = 1;
        } else {
            if (this.parentAc4Toc.getBitstream_version() != 1) {
                this.mdcompat = bs.readBits(3);
            }
            this.b_presentation_id = bs.readBits(1);
            if (this.b_presentation_id == 1) {
                this.presentation_id = bs.variable_bits(2);
            }
            this.frame_rate_multiply_info(bs, this.parentAc4Toc.getFrame_rate_index());
            this.frame_rate_fractions_info(bs, this.parentAc4Toc.getFrame_rate_index());
            this.emdf_info = new EmdfInfo(bs);
            this.b_presentation_filter = bs.readBits(1);
            if (this.b_presentation_filter == 1) {
                this.b_enable_presentation = bs.readBits(1);
            }
            if (this.b_single_substream_group == 1) {
                this.ac4_sgi_specifier_list.add(new AC4SgiSpecifier(bs, this.parentAc4Toc.getBitstream_version()));
                this.n_substream_groups = 1;
            } else {
                this.b_multi_pid = bs.readBits(1);
                switch (this.presentation_config) {
                    case 0: {
                        this.ac4_sgi_specifier_list.add(new AC4SgiSpecifier(bs, this.parentAc4Toc.getBitstream_version()));
                        this.ac4_sgi_specifier_list.add(new AC4SgiSpecifier(bs, this.parentAc4Toc.getBitstream_version()));
                        this.n_substream_groups = 2;
                        break;
                    }
                    case 1: {
                        this.ac4_sgi_specifier_list.add(new AC4SgiSpecifier(bs, this.parentAc4Toc.getBitstream_version()));
                        this.ac4_sgi_specifier_list.add(new AC4SgiSpecifier(bs, this.parentAc4Toc.getBitstream_version()));
                        this.n_substream_groups = 1;
                        break;
                    }
                    case 2: {
                        this.ac4_sgi_specifier_list.add(new AC4SgiSpecifier(bs, this.parentAc4Toc.getBitstream_version()));
                        this.ac4_sgi_specifier_list.add(new AC4SgiSpecifier(bs, this.parentAc4Toc.getBitstream_version()));
                        this.n_substream_groups = 2;
                        break;
                    }
                    case 3: {
                        this.ac4_sgi_specifier_list.add(new AC4SgiSpecifier(bs, this.parentAc4Toc.getBitstream_version()));
                        this.ac4_sgi_specifier_list.add(new AC4SgiSpecifier(bs, this.parentAc4Toc.getBitstream_version()));
                        this.ac4_sgi_specifier_list.add(new AC4SgiSpecifier(bs, this.parentAc4Toc.getBitstream_version()));
                        this.n_substream_groups = 3;
                        break;
                    }
                    case 4: {
                        this.ac4_sgi_specifier_list.add(new AC4SgiSpecifier(bs, this.parentAc4Toc.getBitstream_version()));
                        this.ac4_sgi_specifier_list.add(new AC4SgiSpecifier(bs, this.parentAc4Toc.getBitstream_version()));
                        this.ac4_sgi_specifier_list.add(new AC4SgiSpecifier(bs, this.parentAc4Toc.getBitstream_version()));
                        this.n_substream_groups = 2;
                        break;
                    }
                    case 5: {
                        this.n_substream_groups_minus2 = bs.readBits(2);
                        this.n_substream_groups = this.n_substream_groups_minus2 + 2;
                        if (this.n_substream_groups == 5) {
                            this.n_substream_groups += bs.variable_bits(2);
                        }
                        for (int sg = 0; sg < this.n_substream_groups; ++sg) {
                            this.ac4_sgi_specifier_list.add(new AC4SgiSpecifier(bs, this.parentAc4Toc.getBitstream_version()));
                        }
                        break;
                    }
                    default: {
                        logger.warning("presentation_config_ext_info not implemented");
                    }
                }
            }
            this.b_pre_virtualized = bs.readBits(1);
            this.b_add_emdf_substreams = bs.readBits(1);
            this.ac4_presentation_substream_info = new AC4PresentationSubstreamInfo(bs);
        }
        if (this.b_add_emdf_substreams == 1) {
            this.n_add_emdf_substreams = bs.readBits(2);
            if (this.n_add_emdf_substreams == 0) {
                this.n_add_emdf_substreams = bs.variable_bits(2) + 4;
            }
            for (int i = 0; i < this.n_add_emdf_substreams; ++i) {
                EmdfInfo sub_emdf_info = new EmdfInfo(bs);
                this.substreamsEmdfInfo.add(sub_emdf_info);
            }
        }
    }

    private void frame_rate_fractions_info(BitSource bs, int frame_rate_index) {
        this.frame_rate_fraction = 1;
        if (Arrays.asList(5, 6, 7, 8, 9).contains(frame_rate_index) && this.frame_rate_factor == 1) {
            this.b_frame_rate_fraction = bs.readBits(1);
            if (this.b_frame_rate_fraction == 1) {
                this.frame_rate_fraction = 2;
            }
        }
        if (Arrays.asList(10, 11, 12).contains(frame_rate_index)) {
            this.b_frame_rate_fraction = bs.readBits(1);
            if (this.b_frame_rate_fraction == 1) {
                this.b_frame_rate_fraction_is_4 = bs.readBits(1);
                this.frame_rate_fraction = this.b_frame_rate_fraction_is_4 == 1 ? 4 : 2;
            }
        }
    }

    private void frame_rate_multiply_info(BitSource bs, int frame_rate_index) {
        this.frame_rate_factor = 1;
        switch (frame_rate_index) {
            case 2: 
            case 3: 
            case 4: {
                this.b_multiplier = bs.readBits(1);
                if (this.b_multiplier != 1) break;
                this.multiplier_bit = bs.readBits(1);
                if (this.multiplier_bit == 0) {
                    this.frame_rate_factor = 2;
                    break;
                }
                this.frame_rate_factor = 4;
                break;
            }
            case 0: 
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                this.b_multiplier = bs.readBits(1);
                if (this.b_multiplier != 1) break;
                this.frame_rate_factor = 2;
                break;
            }
        }
    }

    private static int getPresentationVersion(BitSource bs) {
        int b_tmp;
        int val = 0;
        while ((b_tmp = bs.readBits(1)) == 1) {
            ++val;
        }
        return val;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("ac4_presentation_v1_info"));
        t.add(new DefaultMutableTreeNode(new KVP("b_single_substream_group", this.b_single_substream_group, null)));
        if (this.b_single_substream_group != 1) {
            t.add(new DefaultMutableTreeNode(new KVP("presentation_config", this.presentation_config, null)));
        }
        if (this.parentAc4Toc.getBitstream_version() != 1) {
            t.add(new DefaultMutableTreeNode(new KVP("presentation_version", this.presentation_version, null)));
        }
        if (this.b_single_substream_group != 1 && this.presentation_config == 6) {
            t.add(new DefaultMutableTreeNode(new KVP("b_add_emdf_substreams", this.b_add_emdf_substreams, "(implied)")));
        } else {
            if (this.parentAc4Toc.getBitstream_version() != 1) {
                t.add(new DefaultMutableTreeNode(new KVP("mdcompat", this.mdcompat, null)));
            }
            t.add(new DefaultMutableTreeNode(new KVP("b_presentation_id", this.b_presentation_id, null)));
            if (this.b_presentation_id == 1) {
                t.add(new DefaultMutableTreeNode(new KVP("presentation_id", this.presentation_id, null)));
            }
            t.add(this.getFrameRateMultiplyInfoNode());
            t.add(this.getFrameRateFractionsInfoNode());
            t.add(this.emdf_info.getJTreeNode(modus));
            t.add(new DefaultMutableTreeNode(new KVP("b_presentation_filter", this.b_presentation_filter, null)));
            if (this.b_presentation_filter == 1) {
                t.add(new DefaultMutableTreeNode(new KVP("b_enable_presentation", this.b_enable_presentation, null)));
            }
            if (this.b_single_substream_group == 1) {
                t.add(this.ac4_sgi_specifier_list.get(0).getJTreeNode(modus));
                t.add(new DefaultMutableTreeNode(new KVP("n_substream_groups", this.n_substream_groups, null)));
            } else {
                t.add(new DefaultMutableTreeNode(new KVP("b_multi_pid", this.b_multi_pid, null)));
                t.add(new DefaultMutableTreeNode(new KVP("presentation_config", this.presentation_config, this.presentation_config_list.get(this.presentation_config, "Reserved"))));
                if (this.presentation_config == 5) {
                    t.add(new DefaultMutableTreeNode(new KVP("n_substream_groups_minus2", this.n_substream_groups_minus2, null)));
                }
                Utils.addListJTree(t, this.ac4_sgi_specifier_list, modus, "ac4_sgi_specifier(s)");
                t.add(new DefaultMutableTreeNode(new KVP("n_substream_groups", this.n_substream_groups, null)));
                if (this.presentation_config > 5) {
                    t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("presentation_config>5, /* EMDF and other data */, presentation_config_ext_info()")));
                    return t;
                }
            }
            t.add(new DefaultMutableTreeNode(new KVP("b_pre_virtualized", this.b_pre_virtualized, null)));
            t.add(new DefaultMutableTreeNode(new KVP("b_add_emdf_substreams", this.b_add_emdf_substreams, null)));
            t.add(this.ac4_presentation_substream_info.getJTreeNode(modus));
        }
        if (this.b_add_emdf_substreams == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("n_add_emdf_substreams", this.n_add_emdf_substreams, null)));
            Utils.addListJTree(t, this.substreamsEmdfInfo, modus, "emdf_info(s)");
        }
        return t;
    }

    private DefaultMutableTreeNode getFrameRateFractionsInfoNode() {
        DefaultMutableTreeNode frame_rate_fractions_info_node = new DefaultMutableTreeNode(new KVP("frame_rate_fractions_info (frame_rate_fraction)", this.frame_rate_fraction, null));
        if (Arrays.asList(5, 6, 7, 8, 9).contains(this.parentAc4Toc.getFrame_rate_index()) && this.frame_rate_factor == 1) {
            frame_rate_fractions_info_node.add(new DefaultMutableTreeNode(new KVP("b_frame_rate_fraction", this.b_frame_rate_fraction, null)));
        }
        if (Arrays.asList(10, 11, 12).contains(this.parentAc4Toc.getFrame_rate_index())) {
            frame_rate_fractions_info_node.add(new DefaultMutableTreeNode(new KVP("b_frame_rate_fraction", this.b_frame_rate_fraction, null)));
            if (this.b_frame_rate_fraction == 1) {
                frame_rate_fractions_info_node.add(new DefaultMutableTreeNode(new KVP("b_frame_rate_fraction_is_4", this.b_frame_rate_fraction_is_4, null)));
            }
        }
        return frame_rate_fractions_info_node;
    }

    private DefaultMutableTreeNode getFrameRateMultiplyInfoNode() {
        DefaultMutableTreeNode frame_rate_multiply_info_node = new DefaultMutableTreeNode(new KVP("frame_rate_multiply_info (frame_rate_factor)", this.frame_rate_factor, null));
        switch (this.parentAc4Toc.getFrame_rate_index()) {
            case 2: 
            case 3: 
            case 4: {
                frame_rate_multiply_info_node.add(new DefaultMutableTreeNode(new KVP("b_multiplier", this.b_multiplier, null)));
                if (this.b_multiplier != 1) break;
                frame_rate_multiply_info_node.add(new DefaultMutableTreeNode(new KVP("multiplier_bit", this.multiplier_bit, null)));
                break;
            }
            case 0: 
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                frame_rate_multiply_info_node.add(new DefaultMutableTreeNode(new KVP("b_multiplier", this.b_multiplier, null)));
                break;
            }
        }
        return frame_rate_multiply_info_node;
    }

    public List<AC4SgiSpecifier> getAc4_sgi_specifier_list() {
        return this.ac4_sgi_specifier_list;
    }
}

