/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4.AC4SubstreamInfo;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4.AC4SubstreamInfoChan;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4.AC4SubstreamInfoObj;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4.AC4Toc;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4.Ac4HsfExtSubstreamInfo;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4.ContentType;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4.OamdSubstreamInfo;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.Utils;

public class AC4SubstreamGroupInfo
implements TreeNode {
    private static final Logger logger = Logger.getLogger(AC4SubstreamGroupInfo.class.getName());
    private int b_substreams_present;
    private int b_hsf_ext;
    private int b_single_substream;
    private int n_lf_substreams;
    private int n_lf_substreams_minus2;
    private int b_channel_coded;
    private int b_oamd_substream;
    private OamdSubstreamInfo oamd_substream_info;
    private List<ChannelCodedSubstream> channel_coded_substreams = new ArrayList<ChannelCodedSubstream>();
    private List<Substream> substreams = new ArrayList<Substream>();
    private int b_content_type;
    private ContentType content_type;

    public AC4SubstreamGroupInfo(BitSource bs, AC4Toc parentAc4Toc) {
        this.b_substreams_present = bs.readBits(1);
        this.b_hsf_ext = bs.readBits(1);
        this.b_single_substream = bs.readBits(1);
        if (this.b_single_substream == 1) {
            this.n_lf_substreams = 1;
        } else {
            this.n_lf_substreams_minus2 = bs.readBits(2);
            this.n_lf_substreams = this.n_lf_substreams_minus2 + 2;
            if (this.n_lf_substreams == 5) {
                this.n_lf_substreams += bs.variable_bits(2);
            }
        }
        this.b_channel_coded = bs.readBits(1);
        if (this.b_channel_coded == 1) {
            for (int sus = 0; sus < this.n_lf_substreams; ++sus) {
                ChannelCodedSubstream channel_coded_substream = new ChannelCodedSubstream();
                this.channel_coded_substreams.add(channel_coded_substream);
                int sus_ver = parentAc4Toc.getBitstream_version() == 1 ? bs.readBits(1) : 1;
                channel_coded_substream.setSusVer(sus_ver);
                AC4SubstreamInfoChan ac4_substream_info_chan = new AC4SubstreamInfoChan(bs, parentAc4Toc, this.b_substreams_present);
                channel_coded_substream.setAC4SubstreamInfoChan(ac4_substream_info_chan);
                if (this.b_hsf_ext != 1) continue;
                Ac4HsfExtSubstreamInfo ac4_hsf_ext_substream_info = new Ac4HsfExtSubstreamInfo(bs, this.b_substreams_present);
                channel_coded_substream.setAc4HsfExtSubstreamInfo(ac4_hsf_ext_substream_info);
            }
        } else {
            this.b_oamd_substream = bs.readBits(1);
            if (this.b_oamd_substream == 1) {
                this.oamd_substream_info = new OamdSubstreamInfo(bs, this.b_substreams_present);
            }
            for (int sus = 0; sus < this.n_lf_substreams; ++sus) {
                Substream substream = new Substream();
                this.substreams.add(substream);
                int b_ajoc = bs.readBits(1);
                substream.setB_ajoc(b_ajoc);
                if (b_ajoc == 1) {
                    logger.warning("if (b_ajoc == 1) { not implmented");
                    continue;
                }
                AC4SubstreamInfoObj ac4_substream_info_obj = new AC4SubstreamInfoObj(bs, parentAc4Toc, this.b_substreams_present);
                substream.setAc4_substream_info_obj(ac4_substream_info_obj);
                if (this.b_hsf_ext != 1) continue;
                Ac4HsfExtSubstreamInfo ac4_hsf_ext_substream_info = new Ac4HsfExtSubstreamInfo(bs, this.b_substreams_present);
                substream.setAc4HsfExtSubstreamInfo(ac4_hsf_ext_substream_info);
            }
        }
        this.b_content_type = bs.readBits(1);
        if (this.b_content_type == 1) {
            this.content_type = new ContentType(bs);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("ac4_substream_group_info"));
        t.add(new DefaultMutableTreeNode(new KVP("b_substreams_present", this.b_substreams_present, null)));
        t.add(new DefaultMutableTreeNode(new KVP("b_hsf_ext", this.b_hsf_ext, null)));
        t.add(new DefaultMutableTreeNode(new KVP("b_single_substream", this.b_single_substream, this.b_single_substream == 1 ? "n_lf_substreams = 1" : null)));
        if (this.b_single_substream != 1) {
            t.add(new DefaultMutableTreeNode(new KVP("n_lf_substreams_minus2", this.n_lf_substreams_minus2, "n_lf_substreams = " + this.n_lf_substreams)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("b_channel_coded", this.b_channel_coded, this.b_channel_coded == 1 ? "substreams contain channel-based audio" : null)));
        if (this.b_channel_coded == 1) {
            Utils.addListJTree(t, this.channel_coded_substreams, modus, "channel coded substreams");
        } else {
            t.add(new DefaultMutableTreeNode(new KVP("b_oamd_substream", this.b_oamd_substream, null)));
            if (this.b_oamd_substream == 1) {
                t.add(this.oamd_substream_info.getJTreeNode(modus));
            }
            Utils.addListJTree(t, this.substreams, modus, "A-JOC coded/direct-coded substreams");
        }
        t.add(new DefaultMutableTreeNode(new KVP("b_content_type", this.b_content_type, null)));
        if (this.b_content_type == 1) {
            t.add(this.content_type.getJTreeNode(modus));
        }
        return t;
    }

    public class ChannelCodedSubstream
    implements TreeNode {
        private int sus_ver;
        private AC4SubstreamInfoChan ac4_substream_info_chan;
        private Ac4HsfExtSubstreamInfo ac4HsfExtSubstreamInfo;

        public void setSusVer(int sus_ver) {
            this.sus_ver = sus_ver;
        }

        public int getSusVer() {
            return this.sus_ver;
        }

        public void setAC4SubstreamInfoChan(AC4SubstreamInfoChan ac4_substream_info_chan) {
            this.ac4_substream_info_chan = ac4_substream_info_chan;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("channel__coded_substream"));
            t.add(new DefaultMutableTreeNode(new KVP("sus_ver", this.sus_ver, null)));
            t.add(this.ac4_substream_info_chan.getJTreeNode(modus));
            if (AC4SubstreamGroupInfo.this.b_hsf_ext == 1) {
                t.add(this.ac4HsfExtSubstreamInfo.getJTreeNode(modus));
            }
            return t;
        }

        public void setAc4HsfExtSubstreamInfo(Ac4HsfExtSubstreamInfo ac4HsfExtSubstreamInfo) {
            this.ac4HsfExtSubstreamInfo = ac4HsfExtSubstreamInfo;
        }
    }

    public class Substream
    implements TreeNode {
        private int b_ajoc;
        private AC4SubstreamInfoObj ac4_substream_info_obj;
        private Ac4HsfExtSubstreamInfo ac4HsfExtSubstreamInfo;

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("substream"));
            t.add(new DefaultMutableTreeNode(new KVP("b_ajoc", this.b_ajoc, null)));
            if (this.b_ajoc == 1) {
                t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("ac4_substream_info_ajoc")));
            } else {
                t.add(this.ac4_substream_info_obj.getJTreeNode(modus));
            }
            if (AC4SubstreamGroupInfo.this.b_hsf_ext == 1) {
                t.add(this.ac4HsfExtSubstreamInfo.getJTreeNode(modus));
            }
            return t;
        }

        public int getB_ajoc() {
            return this.b_ajoc;
        }

        public void setB_ajoc(int b_ajoc) {
            this.b_ajoc = b_ajoc;
        }

        public AC4SubstreamInfo getAc4_substream_info_obj() {
            return this.ac4_substream_info_obj;
        }

        public void setAc4_substream_info_obj(AC4SubstreamInfoObj ac4_substream_info_obj) {
            this.ac4_substream_info_obj = ac4_substream_info_obj;
        }

        public void setAc4HsfExtSubstreamInfo(Ac4HsfExtSubstreamInfo ac4HsfExtSubstreamInfo) {
            this.ac4HsfExtSubstreamInfo = ac4HsfExtSubstreamInfo;
        }
    }
}

