/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.LookUpList;

public abstract class AC4SubstreamInfo {
    public static LookUpList bitrate_indicator_list = new LookUpList.Builder().add(0, "16 kbit/s").add(1, "20 kbit/s").add(2, "24 kbit/s").add(3, "28 kbit/s").add(4, "32 kbit/s").add(5, "40 kbit/s").add(6, "48 kbit/s").add(7, "56 kbit/s").add(8, "64 kbit/s").add(9, "80 kbit/s").add(10, "96 kbit/s").add(11, "112 kbit/s").add(12, 19, "Unlimited").build();
    protected List<BAudioNdot> b_audio_ndot_list = new ArrayList<BAudioNdot>();

    protected static int readBitrateIndiciator(BitSource bs) {
        int threeBits = bs.readBits(3);
        switch (threeBits) {
            case 0: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 6: {
                return 3;
            }
        }
        int fiveBits = threeBits * 4 + bs.readBits(2);
        switch (fiveBits) {
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 12: {
                return 8;
            }
            case 13: {
                return 9;
            }
            case 14: {
                return 10;
            }
            case 15: {
                return 11;
            }
        }
        return 12;
    }

    public class BAudioNdot
    implements TreeNode {
        private int b_audio_ndot;

        public BAudioNdot(AC4SubstreamInfo this$0, int b_audio_ndot) {
            this.b_audio_ndot = b_audio_ndot;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("b_audio_ndot", this.b_audio_ndot, null));
            return t;
        }
    }
}

