/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.LookUpList;

public class ContentType
implements TreeNode {
    LookUpList content_classifier_list = new LookUpList.Builder().add(0, "Main audio service: complete main").add(1, "Main audio service: music and effects").add(2, "Associated service: visually impaired").add(3, "Any associated service: hearing impaired").add(4, "Associated service: dialogue").add(5, "Any associated service: commentary").add(6, "Associated service: emergency").add(7, "Associated service: voice over").build();
    private int content_classifier;
    private int b_language_indicator;
    private int b_serialized_language_tag;
    private int b_start_tag;
    private int language_tag_chunk;
    private int n_language_tag_bytes;
    private byte[] language_tag_bytes;

    public ContentType(BitSource bs) {
        this.content_classifier = bs.readBits(3);
        this.b_language_indicator = bs.readBits(1);
        if (this.b_language_indicator == 1) {
            this.b_serialized_language_tag = bs.readBits(1);
            if (this.b_serialized_language_tag == 1) {
                this.b_start_tag = bs.readBits(1);
                this.language_tag_chunk = bs.readBits(16);
            } else {
                this.n_language_tag_bytes = bs.readBits(6);
                this.language_tag_bytes = bs.readUnalignedBytes(this.n_language_tag_bytes);
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("content_type"));
        t.add(new DefaultMutableTreeNode(new DefaultMutableTreeNode(new KVP("content_classifier", this.content_classifier, this.content_classifier_list.get(this.content_classifier)))));
        t.add(new DefaultMutableTreeNode(new DefaultMutableTreeNode(new KVP("b_language_indicator", this.b_language_indicator, null))));
        if (this.b_language_indicator == 1) {
            t.add(new DefaultMutableTreeNode(new DefaultMutableTreeNode(new KVP("b_serialized_language_tag", this.b_serialized_language_tag, null))));
            if (this.b_serialized_language_tag == 1) {
                t.add(new DefaultMutableTreeNode(new DefaultMutableTreeNode(new KVP("b_start_tag", this.b_start_tag, null))));
                t.add(new DefaultMutableTreeNode(new DefaultMutableTreeNode(new KVP("language_tag_chunk", this.language_tag_chunk, null))));
            } else {
                t.add(new DefaultMutableTreeNode(new DefaultMutableTreeNode(new KVP("n_language_tag_bytes", this.n_language_tag_bytes, null))));
                t.add(new DefaultMutableTreeNode(new DefaultMutableTreeNode(new KVP("language_tag_bytes", this.language_tag_bytes, null))));
            }
        }
        return t;
    }
}

