/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.Utils;

public class SubstreamIndexTable
implements TreeNode {
    private int n_substreams;
    private int b_size_present;
    private int b_more_bits;
    private List<SubStreamSize> subStreamSizes = new ArrayList<SubStreamSize>();

    public SubstreamIndexTable(BitSource bs) {
        this.n_substreams = bs.readBits(2);
        if (this.n_substreams == 0) {
            this.n_substreams = bs.variable_bits(2) + 4;
        }
        this.b_size_present = this.n_substreams == 1 ? bs.readBits(1) : 1;
        if (this.b_size_present == 1) {
            for (int s = 0; s < this.n_substreams; ++s) {
                int b_more_bits = bs.readBits(1);
                int substream_size = bs.readBits(10);
                if (b_more_bits == 1) {
                    substream_size += bs.variable_bits(2) << 10;
                }
                this.subStreamSizes.add(new SubStreamSize(this, substream_size));
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("substream_index_table"));
        t.add(new DefaultMutableTreeNode(new KVP("n_substreams", this.n_substreams, null)));
        t.add(new DefaultMutableTreeNode(new KVP("b_size_present", this.b_size_present, this.n_substreams != 1 ? "implied" : null)));
        Utils.addListJTree(t, this.subStreamSizes, modus, "subStreamSizes");
        return t;
    }

    class SubStreamSize
    implements TreeNode {
        private int substream_size;

        SubStreamSize(SubstreamIndexTable this$0, int substream_size) {
            this.substream_size = substream_size;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("substream_size", this.substream_size, null));
            return t;
        }
    }
}

