/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds;

import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds.MessageElement;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds.MessageElementFactory;
import nl.digitalekabeltelevisie.util.Utils;

public class Frame
implements TreeNode {
    private static final Logger logger = Logger.getLogger(Frame.class.getName());
    private byte[] data;
    private int start;
    private int stop;
    private final MessageElement messageElement;

    public Frame(byte[] data, int start, int stop) {
        this.data = data;
        this.start = start;
        this.stop = stop;
        int fdIndex = Utils.indexOf(data, new byte[]{-3}, start);
        if (fdIndex != -1 && fdIndex < stop) {
            byte[] tmp = new byte[1 + stop - start];
            int target = 0;
            for (int i = start; i <= stop; ++i) {
                if (data[i] == -3) {
                    tmp[target++] = (byte)(data[i] + data[i + 1]);
                    ++i;
                    continue;
                }
                tmp[target++] = data[i];
            }
            this.data = tmp;
            this.start = 0;
            this.stop = target;
        }
        this.messageElement = MessageElementFactory.createMessageElement(this.data, this.start + 5);
        if (this.messageElement.getLength() != this.getMessageFieldLength()) {
            logger.info("length of Message " + this.messageElement.getMessageElementCodeString() + " (" + this.messageElement.getLength() + ", starting at " + this.messageElement.getStart() + ") does not equal length of frame (" + this.getMessageFieldLength() + ")");
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode frame = new DefaultMutableTreeNode(new KVP("Frame (" + MessageElement.getMessageElementCodeString(this.messageElement.getMessageElementCode()) + ")"));
        frame.add(new DefaultMutableTreeNode(new KVP("data", this.data, this.start, this.stop - this.start + 1, null)));
        frame.add(new DefaultMutableTreeNode(new KVP("Start Code", this.getStart(), null)));
        frame.add(new DefaultMutableTreeNode(new KVP("Addres", this.getAddres(), null)));
        frame.add(new DefaultMutableTreeNode(new KVP("Sequence Counter", this.getSequenceCounter(), null)));
        frame.add(new DefaultMutableTreeNode(new KVP("Message field length", this.getMessageFieldLength(), null)));
        frame.add(new DefaultMutableTreeNode(new KVP("Cyclic Redundancy Check", this.getCyclicRedundancyCheck(), null)));
        frame.add(this.messageElement.getJTreeNode(modus));
        return frame;
    }

    private int getStart() {
        return Utils.getInt(this.data, this.start, 1, 255);
    }

    private int getAddres() {
        return Utils.getInt(this.data, this.start + 1, 2, 65535);
    }

    private int getSequenceCounter() {
        return Utils.getInt(this.data, this.start + 3, 1, 255);
    }

    private int getMessageFieldLength() {
        return Utils.getInt(this.data, this.start + 4, 1, 255);
    }

    private int getCyclicRedundancyCheck() {
        return Utils.getInt(this.data, this.start + 5 + this.getMessageFieldLength(), 2, 65535);
    }

    public int getStop() {
        return this.stop;
    }
}

