/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds.MessageElement;
import nl.digitalekabeltelevisie.util.Utils;

public class MessageElementAF
extends MessageElement {
    public MessageElementAF(byte[] data, int start) {
        super(data, start);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode messageElement = new DefaultMutableTreeNode(new KVP("Message Element AF"));
        messageElement.add(new DefaultMutableTreeNode(new KVP("Message Element Code", this.getMessageElementCode(), MessageElement.getMessageElementCodeString(this.getMessageElementCode()))));
        messageElement.add(new DefaultMutableTreeNode(new KVP("Data Set Number", this.getDataSetNumber(), MessageElement.getDataSetNumberString(this.getDataSetNumber()))));
        messageElement.add(new DefaultMutableTreeNode(new KVP("Program Service Number", this.getProgramServiceNumber(), null)));
        messageElement.add(new DefaultMutableTreeNode(new KVP("Message Element Data Length", this.getMessageElementDataLength(), null)));
        messageElement.add(new DefaultMutableTreeNode(new KVP("Start Location (High)", this.getStartLocationHigh(), null)));
        messageElement.add(new DefaultMutableTreeNode(new KVP("Start Location (Low)", this.getStartLocationLow(), null)));
        for (int i = 0; i < this.getMessageElementDataLength() - 2; ++i) {
            int afCode = Utils.getInt(this.data, this.st + 6 + i, 1, 255);
            messageElement.add(new DefaultMutableTreeNode(new KVP("AF Data", afCode, MessageElementAF.getAFDataString(afCode))));
        }
        return messageElement;
    }

    protected int getStartLocationHigh() {
        return Utils.getInt(this.data, this.st + 4, 1, 255);
    }

    protected int getStartLocationLow() {
        return Utils.getInt(this.data, this.st + 5, 1, 255);
    }

    private static String getAFDataString(int afd) {
        if (afd >= 1 && afd <= 204) {
            return 87.5 + (double)afd / 10.0 + " MHz";
        }
        if (afd >= 225 && afd <= 249) {
            return afd - 224 + "AF(s) follows";
        }
        switch (afd) {
            case 0: {
                return "Not to be used/filler code";
            }
            case 205: {
                return "filler code";
            }
            case 224: {
                return "No AF exists";
            }
            case 250: {
                return "An LF/MF frequency follows";
            }
        }
        return "Not assigned";
    }
}

