/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds;

import java.util.logging.Logger;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds.MessageElement;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds.MessageElementAF;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds.MessageElementCTOnOff;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds.MessageElementDataSetSelect;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds.MessageElementFreeFormatGroup;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds.MessageElementIH;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds.MessageElementODAConfigurationAndShortMessageCommand;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds.MessageElementODADataCommand;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds.MessageElementODAFreeFormatGroup;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds.MessageElementPI;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds.MessageElementPS;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds.MessageElementPTY;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds.MessageElementRT;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds.MessageElementRealTimeClock;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds.MessageElementTATP;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds.MessageElementTMC;
import nl.digitalekabeltelevisie.util.Utils;

public final class MessageElementFactory {
    private static final Logger logger = Logger.getLogger(MessageElementFactory.class.getName());

    private MessageElementFactory() {
    }

    public static MessageElement createMessageElement(byte[] data, int start) {
        int messageElementCode = Utils.getInt(data, start, 1, 255);
        if (messageElementCode == 1) {
            return new MessageElementPI(data, start);
        }
        if (messageElementCode == 2) {
            return new MessageElementPS(data, start);
        }
        if (messageElementCode == 3) {
            return new MessageElementTATP(data, start);
        }
        if (messageElementCode == 7) {
            return new MessageElementPTY(data, start);
        }
        if (messageElementCode == 10) {
            return new MessageElementRT(data, start);
        }
        if (messageElementCode == 13) {
            return new MessageElementRealTimeClock(data, start);
        }
        if (messageElementCode == 19) {
            return new MessageElementAF(data, start);
        }
        if (messageElementCode == 25) {
            return new MessageElementCTOnOff(data, start);
        }
        if (messageElementCode == 28) {
            return new MessageElementDataSetSelect(data, start);
        }
        if (messageElementCode == 36) {
            return new MessageElementFreeFormatGroup(data, start);
        }
        if (messageElementCode == 37) {
            return new MessageElementIH(data, start);
        }
        if (messageElementCode == 48) {
            return new MessageElementTMC(data, start);
        }
        if (messageElementCode == 64) {
            return new MessageElementODAConfigurationAndShortMessageCommand(data, start);
        }
        if (messageElementCode == 66) {
            return new MessageElementODAFreeFormatGroup(data, start);
        }
        if (messageElementCode == 70) {
            return new MessageElementODADataCommand(data, start);
        }
        logger.info("No implementation for MessageElement code:" + messageElementCode + ", type: " + MessageElement.getMessageElementCodeString(messageElementCode));
        return new MessageElement(data, start);
    }
}

