/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.rds.MessageElement;
import nl.digitalekabeltelevisie.util.Utils;

public class MessageElementPTY
extends MessageElement {
    public MessageElementPTY(byte[] data, int start) {
        super(data, start);
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode messageElement = new DefaultMutableTreeNode(new KVP("Message Element PTY"));
        messageElement.add(new DefaultMutableTreeNode(new KVP("Message Element Code", this.getMessageElementCode(), MessageElement.getMessageElementCodeString(this.getMessageElementCode()))));
        messageElement.add(new DefaultMutableTreeNode(new KVP("Data Set Number", this.getDataSetNumber(), MessageElement.getDataSetNumberString(this.getDataSetNumber()))));
        messageElement.add(new DefaultMutableTreeNode(new KVP("Program Service Number", this.getProgramServiceNumber(), null)));
        messageElement.add(new DefaultMutableTreeNode(new KVP("PTY", this.getPTY(), MessageElementPTY.getPTY(this.getPTY()))));
        return messageElement;
    }

    protected int getPTY() {
        return Utils.getInt(this.data, this.st + 3, 1, 255);
    }

    private static String getPTY(int tatp) {
        switch (tatp) {
            case 0: {
                return "No programma type or undefined";
            }
            case 1: {
                return "News";
            }
            case 2: {
                return "Current Affairs";
            }
            case 3: {
                return "Information";
            }
            case 4: {
                return "Sport";
            }
            case 5: {
                return "Education";
            }
            case 6: {
                return "Drama";
            }
            case 7: {
                return "Culture";
            }
            case 8: {
                return "Science";
            }
            case 9: {
                return "Varied";
            }
            case 10: {
                return "Pop Music";
            }
            case 11: {
                return "Rock Music";
            }
            case 12: {
                return "Easy Listening Music";
            }
            case 13: {
                return "Light Classical";
            }
            case 14: {
                return "Serious Classical";
            }
            case 15: {
                return "Other Music";
            }
            case 16: {
                return "Weather";
            }
            case 17: {
                return "Finance";
            }
            case 18: {
                return "Children's programmes";
            }
            case 19: {
                return "Social Affairs";
            }
            case 20: {
                return "Religion";
            }
            case 21: {
                return "Phone In";
            }
            case 22: {
                return "Travel";
            }
            case 23: {
                return "Leisure";
            }
            case 24: {
                return "Jazz Music";
            }
            case 25: {
                return "Country Music";
            }
            case 26: {
                return "National Music";
            }
            case 27: {
                return "Oldies Music";
            }
            case 28: {
                return "Folk Music";
            }
            case 29: {
                return "Documentary";
            }
            case 30: {
                return "Alarm Test";
            }
            case 31: {
                return "Alarm";
            }
        }
        return "Illegal Value";
    }
}

