/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling;

import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.Segment;
import nl.digitalekabeltelevisie.util.Utils;

public class CLUTDefinitionSegment
extends Segment {
    private int[] CLUT_2bit;
    private int[] CLUT_4bit;
    private int[] CLUT_8bit;
    private static final int[] default_CLUT_2bit = new int[]{0, -1, -16777216, -8355712};
    private static final int[] default_CLUT_4bit = new int[]{0, -65536, -16711936, -256, -16776961, -65281, -16711681, -1, -16777216, -8388608, -16744448, -8355840, -16777088, -8388480, -16744320, -8355712};
    private static final int[] default_CLUT_8bit = new int[]{0, 0x40FF0000, 0x4000FF00, 0x40FFFF00, 0x400000FF, 0x40FF00FF, 0x4000FFFF, 0x40FFFFFF, Integer.MIN_VALUE, -2141913088, -2147461888, -2141891328, -2147483563, -2141913003, -2147461803, -2141891243, -5636096, -65536, -5614336, -43776, -5636011, -65451, -5614251, -43691, -2136342528, -2130771968, -2136320768, -2130750208, -2136342443, -2130771883, -2136320683, -2130750123, -16733696, -11163136, -16711936, -11141376, -16733611, -11163051, -16711851, -11141291, -2147440128, -2141869568, -2147418368, -2141847808, -2147440043, -2141869483, -2147418283, -2141847723, -5592576, -22016, -5570816, -256, -5592491, -21931, -5570731, -171, -2136299008, -2130728448, -2136277248, -2130706688, -2136298923, -2130728363, -2136277163, -2130706603, -16777046, -11206486, -16755286, -11184726, -16776961, -11206401, -16755201, -11184641, -2147483478, -2141912918, -2147461718, -2141891158, -2147483393, -2141912833, -2147461633, -2141891073, -5635926, -65366, -5614166, -43606, -5635841, -65281, -5614081, -43521, -2136342358, -2130771798, -2136320598, -2130750038, -2136342273, -2130771713, -2136320513, -2130749953, -16733526, -11162966, -16711766, -11141206, -16733441, -11162881, -16711681, -11141121, -2147439958, -2141869398, -2147418198, -2141847638, -2147439873, -2141869313, -2147418113, -2141847553, -5592406, -21846, -5570646, -86, -5592321, -21761, -5570561, -1, -2136298838, -2130728278, -2136277078, -2130706518, -2136298753, -2130728193, -2136276993, -2130706433, -8355712, -5603200, -8344960, -5592448, -8355670, -5603158, -8344918, -5592406, -16777216, -14024704, -16766464, -14013952, -16777174, -14024662, -16766422, -14013910, -2785152, -32640, -2774400, -21888, -2785110, -32598, -2774358, -21846, -11206656, -8454144, -11195904, -8443392, -11206614, -8454102, -11195862, -8443350, -8333952, -5581440, -8323200, -5570688, -8333910, -5581398, -8323158, -5570646, -16755456, -14002944, -16744704, -13992192, -16755414, -14002902, -16744662, -13992150, -2763392, -10880, -2752640, -128, -2763350, -10838, -2752598, -86, -11184896, -8432384, -11174144, -8421632, -11184854, -8432342, -11174102, -8421590, -8355627, -5603115, -8344875, -5592363, -8355585, -5603073, -8344833, -5592321, -16777131, -14024619, -16766379, -14013867, -16777089, -14024577, -16766337, -14013825, -2785067, -32555, -2774315, -21803, -2785025, -32513, -2774273, -21761, -11206571, -8454059, -11195819, -8443307, -11206529, -8454017, -11195777, -8443265, -8333867, -5581355, -8323115, -5570603, -8333825, -5581313, -8323073, -5570561, -16755371, -14002859, -16744619, -13992107, -16755329, -14002817, -16744577, -13992065, -2763307, -10795, -2752555, -43, -2763265, -10753, -2752513, -1, -11184811, -8432299, -11174059, -8421547, -11184769, -8432257, -11174017, -8421505};

    public CLUTDefinitionSegment(byte[] data, int offset) {
        super(data, offset);
        for (CLUTEntry clutEntry : this.getCLUTEntries()) {
            if (clutEntry.getCLUT_flag_2_bit_entry() == 1) {
                if (this.CLUT_2bit == null) {
                    this.CLUT_2bit = Arrays.copyOf(default_CLUT_2bit, default_CLUT_2bit.length);
                }
                if (clutEntry.getCLUT_entry_id() < this.CLUT_2bit.length) {
                    this.CLUT_2bit[clutEntry.getCLUT_entry_id()] = clutEntry.getARGB();
                }
            }
            if (clutEntry.getCLUT_flag_4_bit_entry() == 1) {
                if (this.CLUT_4bit == null) {
                    this.CLUT_4bit = Arrays.copyOf(default_CLUT_4bit, default_CLUT_4bit.length);
                }
                if (clutEntry.getCLUT_entry_id() < this.CLUT_4bit.length) {
                    this.CLUT_4bit[clutEntry.getCLUT_entry_id()] = clutEntry.getARGB();
                }
            }
            if (clutEntry.getCLUT_flag_8_bit_entry() != 1) continue;
            if (this.CLUT_8bit == null) {
                this.CLUT_8bit = Arrays.copyOf(default_CLUT_8bit, default_CLUT_8bit.length);
            }
            if (clutEntry.getCLUT_entry_id() >= this.CLUT_8bit.length) continue;
            this.CLUT_8bit[clutEntry.getCLUT_entry_id()] = clutEntry.getARGB();
        }
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP s = super.getJTreeNode(modus);
        s.add(new KVP("CLUT-id", this.getCLUTId()));
        s.add(new KVP("CLUT_version_number", this.getCLUTVersionNumber()));
        Utils.addListJTree(s, this.getCLUTEntries(), modus, "CLUTEntries");
        return s;
    }

    public int getCLUTVersionNumber() {
        return Utils.getInt(this.data_block, this.offset + 7, 1, 240) >> 4;
    }

    public int getCLUTId() {
        return Utils.getInt(this.data_block, this.offset + 6, 1, 255);
    }

    public List<CLUTEntry> getCLUTEntries() {
        ArrayList<CLUTEntry> clutEntries = new ArrayList<CLUTEntry>();
        int t = 0;
        while (t + 2 < this.getSegmentLength()) {
            int t_value;
            int cb_value;
            int cr_value;
            int y_value;
            int CLUT_entry_id = Utils.getInt(this.data_block, this.offset + 8 + t, 1, 255);
            int flag_2bit = Utils.getInt(this.data_block, this.offset + 9 + t, 1, 128) >> 7;
            int flag_4bit = Utils.getInt(this.data_block, this.offset + 9 + t, 1, 64) >> 6;
            int flag_8bit = Utils.getInt(this.data_block, this.offset + 9 + t, 1, 32) >> 5;
            int full_range_flag = Utils.getInt(this.data_block, this.offset + 9 + t, 1, 1);
            if (full_range_flag == 1) {
                y_value = Utils.getInt(this.data_block, this.offset + 10 + t, 1, 255);
                cr_value = Utils.getInt(this.data_block, this.offset + 11 + t, 1, 255);
                cb_value = Utils.getInt(this.data_block, this.offset + 12 + t, 1, 255);
                t_value = Utils.getInt(this.data_block, this.offset + 13 + t, 1, 255);
                t += 6;
            } else {
                y_value = Utils.getInt(this.data_block, this.offset + 10 + t, 1, 252) >> 2;
                cr_value = Utils.getInt(this.data_block, this.offset + 10 + t, 2, 60) >> 6;
                cb_value = Utils.getInt(this.data_block, this.offset + 11 + t, 1, 60) >> 2;
                t_value = Utils.getInt(this.data_block, this.offset + 11 + t, 1, 3);
                t += 4;
            }
            clutEntries.add(new CLUTEntry(CLUT_entry_id, flag_2bit, flag_4bit, flag_8bit, full_range_flag, y_value, cr_value, cb_value, t_value));
        }
        return clutEntries;
    }

    public static IndexColorModel getDefault_CLUT_2bitColorModel() {
        return CLUTDefinitionSegment.getIndexColorModel(2, 4, default_CLUT_2bit, 0, true, 0, 0);
    }

    public static IndexColorModel getDefault_CLUT_4bitColorModel() {
        return CLUTDefinitionSegment.getIndexColorModel(4, 16, default_CLUT_4bit, 0, true, 0, 0);
    }

    public static IndexColorModel getDefault_CLUT_8bitColorModel() {
        return CLUTDefinitionSegment.getIndexColorModel(8, 256, default_CLUT_8bit, 0, true, 0, 0);
    }

    public static IndexColorModel getDefaultColorModel(int regionDepth) {
        return switch (regionDepth) {
            case 1 -> CLUTDefinitionSegment.getDefault_CLUT_2bitColorModel();
            case 2 -> CLUTDefinitionSegment.getDefault_CLUT_4bitColorModel();
            case 3 -> CLUTDefinitionSegment.getDefault_CLUT_8bitColorModel();
            default -> null;
        };
    }

    public IndexColorModel getColorModel(int regionDepth) {
        switch (regionDepth) {
            case 1: {
                if (this.CLUT_2bit == null) {
                    return CLUTDefinitionSegment.getDefault_CLUT_2bitColorModel();
                }
                return CLUTDefinitionSegment.getIndexColorModel(2, 4, this.CLUT_2bit, 0, true, -1, 0);
            }
            case 2: {
                if (this.CLUT_4bit == null) {
                    return CLUTDefinitionSegment.getDefault_CLUT_4bitColorModel();
                }
                return CLUTDefinitionSegment.getIndexColorModel(4, 16, this.CLUT_4bit, 0, true, -1, 0);
            }
            case 3: {
                if (this.CLUT_8bit == null) {
                    return CLUTDefinitionSegment.getDefault_CLUT_8bitColorModel();
                }
                return CLUTDefinitionSegment.getIndexColorModel(8, 256, this.CLUT_8bit, 0, true, -1, 0);
            }
        }
        return null;
    }

    private static IndexColorModel getIndexColorModel(int bits, int size, int[] cmap, int start, boolean hasalpha, int trans, int transferType) {
        byte[] r = new byte[cmap.length];
        byte[] g = new byte[cmap.length];
        byte[] b = new byte[cmap.length];
        byte[] a = new byte[cmap.length];
        for (int i = 0; i < cmap.length; ++i) {
            r[i] = Utils.getInt2UnsignedByte((cmap[i] & 0xFF0000) >> 16);
            g[i] = Utils.getInt2UnsignedByte((cmap[i] & 0xFF00) >> 8);
            b[i] = Utils.getInt2UnsignedByte(cmap[i] & 0xFF);
            a[i] = Utils.getInt2UnsignedByte((cmap[i] & 0xFF000000) >>> 24);
        }
        return new IndexColorModel(bits, size, r, g, b, a);
    }

    public static class CLUTEntry
    implements TreeNode {
        private final int CLUT_entry_id;
        private final int CLUT_flag_2_bit_entry;
        private final int CLUT_flag_4_bit_entry;
        private final int CLUT_flag_8_bit_entry;
        private final int full_range_flag;
        private final int y_value;
        private final int cr_value;
        private final int cb_value;
        private final int t_value;

        public CLUTEntry(int clut_entry_id, int clut_flag_2_bit_entry, int clut_flag_4_bit_entry, int clut_flag_8_bit_entry, int full_range_flag, int y_value, int cr_value, int cb_value, int t_value) {
            this.CLUT_entry_id = clut_entry_id;
            this.CLUT_flag_2_bit_entry = clut_flag_2_bit_entry;
            this.CLUT_flag_4_bit_entry = clut_flag_4_bit_entry;
            this.CLUT_flag_8_bit_entry = clut_flag_8_bit_entry;
            this.full_range_flag = full_range_flag;
            this.y_value = y_value;
            this.cr_value = cr_value;
            this.cb_value = cb_value;
            this.t_value = t_value;
        }

        @Override
        public KVP getJTreeNode(int modus) {
            float cr;
            float cb;
            float y;
            if (this.full_range_flag == 1) {
                y = this.y_value;
                cb = this.cb_value;
                cr = this.cr_value;
            } else {
                y = this.y_value * 255 / 63;
                cb = this.cb_value * 255 / 15;
                cr = this.cr_value * 255 / 15;
            }
            int r = (int)(y + 1.402f * (cr - 128.0f));
            int g = (int)((double)y - 0.34414 * (double)(cb - 128.0f) - 0.71414 * (double)(cr - 128.0f));
            int b = (int)((double)y + 1.722 * (double)(cb - 128.0f));
            r = CLUTEntry.boundRange(r);
            g = CLUTEntry.boundRange(g);
            b = CLUTEntry.boundRange(b);
            if (y == 0.0f) {
                r = 0;
                g = 0;
                b = 0;
            }
            String bgColor = "#" + Utils.toHexStringUnformatted(r, 2) + Utils.toHexStringUnformatted(g, 2) + Utils.toHexStringUnformatted(b, 2);
            KVP s = new KVP("CLUT_entry id " + this.CLUT_entry_id).setHtmlLabel("CLUT_entry <code><span style=\"background-color: " + bgColor + "; color: white;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></code>");
            s.add(new KVP("CLUT_entry_id", this.CLUT_entry_id));
            s.add(new KVP("2-bit/entry_CLUT_flag", this.CLUT_flag_2_bit_entry));
            s.add(new KVP("4-bit/entry_CLUT_flag", this.CLUT_flag_4_bit_entry));
            s.add(new KVP("8-bit/entry_CLUT_flag", this.CLUT_flag_8_bit_entry));
            s.add(new KVP("full_range_flag", this.full_range_flag));
            s.add(new KVP("Y-value", this.y_value, null));
            s.add(new KVP("Cr-value", this.cr_value));
            s.add(new KVP("Cb-value", this.cb_value));
            s.add(new KVP("T-value", this.t_value));
            return s;
        }

        private static int boundRange(int r) {
            return Math.clamp((long)r, 0, 255);
        }

        public int getCb_value() {
            return this.cb_value;
        }

        public int getCLUT_entry_id() {
            return this.CLUT_entry_id;
        }

        public int getCLUT_flag_2_bit_entry() {
            return this.CLUT_flag_2_bit_entry;
        }

        public int getCLUT_flag_4_bit_entry() {
            return this.CLUT_flag_4_bit_entry;
        }

        public int getCLUT_flag_8_bit_entry() {
            return this.CLUT_flag_8_bit_entry;
        }

        public int getCr_value() {
            return this.cr_value;
        }

        public int getFull_range_flag() {
            return this.full_range_flag;
        }

        public int getT_value() {
            return this.t_value;
        }

        public int getY_value() {
            return this.y_value;
        }

        public int getARGB() {
            int a;
            float cr;
            float cb;
            float y;
            if (this.full_range_flag == 1) {
                y = this.y_value;
                cb = this.cb_value;
                cr = this.cr_value;
                a = 255 - this.t_value;
            } else {
                y = this.y_value * 255 / 63;
                cb = this.cb_value * 255 / 15;
                cr = this.cr_value * 255 / 15;
                a = 255 - this.t_value * 256 / 4;
            }
            int r = (int)(y + 1.402f * (cr - 128.0f));
            int g = (int)((double)y - 0.34414 * (double)(cb - 128.0f) - 0.71414 * (double)(cr - 128.0f));
            int b = (int)((double)y + 1.722 * (double)(cb - 128.0f));
            r = CLUTEntry.boundRange(r);
            g = CLUTEntry.boundRange(g);
            b = CLUTEntry.boundRange(b);
            if (y == 0.0f) {
                r = 0;
                g = 0;
                b = 0;
                a = 0;
            }
            return a << 24 | r << 16 | g << 8 | b;
        }
    }
}

