/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PesPacketData;
import nl.digitalekabeltelevisie.data.mpeg.pes.PesHeader;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.CLUTDefinitionSegment;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.DisplayDefinitionSegment;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.ObjectDataSegment;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.PageCompositionSegment;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.RegionCompositionSegment;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.Segment;
import nl.digitalekabeltelevisie.gui.ImageSource;
import nl.digitalekabeltelevisie.util.Utils;

public class DVBSubtitlingPESDataField
extends PesPacketData
implements ImageSource {
    private static final Logger logger = Logger.getLogger(DVBSubtitlingPESDataField.class.getName());
    private int data_identifier;
    private int subtitle_stream_id;
    private DisplayDefinitionSegment displayDefinitionSegment = null;
    private final Map<Integer, RegionCompositionSegment> regionCompositionsSegments = new HashMap<Integer, RegionCompositionSegment>();
    private final Map<Integer, CLUTDefinitionSegment> clutDefinitions = new HashMap<Integer, CLUTDefinitionSegment>();
    private final Map<Integer, ObjectDataSegment> objects = new HashMap<Integer, ObjectDataSegment>();
    public static BufferedImage bgImage576;
    public static BufferedImage bgImage720;
    public static BufferedImage bgImage1080;
    private static final ClassLoader classLoader;
    private final List<Segment> segmentList = new ArrayList<Segment>();

    public DVBSubtitlingPESDataField(PesPacketData pesPacket) {
        super(pesPacket);
        int offset = this.getPesDataStart();
        if (this.pesDataLen > 0) {
            this.data_identifier = Utils.getInt(this.data, offset, 1, 255);
            if (this.data_identifier == 32) {
                this.subtitle_stream_id = Utils.getInt(this.data, offset + 1, 1, 255);
                int t = 2;
                while (this.data[offset + t] == 15) {
                    Segment segment;
                    int segment_type = Utils.getInt(this.data, offset + t + 1, 1, 255);
                    switch (segment_type) {
                        case 16: {
                            segment = new PageCompositionSegment(this.data, offset + t);
                            break;
                        }
                        case 17: {
                            RegionCompositionSegment rc = new RegionCompositionSegment(this.data, offset + t);
                            segment = rc;
                            this.regionCompositionsSegments.put(rc.getRegionId(), rc);
                            break;
                        }
                        case 18: {
                            CLUTDefinitionSegment cl = new CLUTDefinitionSegment(this.data, offset + t);
                            segment = cl;
                            this.clutDefinitions.put(cl.getCLUTId(), cl);
                            break;
                        }
                        case 19: {
                            ObjectDataSegment obj = new ObjectDataSegment(this.data, offset + t);
                            segment = obj;
                            this.objects.put(obj.getObjectId(), obj);
                            break;
                        }
                        case 20: {
                            segment = new DisplayDefinitionSegment(this.data, offset + t);
                            this.displayDefinitionSegment = (DisplayDefinitionSegment)segment;
                            break;
                        }
                        default: {
                            segment = new Segment(this.data, offset + t);
                        }
                    }
                    this.segmentList.add(segment);
                    t += 6 + Utils.getInt(this.data, offset + t + 4, 2, 65535);
                }
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode s = super.getJTreeNode(modus, new KVP("DVBSubtitlingSegments").addImageSource(this, "DVBSubtitlingSegments"));
        if (this.pesDataLen > 0) {
            s.add(new KVP("data_identifier", this.data_identifier).setDescription(Utils.getDataIDString(this.data_identifier)));
            if (this.data_identifier == 32) {
                s.add(new KVP("subtitle_stream_id", this.subtitle_stream_id));
                Utils.addListJTree(s, this.segmentList, modus, "segments");
            }
        }
        return s;
    }

    @Override
    public BufferedImage getImage() {
        PesHeader pesHeader = this.getPesHeader();
        if (this.data_identifier == 32 && pesHeader.getPts_dts_flags() >= 2) {
            int width = 720;
            int height = 576;
            int x_offset = 0;
            int y_offset = 0;
            if (this.displayDefinitionSegment != null) {
                width = this.displayDefinitionSegment.getDisplayWidth() + 1;
                height = this.displayDefinitionSegment.getDisplayHeight() + 1;
                if (this.displayDefinitionSegment.getDisplayWindowFlag() == 1) {
                    x_offset = this.displayDefinitionSegment.getDisplayWindowHorizontalPositionMinimum();
                    y_offset = this.displayDefinitionSegment.getDisplayWindowVerticalPositionMinimum();
                }
            }
            BufferedImage bgImage = this.pesHandler.getBGImage(height, width, pesHeader.getPts());
            BufferedImage img = new BufferedImage(width, height, 2);
            Graphics2D gd = img.createGraphics();
            gd.drawImage((Image)bgImage, 0, 0, null);
            for (Segment element : this.segmentList) {
                if (element.getSegmentType() != 16) continue;
                PageCompositionSegment pcSegment = (PageCompositionSegment)element;
                for (PageCompositionSegment.Region region : pcSegment.getRegions()) {
                    RegionCompositionSegment regionCompositionSegment = this.regionCompositionsSegments.get(region.getRegion_id());
                    if (regionCompositionSegment == null) continue;
                    int clutId = regionCompositionSegment.getCLUTId();
                    CLUTDefinitionSegment clutDefinitionSegment = this.clutDefinitions.get(clutId);
                    if (regionCompositionSegment.getRegionFillFlag() == 1 && clutDefinitionSegment != null) {
                        int index = DVBSubtitlingPESDataField.getPixelCode(regionCompositionSegment);
                        IndexColorModel colorModel = clutDefinitionSegment.getColorModel(regionCompositionSegment.getRegionDepth());
                        int rgb = colorModel.getRGB(index);
                        Color bgColor = new Color(rgb, true);
                        gd.setColor(bgColor);
                        Rectangle rect = new Rectangle(region.getRegion_horizontal_address(), region.getRegion_vertical_address(), regionCompositionSegment.getRegionWidth(), regionCompositionSegment.getRegionHeight());
                        gd.fill(rect);
                    }
                    for (RegionCompositionSegment.RegionObject regionObject : regionCompositionSegment.getRegionObjects()) {
                        if (clutDefinitionSegment == null) continue;
                        IndexColorModel cm = clutDefinitionSegment.getColorModel(regionCompositionSegment.getRegionDepth());
                        int object_id = regionObject.getObject_id();
                        ObjectDataSegment objectDataSegment = this.objects.get(object_id);
                        if (objectDataSegment == null) continue;
                        if (objectDataSegment.getObjectCodingMethod() == 0) {
                            WritableRaster raster = objectDataSegment.getRaster(regionCompositionSegment.getRegionDepth());
                            BufferedImage i = new BufferedImage(cm, raster, false, null);
                            gd.drawImage((Image)i, region.getRegion_horizontal_address() + regionObject.getObject_horizontal_position() + x_offset, region.getRegion_vertical_address() + regionObject.getObject_vertical_position() + y_offset, null);
                            continue;
                        }
                        if (objectDataSegment.getObjectCodingMethod() != 1) continue;
                        BufferedImage i = new BufferedImage(regionCompositionSegment.getRegionWidth(), regionCompositionSegment.getRegionHeight(), 13, cm);
                        Graphics2D graphics = i.createGraphics();
                        Font font = new Font("Arial", 1, 30);
                        graphics.setFont(font);
                        graphics.setColor(new Color(cm.getRGB(regionObject.getForeground_pixel_code())));
                        graphics.setBackground(new Color(cm.getRGB(regionObject.getBackground_pixel_code())));
                        graphics.drawString(objectDataSegment.getCharacter_code_string(), 0, 30);
                        gd.drawImage((Image)i, region.getRegion_horizontal_address() + regionObject.getObject_horizontal_position() + x_offset, region.getRegion_vertical_address() + regionObject.getObject_vertical_position() + y_offset, null);
                    }
                }
            }
            return img;
        }
        return null;
    }

    public static int getPixelCode(RegionCompositionSegment regionCompositionSegment) {
        int index = switch (regionCompositionSegment.getRegionDepth()) {
            case 1 -> regionCompositionSegment.getRegion2BitPixelCode();
            case 2 -> regionCompositionSegment.getRegion4BitPixelCode();
            case 3 -> regionCompositionSegment.getRegion8BitPixelCode();
            default -> 0;
        };
        return index;
    }

    public List<Segment> getSegmentList() {
        return this.segmentList;
    }

    public int getData_identifier() {
        return this.data_identifier;
    }

    public int getSubtitle_stream_id() {
        return this.subtitle_stream_id;
    }

    public static String getSegmentTypeString(int type) {
        if (64 <= type && type <= 127) {
            return "reserved for future use";
        }
        if (129 <= type && type <= 239) {
            return "private data";
        }
        return switch (type) {
            case 16 -> "page composition segment";
            case 17 -> "region composition segment";
            case 18 -> "CLUT definition segment";
            case 19 -> "object data segment";
            case 20 -> "display definition segment";
            case 21 -> "disparity signalling segment";
            case 22 -> "alternative_CLUT_segment";
            case 128 -> "end of display set segment";
            case 255 -> "stuffing";
            default -> "reserved for future use";
        };
    }

    public static String getPageStateString(int type) {
        return switch (type) {
            case 0 -> "normal case - The display set contains only the subtitle elements that are changed from the previous page instance.";
            case 1 -> "acquisition point - The display set contains all subtitle elements needed to display the next page instance.";
            case 2 -> "mode change - The display set contains all subtitle elements needed to display the new page.";
            case 3 -> "reserved";
            default -> "Illegal value";
        };
    }

    static {
        classLoader = DVBSubtitlingPESDataField.class.getClassLoader();
        try (InputStream fileInputStream576 = classLoader.getResourceAsStream("monitors576.jpg");
             InputStream fileInputStream720 = classLoader.getResourceAsStream("monitors720.jpg");
             InputStream fileInputStream1080 = classLoader.getResourceAsStream("monitors1080.jpg");){
            bgImage576 = ImageIO.read(fileInputStream576);
            bgImage720 = ImageIO.read(fileInputStream720);
            bgImage1080 = ImageIO.read(fileInputStream1080);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "error reading image ", e);
        }
    }
}

