/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling;

import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.Segment;
import nl.digitalekabeltelevisie.util.Utils;

public class DisplayDefinitionSegment
extends Segment {
    public DisplayDefinitionSegment(byte[] data, int offset) {
        super(data, offset);
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP s = super.getJTreeNode(modus);
        s.add(new KVP("dds_version_number", this.getDDSVersionNumber()));
        s.add(new KVP("display_window_flag", this.getDisplayWindowFlag()));
        s.add(new KVP("display_width", this.getDisplayWidth()).setDescription("(" + (this.getDisplayWidth() + 1) + ")"));
        s.add(new KVP("display_height", this.getDisplayHeight()).setDescription("(" + (this.getDisplayHeight() + 1) + ")"));
        if (this.getDisplayWindowFlag() == 1) {
            s.add(new KVP("display_window_horizontal_position_minimum", this.getDisplayWindowHorizontalPositionMinimum()));
            s.add(new KVP("display_window_horizontal_position_maximum", this.getDisplayWindowHorizontalPositionMaximum()));
            s.add(new KVP("display_window_vertical_position_minimum", this.getDisplayWindowVerticalPositionMinimum()));
            s.add(new KVP("display_window_vertical_position_maximum", this.getDisplayWindowVerticalPositionMaximum()));
        }
        return s;
    }

    public int getDisplayWidth() {
        return Utils.getInt(this.data_block, this.offset + 7, 2, 65535);
    }

    public int getDisplayHeight() {
        return Utils.getInt(this.data_block, this.offset + 9, 2, 65535);
    }

    public int getDisplayWindowHorizontalPositionMinimum() {
        return Utils.getInt(this.data_block, this.offset + 11, 2, 65535);
    }

    public int getDisplayWindowHorizontalPositionMaximum() {
        return Utils.getInt(this.data_block, this.offset + 13, 2, 65535);
    }

    public int getDisplayWindowVerticalPositionMinimum() {
        return Utils.getInt(this.data_block, this.offset + 15, 2, 65535);
    }

    public int getDisplayWindowVerticalPositionMaximum() {
        return Utils.getInt(this.data_block, this.offset + 17, 2, 65535);
    }

    public int getDDSVersionNumber() {
        return Utils.getInt(this.data_block, this.offset + 6, 1, 240) >> 4;
    }

    public int getDisplayWindowFlag() {
        return Utils.getInt(this.data_block, this.offset + 6, 1, 8) >> 3;
    }
}

