/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.GeneralPesHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.CLUTDefinitionSegment;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.DisplayDefinitionSegment;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.ObjectDataSegment;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.PageCompositionSegment;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.RegionCompositionSegment;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.Segment;
import nl.digitalekabeltelevisie.gui.ImageSource;
import nl.digitalekabeltelevisie.util.Utils;

public class DisplaySet
implements TreeNode,
ImageSource {
    private List<Segment> segments = new ArrayList<Segment>();
    private List<DisplaySet> epoch = null;
    private GeneralPesHandler pesHandler = null;
    private long pts = 0L;

    public DisplaySet(GeneralPesHandler pesHandler, long pts) {
        this.pesHandler = pesHandler;
        this.pts = pts;
    }

    public long getPts() {
        return this.pts;
    }

    public void setPts(long pts) {
        this.pts = pts;
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = new KVP("Display Set").addImageSource(this, "Display Set");
        t.add(new KVP("pts", this.pts).setDescription(Utils.printTimebase90kHz(this.pts)));
        Utils.addListJTree(t, this.segments, modus, "segments");
        return t;
    }

    @Override
    public BufferedImage getImage() {
        BufferedImage res = null;
        if (this.epoch != null) {
            Object dataArray;
            RegionCompositionSegment[] regions = new RegionCompositionSegment[256];
            WritableRaster[] regionRaster = new WritableRaster[256];
            CLUTDefinitionSegment[] cluts = new CLUTDefinitionSegment[256];
            DisplaySet initDisplaySet = this.epoch.getFirst();
            List<Segment> initDisplaySegments = initDisplaySet.getSegments();
            HashMap<Integer, ObjectDataSegment> objects = new HashMap<Integer, ObjectDataSegment>();
            DisplayDefinitionSegment displayDefinitionSegment = null;
            PageCompositionSegment lastPCS = null;
            ArrayList<RegionCompositionSegment> localRegions = new ArrayList<RegionCompositionSegment>();
            for (Segment segment : initDisplaySegments) {
                if (segment.getSegmentType() == 20) {
                    displayDefinitionSegment = (DisplayDefinitionSegment)segment;
                }
                if (segment.getSegmentType() == 16) {
                    lastPCS = (PageCompositionSegment)segment;
                }
                if (segment.getSegmentType() == 17) {
                    RegionCompositionSegment rcs;
                    regions[rcs.getRegionId()] = rcs = (RegionCompositionSegment)segment;
                    localRegions.add(rcs);
                }
                if (segment.getSegmentType() == 18) {
                    CLUTDefinitionSegment cds;
                    cluts[cds.getCLUTId()] = cds = (CLUTDefinitionSegment)segment;
                }
                if (segment.getSegmentType() != 19) continue;
                ObjectDataSegment ods = (ObjectDataSegment)segment;
                objects.put(ods.getObjectId(), ods);
            }
            for (int j = 0; j < regions.length; ++j) {
                RegionCompositionSegment rcs = regions[j];
                if (rcs == null) continue;
                int index = switch (rcs.getRegionDepth()) {
                    case 1 -> rcs.getRegion2BitPixelCode();
                    case 2 -> rcs.getRegion4BitPixelCode();
                    case 3 -> rcs.getRegion8BitPixelCode();
                    default -> 0;
                };
                dataArray = new byte[rcs.getRegionHeight() * rcs.getRegionWidth()];
                Arrays.fill((byte[])dataArray, Utils.getInt2UnsignedByte(index));
                regionRaster[j] = Raster.createInterleavedRaster(new DataBufferByte((byte[])dataArray, rcs.getRegionWidth() * rcs.getRegionHeight()), rcs.getRegionWidth(), rcs.getRegionHeight(), rcs.getRegionWidth(), 1, new int[]{0}, null);
            }
            DisplaySet.paintObjectsOnRegions(objects, localRegions, regionRaster);
            int k = 1;
            while (k < this.epoch.size()) {
                DisplaySet displaySet = this.epoch.get(k);
                ++k;
                localRegions = new ArrayList();
                List<Segment> segmentList = displaySet.getSegments();
                dataArray = segmentList.iterator();
                while (dataArray.hasNext()) {
                    Segment segment = (Segment)dataArray.next();
                    if (segment.getSegmentType() == 16) {
                        lastPCS = (PageCompositionSegment)segment;
                        continue;
                    }
                    if (segment.getSegmentType() == 17) {
                        RegionCompositionSegment rcs;
                        regions[rcs.getRegionId()] = rcs = (RegionCompositionSegment)segment;
                        localRegions.add(rcs);
                        continue;
                    }
                    if (segment.getSegmentType() == 18) {
                        CLUTDefinitionSegment cds;
                        cluts[cds.getCLUTId()] = cds = (CLUTDefinitionSegment)segment;
                        continue;
                    }
                    if (segment.getSegmentType() != 19) continue;
                    ObjectDataSegment ods = (ObjectDataSegment)segment;
                    objects.put(ods.getObjectId(), ods);
                }
                DisplaySet.paintObjectsOnRegions(objects, localRegions, regionRaster);
            }
            int width = 720;
            int height = 576;
            int x_offset = 0;
            int y_offset = 0;
            if (displayDefinitionSegment != null) {
                width = displayDefinitionSegment.getDisplayWidth() + 1;
                height = displayDefinitionSegment.getDisplayHeight() + 1;
                if (displayDefinitionSegment.getDisplayWindowFlag() == 1) {
                    x_offset = displayDefinitionSegment.getDisplayWindowHorizontalPositionMinimum();
                    y_offset = displayDefinitionSegment.getDisplayWindowVerticalPositionMinimum();
                }
            }
            BufferedImage bgImage = this.pesHandler.getBGImage(height, width, this.pts);
            res = new BufferedImage(width, height, 2);
            Graphics2D resGraphics = res.createGraphics();
            resGraphics.drawImage((Image)bgImage, 0, 0, null);
            if (lastPCS != null) {
                for (PageCompositionSegment.Region region : lastPCS.getRegions()) {
                    RegionCompositionSegment regionCompositionSegment = regions[region.getRegion_id()];
                    if (regionCompositionSegment == null) continue;
                    WritableRaster regionRaste = regionRaster[region.getRegion_id()];
                    IndexColorModel iColorModel = cluts[regionCompositionSegment.getCLUTId()].getColorModel(regionCompositionSegment.getRegionDepth());
                    BufferedImage img = new BufferedImage(iColorModel, regionRaste, false, null);
                    resGraphics.drawImage((Image)img, region.getRegion_horizontal_address() + x_offset, region.getRegion_vertical_address() + y_offset, null);
                }
            }
            return res;
        }
        return null;
    }

    private static void paintObjectsOnRegions(Map<Integer, ObjectDataSegment> objects, List<RegionCompositionSegment> localRegions, WritableRaster[] regionRaster) {
        for (RegionCompositionSegment rcs : localRegions) {
            for (RegionCompositionSegment.RegionObject regionObject : rcs.getRegionObjects()) {
                int object_id = regionObject.getObject_id();
                ObjectDataSegment objectDataSegment = objects.get(object_id);
                if (objectDataSegment == null) continue;
                if (objectDataSegment.getObjectCodingMethod() == 0) {
                    WritableRaster raster = objectDataSegment.getRaster(rcs.getRegionDepth());
                    regionRaster[rcs.getRegionId()].setDataElements(regionObject.getObject_horizontal_position(), regionObject.getObject_vertical_position(), raster);
                    continue;
                }
                if (objectDataSegment.getObjectCodingMethod() != 1) continue;
                Font font = new Font("Arial", 1, 30);
                BufferedImage tmp = new BufferedImage(1, 1, 13);
                Graphics2D g2d = tmp.createGraphics();
                g2d.setFont(font);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                FontRenderContext fontRenderContext = g2d.getFontRenderContext();
                String txt = objectDataSegment.getCharacter_code_string();
                Rectangle2D rect = font.getStringBounds(txt, fontRenderContext);
                IndexColorModel icm = CLUTDefinitionSegment.getDefaultColorModel(rcs.getRegionDepth());
                BufferedImage tmp2 = new BufferedImage((int)rect.getWidth(), (int)rect.getHeight(), 13, icm);
                g2d = tmp2.createGraphics();
                g2d.setFont(font);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g2d.setBackground(new Color(icm.getRGB(regionObject.getBackground_pixel_code())));
                g2d.setColor(new Color(icm.getRGB(regionObject.getForeground_pixel_code())));
                g2d.drawString(txt, 0, (int)(-rect.getY()));
                WritableRaster raster = tmp2.getRaster();
                regionRaster[rcs.getRegionId()].setDataElements(regionObject.getObject_horizontal_position(), regionObject.getObject_vertical_position(), raster);
            }
        }
    }

    public void add(Segment segment) {
        this.segments.add(segment);
    }

    public Segment getSegment(int i) {
        return this.segments.get(i);
    }

    public List<DisplaySet> getEpoch() {
        return this.epoch;
    }

    public void setEpoch(List<DisplaySet> epoch) {
        this.epoch = epoch;
    }

    public GeneralPesHandler getPesHandler() {
        return this.pesHandler;
    }

    public void setPesHandler(GeneralPesHandler pesHandler) {
        this.pesHandler = pesHandler;
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public void setSegments(List<Segment> segments) {
        this.segments = segments;
    }
}

