/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.CLUTDefinitionSegment;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.Segment;
import nl.digitalekabeltelevisie.gui.ImageSource;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.Utils;

public class ObjectDataSegment
extends Segment
implements ImageSource {
    private static final Logger logger = Logger.getLogger(ObjectDataSegment.class.getName());
    private final List<PixelDataSubBlock> topFieldDataBlocks = new ArrayList<PixelDataSubBlock>();
    private List<PixelDataSubBlock> bottomFieldDataBlocks = new ArrayList<PixelDataSubBlock>();
    private int number_of_codes;
    private String character_code_string;
    private static byte[] default_2_to_4_bit_map_table = new byte[]{0, 7, 8, 15};
    private static byte[] default_2_to_8_bit_map_table = new byte[]{0, 119, -120, -1};
    private static byte[] default_4_to_8_bit_map_table = new byte[]{0, 17, 34, 51, 68, 85, 102, 119, -120, -103, -86, 69, -52, -35, -18, -1};

    public ObjectDataSegment(byte[] data, int offset) {
        super(data, offset);
        if (this.getObjectCodingMethod() == 0) {
            int processed_length = 0;
            processed_length = this.readFieldDataBlock(data, offset + 13, this.getTopFieldDataBlockLength(), this.topFieldDataBlocks);
            if (this.getBottomFieldDataBlockLength() != 0) {
                processed_length = this.readFieldDataBlock(data, offset + 13 + processed_length, this.getBottomFieldDataBlockLength(), this.bottomFieldDataBlocks);
            } else {
                this.bottomFieldDataBlocks = this.topFieldDataBlocks;
            }
        } else if (this.getObjectCodingMethod() == 1) {
            this.number_of_codes = Utils.getInt(data, offset + 9, 1, 255);
            int[] text = new int[this.number_of_codes];
            int txtLen = 0;
            for (int i = 0; i < this.number_of_codes; ++i) {
                int character_code = (int)Utils.getLong(data, offset + 10 + i * 2, 2, 65535L);
                if (character_code < 32) continue;
                text[txtLen++] = character_code;
            }
            this.character_code_string = new String(text, 0, txtLen);
        }
    }

    private int readFieldDataBlock(byte[] data, int offset, int fieldDataBlockLength, List<PixelDataSubBlock> pixelDataSubBlockList) {
        int processed_length;
        int blockStart;
        BitSource bs;
        for (processed_length = 0; processed_length < fieldDataBlockLength && this.isMoreDataAvaliable(offset, processed_length); processed_length += bs.getNextFullByteOffset() - blockStart) {
            blockStart = offset + processed_length;
            int dataType = Utils.getInt(this.data_block, blockStart, 1, 255);
            PixelDataSubBlock b = new PixelDataSubBlock(data, blockStart);
            bs = new BitSource(data, blockStart + 1);
            switch (dataType) {
                case 16: {
                    ObjectDataSegment.two_bit_pixel_code_string(bs, b);
                    break;
                }
                case 17: {
                    ObjectDataSegment.four_bit_pixel_code_string(bs, b);
                    break;
                }
                case 18: {
                    ObjectDataSegment.eigth_bit_pixel_code_string(bs, b);
                    break;
                }
                case 32: {
                    ObjectDataSegment.two_to_4_bit_map_table(bs, b);
                    break;
                }
                case 33: {
                    ObjectDataSegment.two_to_8_bit_map_table(bs, b);
                    break;
                }
                case 34: {
                    ObjectDataSegment.four_to_8_bit_map_table(bs, b);
                    break;
                }
                case 240: {
                    break;
                }
            }
            pixelDataSubBlockList.add(b);
        }
        return processed_length;
    }

    private boolean isMoreDataAvaliable(int offset, int processed_length) {
        boolean moreDataAvailable;
        boolean bl = moreDataAvailable = offset + processed_length < this.data_block.length;
        if (!moreDataAvailable) {
            logger.warning("less data available than expected; (offset:" + offset + "+processed_length:" + processed_length + ")>=data_block.length:" + this.data_block.length);
        }
        return moreDataAvailable;
    }

    private static void two_to_4_bit_map_table(BitSource bs, PixelDataSubBlock b) {
        byte[] table = new byte[4];
        for (int i = 0; i < 4; ++i) {
            table[i] = (byte)bs.readBits(4);
        }
        b.setTable_2_to_4_bit_map_table(table);
    }

    private static void two_to_8_bit_map_table(BitSource bs, PixelDataSubBlock b) {
        byte[] table = new byte[4];
        for (int i = 0; i < 4; ++i) {
            table[i] = bs.readSignedByte(8);
        }
        b.setTable_2_to_8_bit_map_table(table);
    }

    private static void four_to_8_bit_map_table(BitSource bs, PixelDataSubBlock b) {
        byte[] table = new byte[16];
        for (int i = 0; i < 4; ++i) {
            table[i] = bs.readSignedByte(8);
        }
        b.setTable_4_to_8_bit_map_table(table);
    }

    private static void two_bit_pixel_code_string(BitSource bs, PixelDataSubBlock b) {
        boolean readMore = true;
        do {
            int bits;
            if ((bits = bs.readBits(2)) != 0) {
                b.addPixel((byte)bits);
                continue;
            }
            int switch_1 = bs.readBits(1);
            if (switch_1 == 1) {
                int run_length_3_10 = bs.readBits(3);
                int two_bit_pixel_code = bs.readBits(2);
                b.addIdenticalPixel((byte)two_bit_pixel_code, run_length_3_10 + 3);
                continue;
            }
            int switch_2 = bs.readBits(1);
            if (switch_2 == 0) {
                int two_bit_pixel_code;
                int switch_3 = bs.readBits(2);
                if (switch_3 == 2) {
                    int run_length_12_27 = bs.readBits(4);
                    two_bit_pixel_code = bs.readBits(2);
                    b.addIdenticalPixel((byte)two_bit_pixel_code, run_length_12_27 + 12);
                }
                if (switch_3 == 3) {
                    int run_length_29_284 = bs.readBits(8);
                    two_bit_pixel_code = bs.readBits(2);
                    b.addIdenticalPixel((byte)two_bit_pixel_code, run_length_29_284 + 29);
                }
                if (switch_3 == 0) {
                    readMore = false;
                }
                if (switch_3 != 1) continue;
                b.addIdenticalPixel((byte)0, 2);
                continue;
            }
            b.addPixel((byte)0);
        } while (readMore);
    }

    private static void four_bit_pixel_code_string(BitSource bs, PixelDataSubBlock b) {
        boolean readMore = true;
        do {
            int pixel_code;
            if (bs.available() < 4) {
                readMore = false;
                logger.warning("bits available: " + bs.available());
                continue;
            }
            int bits = bs.readBits(4);
            if (bits != 0) {
                b.addPixel((byte)bits);
                continue;
            }
            int switch_1 = bs.readBits(1);
            if (switch_1 == 0) {
                int nextbits = bs.readBits(3);
                if (nextbits != 0) {
                    int run_length_3_9 = nextbits;
                    b.addIdenticalPixel((byte)0, run_length_3_9 + 2);
                    continue;
                }
                readMore = false;
                continue;
            }
            int switch_2 = bs.readBits(1);
            if (switch_2 == 0) {
                int run_length_4_7 = bs.readBits(2);
                int pixel_code2 = bs.readBits(4);
                b.addIdenticalPixel((byte)pixel_code2, run_length_4_7 + 4);
                continue;
            }
            int switch_3 = bs.readBits(2);
            if (switch_3 == 0) {
                b.addPixel((byte)0);
            }
            if (switch_3 == 1) {
                b.addIdenticalPixel((byte)0, 2);
            }
            if (switch_3 == 2) {
                int run_length_9_24 = bs.readBits(4);
                pixel_code = bs.readBits(4);
                b.addIdenticalPixel((byte)pixel_code, run_length_9_24 + 9);
            }
            if (switch_3 != 3) continue;
            int run_length_25_280 = bs.readBits(8);
            pixel_code = bs.readBits(4);
            b.addIdenticalPixel((byte)pixel_code, run_length_25_280 + 25);
        } while (readMore);
    }

    private static void eigth_bit_pixel_code_string(BitSource bs, PixelDataSubBlock b) {
        boolean readMore = true;
        do {
            int bits;
            if ((bits = bs.readBits(8)) != 0) {
                b.addPixel(Utils.getInt2UnsignedByte(bits));
                continue;
            }
            int switch_1 = bs.readBits(1);
            if (switch_1 == 0) {
                int nextbits = bs.readBits(7);
                if (nextbits != 0) {
                    int run_length_1_127 = nextbits;
                    b.addIdenticalPixel((byte)0, run_length_1_127);
                    continue;
                }
                readMore = false;
                continue;
            }
            int run_length_3_127 = bs.readBits(7);
            int pixel_code = bs.readBits(8);
            b.addIdenticalPixel(Utils.getInt2UnsignedByte(pixel_code), run_length_3_127);
        } while (readMore);
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP s = super.getJTreeNode(modus).addImageSource(this, "Object Data Segment");
        s.add(new KVP("object_id", this.getObjectId()));
        s.add(new KVP("object_version_number", this.getObjectVersionNumber()));
        s.add(new KVP("object_coding_method", this.getObjectCodingMethod()).setDescription(ObjectDataSegment.getObjectCodingMethodString(this.getObjectCodingMethod())));
        s.add(new KVP("non_modifying_colour_flag", this.getNonModifyingColourFlag()));
        if (this.getObjectCodingMethod() == 0) {
            s.add(new KVP("top_field_data_block_length", this.getTopFieldDataBlockLength()));
            s.add(new KVP("bottom_field_data_block_length", this.getBottomFieldDataBlockLength()));
            Utils.addListJTree(s, this.topFieldDataBlocks, modus, "top field pixel-data_sub-block");
            if (this.getBottomFieldDataBlockLength() != 0) {
                Utils.addListJTree(s, this.bottomFieldDataBlocks, modus, "bottom field pixel-data_sub-block");
            }
        } else if (this.getObjectCodingMethod() == 1) {
            s.add(new KVP("number_of_codes", this.number_of_codes));
            s.add(new KVP("character_codes", this.character_code_string));
        }
        return s;
    }

    private int getTopFieldDataBlockLength() {
        return Utils.getInt(this.data_block, this.offset + 9, 2, 65535);
    }

    private int getBottomFieldDataBlockLength() {
        return Utils.getInt(this.data_block, this.offset + 11, 2, 65535);
    }

    public int getObjectCodingMethod() {
        return Utils.getInt(this.data_block, this.offset + 8, 1, 12) >> 2;
    }

    public int getNonModifyingColourFlag() {
        return Utils.getInt(this.data_block, this.offset + 8, 1, 2) >> 1;
    }

    public int getObjectVersionNumber() {
        return Utils.getInt(this.data_block, this.offset + 8, 1, 240) >> 4;
    }

    public int getObjectId() {
        return Utils.getInt(this.data_block, this.offset + 6, 2, 65535);
    }

    public static String getObjectCodingMethodString(int type) {
        return switch (type) {
            case 0 -> "coding of pixels";
            case 1 -> "coded as a string of characters";
            case 2 -> "progressive coding of pixels";
            case 3 -> "reserved";
            default -> "Illegal value";
        };
    }

    public static String getDataTypeString(int type) {
        return switch (type) {
            case 16 -> "2-bit/pixel code string";
            case 17 -> "4-bit/pixel code string";
            case 18 -> "8-bit/pixel code string";
            case 32 -> "2_to_4-bit_map-table data";
            case 33 -> "2_to_8-bit_map-table data";
            case 34 -> "4_to_8-bit_map-table data";
            case 240 -> "end of object line code";
            default -> "reserved";
        };
    }

    @Override
    public BufferedImage getImage() {
        if (this.getObjectCodingMethod() == 0) {
            BufferedImage bi = null;
            WritableRaster wr = this.getRaster(2);
            if (wr == null) {
                return null;
            }
            IndexColorModel cm = CLUTDefinitionSegment.getDefault_CLUT_8bitColorModel();
            bi = new BufferedImage(cm, wr, false, null);
            return bi;
        }
        return null;
    }

    public List<PixelDataSubBlock> getTopFieldDataBlocks() {
        return this.topFieldDataBlocks;
    }

    public List<PixelDataSubBlock> getBottomFieldDataBlocks() {
        return this.bottomFieldDataBlocks;
    }

    public static Logger getLogger() {
        return logger;
    }

    public int getNumber_of_codes() {
        return this.number_of_codes;
    }

    public String getCharacter_code_string() {
        return this.character_code_string;
    }

    public WritableRaster getRaster(int regionDepth) {
        byte[] remappedPix;
        int dataType;
        int dataType2;
        if (this.getObjectCodingMethod() != 0) {
            return null;
        }
        int width = -1;
        int height = -1;
        int topLines = 0;
        int bottomLines = 0;
        int linewidth = 0;
        for (PixelDataSubBlock block : this.topFieldDataBlocks) {
            dataType2 = block.getDataType();
            if (dataType2 >= 16 && dataType2 <= 18) {
                linewidth += block.getNo_pixels();
                continue;
            }
            if (dataType2 != 240) continue;
            ++topLines;
            if (linewidth > width) {
                width = linewidth;
            }
            linewidth = 0;
        }
        for (PixelDataSubBlock block : this.bottomFieldDataBlocks) {
            dataType2 = block.getDataType();
            if (dataType2 >= 16 && dataType2 <= 18) {
                linewidth += block.getNo_pixels();
                continue;
            }
            if (dataType2 != 240) continue;
            ++bottomLines;
            if (linewidth > width) {
                width = linewidth;
            }
            linewidth = 0;
        }
        if (topLines != bottomLines && topLines != bottomLines + 1) {
            logger.log(Level.WARNING, "topLines " + topLines + " not matching bottomLines " + bottomLines);
            return null;
        }
        height = topLines + bottomLines;
        byte[] dataBuffer = new byte[height * width];
        int line = 0;
        int linepos = 0;
        byte[] two_to_4_bit_map_table = default_2_to_4_bit_map_table;
        byte[] two_to_8_bit_map_table = default_2_to_8_bit_map_table;
        byte[] four_to_8_bit_map_table = default_4_to_8_bit_map_table;
        for (PixelDataSubBlock block : this.topFieldDataBlocks) {
            dataType = block.getDataType();
            if (dataType >= 16 && dataType <= 18) {
                if (dataType - 15 >= regionDepth) {
                    System.arraycopy(block.getPixels(), 0, dataBuffer, 2 * line * width + linepos, block.getNo_pixels());
                } else {
                    remappedPix = ObjectDataSegment.mapTable(regionDepth, two_to_4_bit_map_table, two_to_8_bit_map_table, four_to_8_bit_map_table, block, dataType);
                    System.arraycopy(remappedPix, 0, dataBuffer, 2 * line * width + linepos, block.getNo_pixels());
                }
                linepos += block.getNo_pixels();
                continue;
            }
            if (dataType == 32) {
                two_to_4_bit_map_table = block.getTable_2_to_4_bit_map_table();
                continue;
            }
            if (dataType == 33) {
                two_to_8_bit_map_table = block.getTable_2_to_8_bit_map_table();
                continue;
            }
            if (dataType <= 34) {
                four_to_8_bit_map_table = block.getTable_4_to_8_bit_map_table();
                continue;
            }
            if (dataType != 240) continue;
            ++line;
            linepos = 0;
        }
        line = 0;
        linepos = 0;
        two_to_4_bit_map_table = default_2_to_4_bit_map_table;
        two_to_8_bit_map_table = default_2_to_8_bit_map_table;
        four_to_8_bit_map_table = default_4_to_8_bit_map_table;
        for (PixelDataSubBlock block : this.bottomFieldDataBlocks) {
            dataType = block.getDataType();
            if (dataType >= 16 && dataType <= 18) {
                if (dataType - 15 >= regionDepth) {
                    System.arraycopy(block.getPixels(), 0, dataBuffer, (1 + 2 * line) * width + linepos, block.getNo_pixels());
                } else {
                    remappedPix = ObjectDataSegment.mapTable(regionDepth, two_to_4_bit_map_table, two_to_8_bit_map_table, four_to_8_bit_map_table, block, dataType);
                    System.arraycopy(remappedPix, 0, dataBuffer, (1 + 2 * line) * width + linepos, block.getNo_pixels());
                }
                linepos += block.getNo_pixels();
                continue;
            }
            if (dataType == 32) {
                two_to_4_bit_map_table = block.getTable_2_to_4_bit_map_table();
                continue;
            }
            if (dataType == 33) {
                two_to_8_bit_map_table = block.getTable_2_to_8_bit_map_table();
                continue;
            }
            if (dataType <= 34) {
                four_to_8_bit_map_table = block.getTable_4_to_8_bit_map_table();
                continue;
            }
            if (dataType != 240) continue;
            ++line;
            linepos = 0;
        }
        DataBufferByte dBuffer = new DataBufferByte(dataBuffer, width * height);
        return Raster.createInterleavedRaster(dBuffer, width, height, width, 1, new int[]{0}, null);
    }

    private static byte[] mapTable(int regionDepth, byte[] two_to_4_bit_map_table, byte[] two_to_8_bit_map_table, byte[] four_to_8_bit_map_table, PixelDataSubBlock block, int dataType) {
        byte[] useMap = dataType == 16 ? (regionDepth == 2 ? two_to_4_bit_map_table : two_to_8_bit_map_table) : four_to_8_bit_map_table;
        byte[] orgPix = block.getPixels();
        byte[] remappedPix = new byte[block.getNo_pixels()];
        for (int i = 0; i < block.getNo_pixels(); ++i) {
            remappedPix[i] = useMap[orgPix[i]];
        }
        return remappedPix;
    }

    public static class PixelDataSubBlock
    implements TreeNode {
        protected byte[] data_block;
        protected int offset;
        private final int dataType;
        protected byte[] pixels = new byte[720];
        protected int no_pixels;
        private byte[] table_2_to_4_bit_map_table = null;
        private byte[] table_2_to_8_bit_map_table = null;
        private byte[] table_4_to_8_bit_map_table = null;

        public PixelDataSubBlock(byte[] data, int offset) {
            this.data_block = data;
            this.offset = offset;
            this.dataType = Utils.getInt(this.data_block, offset, 1, 255);
        }

        @Override
        public KVP getJTreeNode(int modus) {
            KVP s;
            block5: {
                block7: {
                    block6: {
                        block4: {
                            s = new KVP("pixel-data_sub-block " + ObjectDataSegment.getDataTypeString(this.dataType));
                            s.add(new KVP("data_type", this.dataType).setDescription(ObjectDataSegment.getDataTypeString(this.dataType)));
                            if (this.dataType < 16 || this.dataType > 18) break block4;
                            s.add(new KVP("no_pixels", this.no_pixels));
                            s.add(new KVP("pixels", this.pixels, 0, this.no_pixels));
                            break block5;
                        }
                        if (this.dataType != 32) break block6;
                        if (this.table_2_to_4_bit_map_table == null) break block5;
                        for (int i = 0; i < this.table_2_to_4_bit_map_table.length; ++i) {
                            s.add(new KVP("entry [" + i + "]", this.table_2_to_4_bit_map_table[i]));
                        }
                        break block5;
                    }
                    if (this.dataType != 33) break block7;
                    if (this.table_2_to_8_bit_map_table == null) break block5;
                    for (int i = 0; i < this.table_2_to_8_bit_map_table.length; ++i) {
                        s.add(new KVP("entry [" + i + "]", this.table_2_to_8_bit_map_table[i]));
                    }
                    break block5;
                }
                if (this.dataType == 34 && this.table_4_to_8_bit_map_table != null) {
                    for (int i = 0; i < this.table_4_to_8_bit_map_table.length; ++i) {
                        s.add(new KVP("entry [" + i + "]", this.table_4_to_8_bit_map_table[i]));
                    }
                }
            }
            return s;
        }

        public void addPixel(byte p) {
            if (this.no_pixels >= this.pixels.length) {
                this.pixels = Arrays.copyOf(this.pixels, this.no_pixels * 2);
            }
            this.pixels[this.no_pixels++] = p;
        }

        public void addIdenticalPixel(byte pixel, int no) {
            if (this.pixels == null) {
                this.pixels = new byte[720];
            }
            if (no + this.no_pixels >= this.pixels.length) {
                this.pixels = Arrays.copyOf(this.pixels, this.no_pixels * 2);
            }
            Arrays.fill(this.pixels, this.no_pixels, this.no_pixels + no, pixel);
            this.no_pixels += no;
        }

        public int getDataType() {
            return this.dataType;
        }

        public int getNo_pixels() {
            return this.no_pixels;
        }

        public byte[] getPixels() {
            return this.pixels;
        }

        public byte[] getTable_2_to_4_bit_map_table() {
            return this.table_2_to_4_bit_map_table;
        }

        public void setTable_2_to_4_bit_map_table(byte[] table_2_to_4_bit_map_table) {
            this.table_2_to_4_bit_map_table = table_2_to_4_bit_map_table;
        }

        public byte[] getTable_2_to_8_bit_map_table() {
            return this.table_2_to_8_bit_map_table;
        }

        public void setTable_2_to_8_bit_map_table(byte[] table_2_to_8_bit_map_table) {
            this.table_2_to_8_bit_map_table = table_2_to_8_bit_map_table;
        }

        public byte[] getTable_4_to_8_bit_map_table() {
            return this.table_4_to_8_bit_map_table;
        }

        public void setTable_4_to_8_bit_map_table(byte[] table_4_to_8_bit_map_table) {
            this.table_4_to_8_bit_map_table = table_4_to_8_bit_map_table;
        }
    }
}

