/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling;

import java.util.ArrayList;
import java.util.List;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.DVBSubtitlingPESDataField;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.Segment;
import nl.digitalekabeltelevisie.util.Utils;

public class PageCompositionSegment
extends Segment {
    public PageCompositionSegment(byte[] data, int offset) {
        super(data, offset);
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP s = super.getJTreeNode(modus);
        s.add(new KVP("page_time_out", this.getPageTimeOut()));
        s.add(new KVP("page_version_number", this.getPageVersionNumber()));
        s.add(new KVP("page_state", this.getPageState()).setDescription(DVBSubtitlingPESDataField.getPageStateString(this.getPageState())));
        Utils.addListJTree(s, this.getRegions(), modus, "regions");
        return s;
    }

    public int getPageState() {
        return Utils.getInt(this.data_block, this.offset + 7, 1, 12) >> 2;
    }

    public int getPageVersionNumber() {
        return Utils.getInt(this.data_block, this.offset + 7, 1, 240) >> 4;
    }

    public int getPageTimeOut() {
        return Utils.getInt(this.data_block, this.offset + 6, 1, 255);
    }

    public List<Region> getRegions() {
        ArrayList<Region> regions = new ArrayList<Region>();
        int t = 0;
        while (t + 2 < this.getSegmentLength()) {
            int region = Utils.getInt(this.data_block, this.offset + 8 + t, 1, 255);
            int res = Utils.getInt(this.data_block, this.offset + 9 + t, 1, 255);
            int hor = Utils.getInt(this.data_block, this.offset + 10 + t, 2, 65535);
            int ver = Utils.getInt(this.data_block, this.offset + 12 + t, 2, 65535);
            regions.add(new Region(region, res, hor, ver));
            t += 6;
        }
        return regions;
    }

    public static class Region
    implements TreeNode {
        private int region_id;
        private int reserved;
        private int region_horizontal_address;
        private int region_vertical_address;

        public Region(int region_id, int reserved, int region_horizontal_address, int region_vertical_address) {
            this.region_id = region_id;
            this.reserved = reserved;
            this.region_horizontal_address = region_horizontal_address;
            this.region_vertical_address = region_vertical_address;
        }

        @Override
        public KVP getJTreeNode(int modus) {
            KVP s = new KVP("Region");
            s.add(new KVP("region_id", this.region_id));
            s.add(new KVP("reserved", this.reserved));
            s.add(new KVP("region_horizontal_address", this.region_horizontal_address));
            s.add(new KVP("region_vertical_address", this.region_vertical_address));
            return s;
        }

        public int getRegion_horizontal_address() {
            return this.region_horizontal_address;
        }

        public int getRegion_id() {
            return this.region_id;
        }

        public int getRegion_vertical_address() {
            return this.region_vertical_address;
        }

        public int getReserved() {
            return this.reserved;
        }
    }
}

