/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling;

import java.util.ArrayList;
import java.util.List;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.Segment;
import nl.digitalekabeltelevisie.util.Utils;

public class RegionCompositionSegment
extends Segment {
    public RegionCompositionSegment(byte[] data, int offset) {
        super(data, offset);
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP s = super.getJTreeNode(modus);
        s.add(new KVP("region_id", this.getRegionId()));
        s.add(new KVP("region_version_number", this.getRegionVersionNumber()));
        s.add(new KVP("region_fill_flag", this.getRegionFillFlag()));
        s.add(new KVP("region_width", this.getRegionWidth()));
        s.add(new KVP("region_height", this.getRegionHeight()));
        s.add(new KVP("region_level_of_compatibility", this.getRegionLevelOfCompatibility()).setDescription(RegionCompositionSegment.getRegionLevelOfCompatibilityString(this.getRegionLevelOfCompatibility())));
        s.add(new KVP("region_depth", this.getRegionDepth()).setDescription(RegionCompositionSegment.getRegionDepthString(this.getRegionDepth())));
        s.add(new KVP("CLUT_id", this.getCLUTId()));
        s.add(new KVP("region_8-bit_pixel_code", this.getRegion8BitPixelCode()));
        s.add(new KVP("region_4-bit_pixel-code", this.getRegion4BitPixelCode()));
        s.add(new KVP("region_2-bit_pixel-code", this.getRegion2BitPixelCode()));
        Utils.addListJTree(s, this.getRegionObjects(), modus, "regions");
        return s;
    }

    public int getRegion2BitPixelCode() {
        return Utils.getInt(this.data_block, this.offset + 15, 1, 12) >> 2;
    }

    public int getRegion4BitPixelCode() {
        return Utils.getInt(this.data_block, this.offset + 15, 1, 240) >> 4;
    }

    public int getRegion8BitPixelCode() {
        return Utils.getInt(this.data_block, this.offset + 14, 1, 255);
    }

    public int getCLUTId() {
        return Utils.getInt(this.data_block, this.offset + 13, 1, 255);
    }

    public int getRegionHeight() {
        return Utils.getInt(this.data_block, this.offset + 10, 2, 65535);
    }

    public int getRegionWidth() {
        return Utils.getInt(this.data_block, this.offset + 8, 2, 65535);
    }

    public int getRegionFillFlag() {
        return Utils.getInt(this.data_block, this.offset + 7, 1, 8) >> 3;
    }

    public int getRegionVersionNumber() {
        return Utils.getInt(this.data_block, this.offset + 7, 1, 240) >> 4;
    }

    public int getRegionId() {
        return Utils.getInt(this.data_block, this.offset + 6, 1, 255);
    }

    public List<RegionObject> getRegionObjects() {
        ArrayList<RegionObject> regions = new ArrayList<RegionObject>();
        int t = 0;
        while (t + 10 < this.getSegmentLength()) {
            int object_id = Utils.getInt(this.data_block, this.offset + 16 + t, 2, 65535);
            int object_type = Utils.getInt(this.data_block, this.offset + 18 + t, 1, 192) >> 6;
            int object_provider_flag = Utils.getInt(this.data_block, this.offset + 18 + t, 1, 48) >> 4;
            int object_horizontal_position = Utils.getInt(this.data_block, this.offset + 18 + t, 2, 4095);
            int object_vertical_position = Utils.getInt(this.data_block, this.offset + 20 + t, 2, 4095);
            int foreground_pixel_code = 0;
            int background_pixel_code = 0;
            if (object_type == 1 || object_type == 2) {
                foreground_pixel_code = Utils.getInt(this.data_block, this.offset + 22 + t, 1, 255);
                background_pixel_code = Utils.getInt(this.data_block, this.offset + 23 + t, 1, 255);
                t += 2;
            }
            regions.add(new RegionObject(object_id, object_type, object_provider_flag, object_horizontal_position, object_vertical_position, foreground_pixel_code, background_pixel_code));
            t += 6;
        }
        return regions;
    }

    public int getRegionDepth() {
        return Utils.getInt(this.data_block, this.offset + 12, 1, 28) >> 2;
    }

    public int getRegionLevelOfCompatibility() {
        return Utils.getInt(this.data_block, this.offset + 12, 1, 224) >> 5;
    }

    public static String getRegionLevelOfCompatibilityString(int type) {
        return switch (type) {
            case 0 -> "reserved";
            case 1 -> "2-bit/entry CLUT required";
            case 2 -> "4-bit/entry CLUT required";
            case 3 -> "8-bit/entry CLUT required";
            default -> "reserved";
        };
    }

    public static String getRegionDepthString(int type) {
        return switch (type) {
            case 0 -> "reserved";
            case 1 -> "2 bit";
            case 2 -> "4 bit";
            case 3 -> "8 bit";
            default -> "reserved";
        };
    }

    public static String getObjectTypeString(int type) {
        return switch (type) {
            case 0 -> "basic_object, bitmap";
            case 1 -> "basic_object, character";
            case 2 -> "composite_object, string of characters";
            case 3 -> "reserved";
            default -> "Illegal value";
        };
    }

    public static String getObjectProviderString(int type) {
        return switch (type) {
            case 0 -> "provided in the subtitling stream";
            case 1 -> "provided by a ROM in the IRD";
            case 2 -> "Reserved";
            case 3 -> "reserved";
            default -> "Illegal value";
        };
    }

    public static class RegionObject
    implements TreeNode {
        private int object_id;
        private int object_type;
        private int object_provider_flag;
        private int object_horizontal_position;
        private int object_vertical_position;
        private int foreground_pixel_code = 0;
        private int background_pixel_code = 0;

        public RegionObject(int object_id, int object_type, int object_provider_flag, int object_horizontal_position, int object_vertical_position, int foreground_pixel_code, int background_pixel_code) {
            this.object_id = object_id;
            this.object_type = object_type;
            this.object_provider_flag = object_provider_flag;
            this.object_horizontal_position = object_horizontal_position;
            this.object_vertical_position = object_vertical_position;
            this.foreground_pixel_code = foreground_pixel_code;
            this.background_pixel_code = background_pixel_code;
        }

        @Override
        public KVP getJTreeNode(int modus) {
            KVP s = new KVP("Object");
            s.add(new KVP("object_id", this.object_id));
            s.add(new KVP("object_type", this.object_type).setDescription(RegionCompositionSegment.getObjectTypeString(this.object_type)));
            s.add(new KVP("object_provider_flag", this.object_provider_flag).setDescription(RegionCompositionSegment.getObjectProviderString(this.object_provider_flag)));
            s.add(new KVP("object_horizontal_position", this.object_horizontal_position));
            s.add(new KVP("object_vertical_position", this.object_vertical_position));
            if (this.object_type == 1 || this.object_type == 2) {
                s.add(new KVP("foreground_pixel_code", this.foreground_pixel_code));
                s.add(new KVP("background_pixel_code", this.background_pixel_code));
            }
            return s;
        }

        public int getBackground_pixel_code() {
            return this.background_pixel_code;
        }

        public int getForeground_pixel_code() {
            return this.foreground_pixel_code;
        }

        public int getObject_horizontal_position() {
            return this.object_horizontal_position;
        }

        public int getObject_id() {
            return this.object_id;
        }

        public int getObject_provider_flag() {
            return this.object_provider_flag;
        }

        public int getObject_type() {
            return this.object_type;
        }

        public int getObject_vertical_position() {
            return this.object_vertical_position;
        }
    }
}

