/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.ebu;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.SubPage;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.TxtDataField;
import nl.digitalekabeltelevisie.gui.ImageSource;
import nl.digitalekabeltelevisie.util.Utils;

class DRCSCharacter
implements TreeNode,
ImageSource {
    private final int mode;
    private final TxtDataField line;
    private final int drcsNumber;
    private BufferedImage fBufferedImage;
    private DataBuffer dataBuffer;
    private WritableRaster writableRaster;

    DRCSCharacter(int drcsMode, SubPage page, int i) {
        this.drcsNumber = i;
        this.mode = drcsMode;
        this.line = page.linesList[1 + i / 2];
        if (this.line != null && this.mode == 0) {
            byte[] rawData = this.line.getPageDataBytes();
            int offset = 0;
            if (i % 2 != 0) {
                offset = 20;
            }
            int fWidth = 12;
            int fHeight = 10;
            int bytesPerRow = 2;
            byte[] imgData = new byte[20];
            for (int j = 0; j < 20; j += 2) {
                byte left = Utils.getInt2UnsignedByte((rawData[offset + j] & 0x3F) << 2 | (rawData[offset + j + 1] & 0x30) >> 4);
                byte right = Utils.getInt2UnsignedByte((rawData[offset + j + 1] & 0xF) << 4);
                imgData[j] = left;
                imgData[j + 1] = right;
            }
            byte[] bw = new byte[]{-1, 0};
            IndexColorModel blackAndWhite = new IndexColorModel(1, 2, bw, bw, bw);
            this.dataBuffer = new DataBufferByte(imgData, imgData.length);
            this.writableRaster = Raster.createPackedRaster(this.dataBuffer, 12, 10, 1, null);
            this.fBufferedImage = new BufferedImage(blackAndWhite, this.writableRaster, true, null);
        }
    }

    @Override
    public KVP getJTreeNode(int modus) {
        return new KVP("DRCS Character " + this.drcsNumber + ", mode=" + this.mode + " (" + DRCSCharacter.getDRCSModeString(this.mode) + ")").addImageSource(this, "DRCS Character");
    }

    @Override
    public BufferedImage getImage() {
        return this.fBufferedImage;
    }

    private static String getDRCSModeString(int drcsMode) {
        return switch (drcsMode) {
            case 0 -> "12 x 10 x 1";
            case 1 -> "12 x 10 x 2";
            case 2 -> "12 x 10 x 4";
            case 3 -> "6 x 5 x 4";
            case 14 -> "Subsequent PTU of a Mode 1 or 2 character";
            case 15 -> "No data for the corresponding character";
            default -> "reserved for future use";
        };
    }

    public DataBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    public int getDrcsNumber() {
        return this.drcsNumber;
    }

    public TxtDataField getLine() {
        return this.line;
    }

    public int getMode() {
        return this.mode;
    }

    public WritableRaster getWritableRaster() {
        return this.writableRaster;
    }
}

