/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.ebu;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PesPacketData;
import nl.digitalekabeltelevisie.data.mpeg.pes.GeneralPesHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.EBUDataField;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.EBUPESDataField;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.TxtDataField;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.TxtService;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.VPSDataField;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.WSSDataField;
import nl.digitalekabeltelevisie.gui.SaveAble;
import nl.digitalekabeltelevisie.util.Utils;

public class EBUTeletextHandler
extends GeneralPesHandler
implements SaveAble {
    private static final Logger logger = Logger.getLogger(EBUTeletextHandler.class.getName());
    private TxtService txtService;
    private List<VPSDataField> vps = new ArrayList<VPSDataField>();
    private List<WSSDataField> wss = new ArrayList<WSSDataField>();

    public static String getObjectTypeString(int objectType) {
        return switch (objectType) {
            case 0 -> "No default object required";
            case 1 -> "Active";
            case 2 -> "Adaptive";
            case 3 -> "Passive";
            default -> "illegal value";
        };
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP kvp = new KVP("EBU PES Data");
        JMenuItem objectMenu = new JMenuItem("Save Txt Service as .t42");
        objectMenu.setActionCommand("t42");
        kvp.setSubMenuAndOwner(objectMenu, this);
        Utils.addListJTree(kvp, this.pesPackets, modus, "PES Packets");
        KVP t = new KVP("EBU Data");
        if (this.txtService != null) {
            t.add(this.txtService.getJTreeNode(modus));
        }
        Utils.addListJTree(t, this.vps, modus, "VPS");
        Utils.addListJTree(t, this.wss, modus, "WSS");
        kvp.add(t);
        return kvp;
    }

    @Override
    protected void processPesDataBytes(PesPacketData pesData) {
        EBUPESDataField pesDataField = new EBUPESDataField(pesData);
        this.pesPackets.add(pesDataField);
        List<EBUDataField> lines = pesDataField.getFieldList();
        for (EBUDataField ebuData : lines) {
            EBUDataField eBUDataField;
            Objects.requireNonNull(ebuData);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TxtDataField.class, VPSDataField.class, WSSDataField.class}, (Object)eBUDataField, n)) {
                case 0: {
                    TxtDataField txtDataField = (TxtDataField)eBUDataField;
                    if (this.txtService == null) {
                        this.txtService = new TxtService(this.getTransportStream());
                    }
                    this.txtService.addTxtDataField(txtDataField);
                    break;
                }
                case 1: {
                    VPSDataField vpsDataField = (VPSDataField)eBUDataField;
                    EBUTeletextHandler.add(vpsDataField, this.vps);
                    break;
                }
                case 2: {
                    WSSDataField wssDataField = (WSSDataField)eBUDataField;
                    EBUTeletextHandler.add(wssDataField, this.wss);
                    break;
                }
            }
        }
    }

    protected static <T extends EBUDataField> void add(T ebuData, List<T> v) {
        int i = v.indexOf(ebuData);
        if (i == -1) {
            v.add(ebuData);
        } else {
            ((EBUDataField)v.get(i)).incCount(1);
        }
    }

    public TxtService getTxtService() {
        return this.txtService;
    }

    public List<VPSDataField> getVps() {
        return this.vps;
    }

    public List<WSSDataField> getWss() {
        return this.wss;
    }

    @Override
    public void save(File file) {
        try (FileOutputStream out = new FileOutputStream(file);){
            for (PesPacketData packet : this.pesPackets) {
                if (!(packet instanceof EBUPESDataField)) continue;
                EBUPESDataField ebuDataField = (EBUPESDataField)packet;
                for (EBUDataField field : ebuDataField.getFieldList()) {
                    EBUTeletextHandler.saveLineT42(out, field);
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "could not write file", e);
        }
    }

    public static void saveLineT42(FileOutputStream out, EBUDataField line) throws IOException {
        if (line != null) {
            byte[] d = line.getData_block();
            int offset = line.getOffset();
            for (int i = 4; i < 46; ++i) {
                out.write(Utils.invtab[Byte.toUnsignedInt(d[offset + i])]);
            }
        }
    }
}

