/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.ebu;

import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.Page;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.TxtDataField;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.TxtService;

public class Magazine
implements TreeNode {
    private final TxtService txtServiceHandler;
    private int magazineNo;
    private final TxtDataField[] pageEnhanceMentDataPackes = new TxtDataField[16];
    private Page currentPage;
    private final Page[] pageList = new Page[256];

    public Magazine(TxtService service, int mag) {
        this.txtServiceHandler = service;
        this.magazineNo = mag;
    }

    public void addTxtDataField(TxtDataField txtDataField) {
        if (txtDataField.getPacketNo() == 0) {
            int currentPageNo = txtDataField.getPageNumber();
            this.currentPage = this.pageList[currentPageNo];
            if (this.currentPage == null) {
                this.pageList[currentPageNo] = this.currentPage = new Page(this, currentPageNo);
            }
            this.currentPage.setHeader(txtDataField);
        } else if (txtDataField.getPacketNo() == 29) {
            int designationCode = txtDataField.getDesignationCode();
            this.pageEnhanceMentDataPackes[designationCode] = txtDataField;
        } else if (this.currentPage != null) {
            this.currentPage.addLine(txtDataField);
        }
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP s = new KVP("Magazine " + this.magazineNo);
        for (TxtDataField txtDataField : this.pageEnhanceMentDataPackes) {
            if (txtDataField == null) continue;
            s.add(txtDataField.getJTreeNode(modus));
        }
        for (TreeNode treeNode : this.pageList) {
            if (treeNode == null) continue;
            s.add(((Page)treeNode).getJTreeNode(modus));
        }
        return s;
    }

    public Page getPage(int n) {
        return this.pageList[n];
    }

    public int getMagazineNo() {
        return this.magazineNo;
    }

    public TxtDataField[] getPageEnhanceMentDataPackes() {
        return this.pageEnhanceMentDataPackes;
    }

    public TxtDataField getPageEnhanceMentDataPackes(int destinationCode) {
        return this.pageEnhanceMentDataPackes[destinationCode];
    }

    public TxtService getTxtService() {
        return this.txtServiceHandler;
    }
}

