/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.ebu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.Magazine;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.SubPage;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.TxtDataField;
import nl.digitalekabeltelevisie.util.Utils;

public class Page
implements TreeNode {
    private final Magazine magazineHandler;
    private final TreeMap<Integer, SubPage> subPages = new TreeMap();
    private final List<SubPage> subtitles = new ArrayList<SubPage>();
    private int pageNo;
    private SubPage currentSubPage;

    public Page(Magazine magazine, int currentPageNo) {
        this.magazineHandler = magazine;
        this.pageNo = currentPageNo;
    }

    public void addLine(TxtDataField txtDataField) {
        if (this.currentSubPage != null) {
            this.currentSubPage.addLine(txtDataField);
        }
    }

    public void setHeader(TxtDataField txtDataField) {
        int currentSubPageNo = txtDataField.getSubPage();
        if (txtDataField.getDataUnitId() == 2 || txtDataField.getDataUnitId() == 3 && !txtDataField.isSubtitle() || txtDataField.getDataUnitId() == 192) {
            this.currentSubPage = this.subPages.computeIfAbsent(currentSubPageNo, n -> new SubPage(this, (int)n));
            this.currentSubPage.setHeader(txtDataField);
        } else if (txtDataField.getDataUnitId() == 3 && txtDataField.isSubtitle()) {
            this.currentSubPage = new SubPage(this, currentSubPageNo);
            this.subtitles.add(this.currentSubPage);
            this.currentSubPage.setHeader(txtDataField);
        }
    }

    @Override
    public KVP getJTreeNode(int modus) {
        if (this.subPages.size() == 1 && this.subPages.get(0) != null) {
            return this.subPages.get(0).getJTreeNode(modus).setLabel(this.getPageNumberLabel());
        }
        if (!this.subPages.isEmpty()) {
            KVP kvp = new KVP(this.getPageNumberLabel());
            for (SubPage subPage : this.subPages.values()) {
                kvp.add(subPage.getJTreeNode(modus));
            }
            return kvp;
        }
        if (!this.subtitles.isEmpty()) {
            KVP treeNode = new KVP(this.getPageNumberLabel());
            for (SubPage subPage : this.subtitles) {
                TxtDataField[] linesList;
                if (subPage == null) continue;
                KVP t = subPage.getJTreeNode(modus);
                StringBuilder titel = new StringBuilder("subtitle ");
                for (TxtDataField line : linesList = Arrays.copyOfRange(subPage.getLinesList(), 1, subPage.getLinesList().length)) {
                    if (line == null) continue;
                    titel.append(line.getTeletextPlain().trim()).append(' ');
                }
                String subTitle = titel.toString().trim();
                t.setLabel(subTitle);
                treeNode.add(t);
            }
            return treeNode;
        }
        return new KVP(this.getPageNumberLabel());
    }

    private String getPageNumberLabel() {
        StringBuilder b = new StringBuilder("Page ");
        b.append(Utils.toHexString(this.pageNo, 2));
        if (this.pageNo == 190 && this.isMagazine1()) {
            b.append(" [Automatic Channel Installation (ACI)]");
        }
        if (this.pageNo == 223 && this.isMagazine1()) {
            b.append(" [Data broadcasting page carrying EPG data as defined in ETSI EN 300 707]");
        }
        if (this.pageNo == 231 && this.isMagazine1()) {
            b.append(" [Page carrying trigger messages as defined and coded in IEC/PAS 62297 Edition 1.0 (2002-01): Proposal for introducing a trigger mechanism into TV transmissions]");
        }
        if (this.pageNo >= 241 && this.pageNo <= 244 && this.isMagazine1()) {
            b.append(" [TOP data pages: Additional Information Table (AIT), Multi-Page Table (MPT) and Multi-Page Extension Table (MPT-EX)]");
        }
        if (this.isBasicTOPTable()) {
            b.append(" [Basic TOP Table (BTT)]");
        }
        if (this.pageNo == 253) {
            b.append(" [Magazine Inventory Page (MIP)]");
        }
        if (this.isMOTTable()) {
            b.append(" [Magazine Organization Table (MOT)]");
        }
        if (this.pageNo == 255) {
            b.append(" [time filling and terminator]");
        }
        return b.toString();
    }

    private boolean isMagazine1() {
        return this.currentSubPage.linesList[0] != null && this.currentSubPage.linesList[0].getMagazineNo() == 1;
    }

    public boolean isMOTTable() {
        return this.pageNo == 254;
    }

    private boolean isBasicTOPTable() {
        return this.pageNo == 240 && this.isMagazine1();
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public SubPage getMOTPage() {
        Page p = this.magazineHandler.getPage(254);
        if (p != null && !p.subPages.isEmpty()) {
            return p.subPages.values().iterator().next();
        }
        return null;
    }

    public int getMagazineNo() {
        return this.magazineHandler.getMagazineNo();
    }

    public Magazine getMagazine() {
        return this.magazineHandler;
    }

    public Magazine getMagazine(int m) {
        return this.magazineHandler.getTxtService().getMagazine(m);
    }

    public SubPage getSubPageByS1(int subPageS1) {
        for (Map.Entry<Integer, SubPage> entry : this.subPages.entrySet()) {
            if (subPageS1 != (entry.getKey() & 0xF)) continue;
            return entry.getValue();
        }
        return null;
    }

    public String toString() {
        return "Mag:" + this.getMagazineNo() + ", pageNo" + this.pageNo;
    }

    public SortedMap<Integer, SubPage> getSubPages() {
        return this.subPages;
    }
}

