/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.ebu;

import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.EBUDataField;
import nl.digitalekabeltelevisie.util.Utils;

public class VPSDataField
extends EBUDataField {
    public VPSDataField(byte[] data, int offset, int len, long pts) {
        super(data, offset, len, pts);
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP s = super.getJTreeNode(modus);
        s.add(new KVP("vps_data_block", this.data_block, this.offset + 3, 13));
        s.add(new KVP("not Relevant byte 3 to 4", this.getNotRelevant3_4()));
        s.add(new KVP("PCS/Audio", this.getPCSAudio(), VPSDataField.getPCSAudioString(this.getPCSAudio())));
        s.add(new KVP("Reserved for enhancement of VPS", this.getReservedEnhancement(), this.getReservedEnhancement() == 15 ? "Unenhanced VPS" : ""));
        s.add(new KVP("not Relevant byte 6 to 10", this.data_block, this.offset + 6, 5));
        if (this.getDay() == 0 && this.getMonth() == 15 && this.getMinute() == 63) {
            s.add(new KVP("Service Code", this.getHour(), VPSDataField.getServiceCodeString(this.getHour())));
        } else {
            s.add(new KVP("day", this.getDay()));
            s.add(new KVP("month", this.getMonth()));
            s.add(new KVP("hour", this.getHour()));
            s.add(new KVP("minute", this.getMinute()));
        }
        s.add(new KVP("country", this.getCountry()));
        s.add(new KVP("network", this.getNetwork()));
        s.add(new KVP("PTY", this.getPTY()));
        return s;
    }

    private static String getServiceCodeString(int b) {
        return switch (b) {
            case 31 -> "Timer-control Code (TC), indicating that the programme identification information is to be ignored";
            case 30 -> "Recording Inhibit/Terminate code (RI/T), indicating that the transmission has no label and is for example, not intended to be recorded";
            case 29 -> "Interruption code (INT), indicating a break in the programme, which will continue after a short interval";
            case 28 -> "Continuation code, indicating possibly an erroneous transmission state. No action required";
            default -> "reserved for future use";
        };
    }

    public int getCountry() {
        return Utils.getInt(this.data_block, this.offset + 13, 2, 960) >> 6;
    }

    public int getMinute() {
        return Utils.getInt(this.data_block, this.offset + 13, 1, 252) >> 2;
    }

    protected int getHour() {
        return Utils.getInt(this.data_block, this.offset + 12, 1, 31);
    }

    public int getMonth() {
        return Utils.getInt(this.data_block, this.offset + 11, 2, 480) >> 5;
    }

    public int getDay() {
        return Utils.getInt(this.data_block, this.offset + 11, 1, 62) >> 1;
    }

    public int getNotRelevant3_4() {
        return Utils.getInt(this.data_block, this.offset + 3, 2, 65535);
    }

    public int getReservedEnhancement() {
        return Utils.getInt(this.data_block, this.offset + 5, 1, 15);
    }

    public int getPCSAudio() {
        return Utils.getInt(this.data_block, this.offset + 5, 1, 192) >> 6;
    }

    public int getPTY() {
        return Utils.getInt(this.data_block, this.offset + 15, 1, 255);
    }

    public static String getPCSAudioString(int aud) {
        return switch (aud) {
            case 0 -> "don't know";
            case 1 -> "mono";
            case 2 -> "Stereo";
            case 3 -> "dual sound";
            default -> "Illegal Value";
        };
    }

    public int getNetwork() {
        return Utils.getInt(this.data_block, this.offset + 11, 1, 192) + Utils.getInt(this.data_block, this.offset + 14, 1, 63);
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.dataUnitId;
        result = 31 * result + this.dataUnitLength;
        result = 31 * result + this.field_parity;
        result = 31 * result + this.line_offset;
        result = 31 * result + this.offset;
        result = 31 * result + this.reserved_future_use;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VPSDataField other = (VPSDataField)obj;
        if (this.dataUnitId != other.dataUnitId) {
            return false;
        }
        if (this.dataUnitLength != other.dataUnitLength) {
            return false;
        }
        if (this.field_parity != other.field_parity) {
            return false;
        }
        if (this.getCountry() != other.getCountry()) {
            return false;
        }
        if (this.getDay() != other.getDay()) {
            return false;
        }
        if (this.getHour() != other.getHour()) {
            return false;
        }
        if (this.getMinute() != other.getMinute()) {
            return false;
        }
        if (this.getMonth() != other.getMonth()) {
            return false;
        }
        if (this.getNetwork() != other.getNetwork()) {
            return false;
        }
        if (this.getPCSAudio() != other.getPCSAudio()) {
            return false;
        }
        if (this.getPTY() != other.getPTY()) {
            return false;
        }
        if (this.getReservedEnhancement() != other.getReservedEnhancement()) {
            return false;
        }
        if (this.line_offset != other.line_offset) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        return this.reserved_future_use == other.reserved_future_use;
    }
}

