/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.temi;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import nl.digitalekabeltelevisie.data.mpeg.PesPacketData;
import nl.digitalekabeltelevisie.data.mpeg.TemiTimeStamp;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.afdescriptors.TimelineDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.pes.GeneralPesHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.temi.TEMIPesDataField;

public class TEMIPesHandler
extends GeneralPesHandler {
    private static final Logger logger = Logger.getLogger(TEMIPesHandler.class.getName());

    @Override
    protected void processPesDataBytes(PesPacketData pesData) {
        TEMIPesDataField temiPesDataField = new TEMIPesDataField(pesData);
        this.pesPackets.add(temiPesDataField);
        if (temiPesDataField.hasPTS()) {
            long pts = temiPesDataField.getPts();
            List<TimelineDescriptor> timelineDescriptors = Descriptor.findGenericDescriptorsInList(temiPesDataField.getAfDescriptors(), TimelineDescriptor.class);
            int packetNo = temiPesDataField.getStartPacketNo();
            Map<Integer, ArrayList<TemiTimeStamp>> temiList = this.getPID().getTemiMap();
            for (TimelineDescriptor timelineDescriptor : timelineDescriptors) {
                if (timelineDescriptor.getHas_timestamp() != 1 && timelineDescriptor.getHas_timestamp() != 2) continue;
                ArrayList tl = temiList.computeIfAbsent(timelineDescriptor.getTimeline_id(), k -> new ArrayList());
                tl.add(new TemiTimeStamp(packetNo, pts, timelineDescriptor.getMedia_timestamp(), timelineDescriptor.getTimescale(), timelineDescriptor.getDiscontinuity(), timelineDescriptor.getTimeline_id(), timelineDescriptor.getPaused()));
            }
        } else {
            logger.warning("TEMIPesDataField packetNo: " + temiPesDataField.getStartPacketNo() + " has no PTS (required for TEMI)");
        }
    }

    @Override
    public String getMenuDescription() {
        return "Parse TEMI";
    }
}

