/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.VideoMPEG2Section;
import nl.digitalekabeltelevisie.util.Utils;

public class GroupOfPicturesHeader
extends VideoMPEG2Section {
    private final int time_code;
    private final int closed_gop;
    private final int broken_link;

    public GroupOfPicturesHeader(byte[] data, int offset) {
        super(data, offset);
        this.time_code = Utils.getInt(data, offset + 1, 4, -128) >> 7;
        this.closed_gop = Utils.getInt(data, offset + 4, 1, 64) >> 6;
        this.broken_link = Utils.getInt(data, offset + 4, 1, 32) >> 5;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("time_code", this.time_code, GroupOfPicturesHeader.getTimeCodeString(this.time_code))));
        t.add(new DefaultMutableTreeNode(new KVP("closed_gop", this.closed_gop, this.closed_gop == 1 ? "following B-pictures have been encoded using only backward prediction or intra coding" : null)));
        t.add(new DefaultMutableTreeNode(new KVP("broken_link", this.broken_link, this.broken_link == 1 ? "consecutive B-Pictures (if any) immediately following the first coded I-frame following the group of picture header may not be correctly decoded because the reference frame which is used for prediction is not available" : null)));
        return t;
    }

    public static String getTimeCodeString(int tc) {
        StringBuilder b = new StringBuilder("drop_frame_flag: ");
        int drop_frame_flag = (tc & 0x1000000) >> 24;
        b.append(drop_frame_flag).append(", time: ");
        int hours = (tc & 0xF80000) >> 19;
        b.append(hours).append(":");
        int minutes = (tc & 0x7E000) >> 13;
        b.append(minutes).append(":");
        int seconds = (tc & 0xFC0) >> 6;
        b.append(seconds).append(":");
        int pictures = tc & 0x3F;
        b.append(pictures);
        return b.toString();
    }

    public int getBroken_link() {
        return this.broken_link;
    }

    public int getClosed_gop() {
        return this.closed_gop;
    }

    public int getTime_code() {
        return this.time_code;
    }
}

