/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.VideoMPEG2Section;
import nl.digitalekabeltelevisie.util.Utils;

public class SequenceHeader
extends VideoMPEG2Section {
    private final int horizontal_size_value;
    private final int vertical_size_value;
    private final int aspect_ratio_information;
    private final int frame_rate_code;
    private final int bit_rate_value;
    private final int marker_bit;
    private final int vbv_buffer_size_value;
    private final int constrained_parameters_flag;
    private final int load_intra_quantiser_matrix;
    private final int[] intra_quantiser_matrix = new int[64];
    private final int load_non_intra_quantiser_matrix;
    private final int[] non_intra_quantiser_matrix = new int[64];

    public SequenceHeader(byte[] data, int offset) {
        super(data, offset);
        int i;
        this.horizontal_size_value = this.bs.readBits(12);
        this.vertical_size_value = this.bs.readBits(12);
        this.aspect_ratio_information = this.bs.readBits(4);
        this.frame_rate_code = this.bs.readBits(4);
        this.bit_rate_value = this.bs.readBits(18);
        this.marker_bit = this.bs.readBits(1);
        this.vbv_buffer_size_value = this.bs.readBits(10);
        this.constrained_parameters_flag = this.bs.readBits(1);
        this.load_intra_quantiser_matrix = this.bs.readBits(1);
        if (this.load_intra_quantiser_matrix == 1) {
            for (i = 0; i < this.intra_quantiser_matrix.length; ++i) {
                this.intra_quantiser_matrix[i] = this.bs.readBits(8);
            }
        }
        this.load_non_intra_quantiser_matrix = this.bs.readBits(1);
        if (this.load_non_intra_quantiser_matrix == 1) {
            for (i = 0; i < this.non_intra_quantiser_matrix.length; ++i) {
                this.non_intra_quantiser_matrix[i] = this.bs.readBits(8);
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        int i;
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("horizontal_size_value", this.horizontal_size_value, null)));
        t.add(new DefaultMutableTreeNode(new KVP("vertical_size_value", this.vertical_size_value, null)));
        t.add(new DefaultMutableTreeNode(new KVP("aspect_ratio_information", this.aspect_ratio_information, Utils.getAspectRatioInformationString(this.aspect_ratio_information))));
        t.add(new DefaultMutableTreeNode(new KVP("frame_rate_code", this.frame_rate_code, SequenceHeader.getFrameRateCodeString(this.frame_rate_code))));
        t.add(new DefaultMutableTreeNode(new KVP("bit_rate_value", this.bit_rate_value, this.bit_rate_value * 400 + " bit/s")));
        t.add(new DefaultMutableTreeNode(new KVP("marker_bit", this.marker_bit, "should be 1")));
        t.add(new DefaultMutableTreeNode(new KVP("vbv_buffer_size_value", this.vbv_buffer_size_value, null)));
        t.add(new DefaultMutableTreeNode(new KVP("constrained_parameters_flag", this.constrained_parameters_flag, "has no meaning in the ISO13818-2 specification and shall have the value 0")));
        t.add(new DefaultMutableTreeNode(new KVP("load_intra_quantiser_matrix", this.load_intra_quantiser_matrix, null)));
        if (this.load_intra_quantiser_matrix == 1) {
            DefaultMutableTreeNode intra_quantiser_matrixNode = new DefaultMutableTreeNode(new KVP("intra_quantiser_matrix"));
            for (i = 0; i < this.intra_quantiser_matrix.length; ++i) {
                intra_quantiser_matrixNode.add(new DefaultMutableTreeNode(new KVP("intra_quantiser_matrix[" + i + "]", this.intra_quantiser_matrix[i], null)));
            }
            t.add(intra_quantiser_matrixNode);
        }
        t.add(new DefaultMutableTreeNode(new KVP("load_non_intra_quantiser_matrix", this.load_non_intra_quantiser_matrix, null)));
        if (this.load_non_intra_quantiser_matrix == 1) {
            DefaultMutableTreeNode non_intra_quantiser_matrixNode = new DefaultMutableTreeNode(new KVP("non_intra_quantiser_matrix"));
            for (i = 0; i < this.non_intra_quantiser_matrix.length; ++i) {
                non_intra_quantiser_matrixNode.add(new DefaultMutableTreeNode(new KVP("non_intra_quantiser_matrix[" + i + "]", this.non_intra_quantiser_matrix[i], null)));
            }
            t.add(non_intra_quantiser_matrixNode);
        }
        return t;
    }

    public static String getFrameRateCodeString(int s) {
        switch (s) {
            case 0: {
                return "forbidden";
            }
            case 1: {
                return "23,976";
            }
            case 2: {
                return "24";
            }
            case 3: {
                return "25";
            }
            case 4: {
                return "29,97";
            }
            case 5: {
                return "30";
            }
            case 6: {
                return "50";
            }
            case 7: {
                return "59,94";
            }
            case 8: {
                return "60";
            }
        }
        return "reserved";
    }

    public int getAspect_ratio_information() {
        return this.aspect_ratio_information;
    }

    public int getBit_rate_value() {
        return this.bit_rate_value;
    }

    public int getFrame_rate_code() {
        return this.frame_rate_code;
    }

    public int getHorizontal_size_value() {
        return this.horizontal_size_value;
    }

    public int getVertical_size_value() {
        return this.vertical_size_value;
    }
}

