/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video;

import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.ChartLabel;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PesPacketData;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.PictureHeader;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.UserData;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.VideoMPEG2Section;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.VideoPESDataField;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.common.AuxiliaryData;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.common.VideoHandler;
import nl.digitalekabeltelevisie.gui.ImageSource;
import nl.digitalekabeltelevisie.util.Utils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DefaultKeyedValues2DDataset;

public class Video138182Handler
extends VideoHandler
implements ImageSource {
    private static final Logger logger = Logger.getLogger(Video138182Handler.class.getName());

    @Override
    protected void processPesDataBytes(PesPacketData pesData) {
        this.pesPackets.add(new VideoPESDataField(pesData));
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("13818-2 PES Data").addImageSource(this, "Frames"));
        Utils.addListJTree(s, this.pesPackets, modus, "PES Packets");
        this.addCCDataToTree(modus, s);
        return s;
    }

    public BufferedImage getImage(int height, int width, long pts) {
        VideoPESDataField resultPES = null;
        long diff = Long.MAX_VALUE;
        for (PesPacketData pesPacket : this.pesPackets) {
            VideoPESDataField video = (VideoPESDataField)pesPacket;
            if (!video.hasIFrame() || Math.abs(video.getPesHeader().getPts() - pts) >= diff) continue;
            resultPES = video;
            diff = Math.abs(video.getPesHeader().getPts() - pts);
        }
        if (resultPES != null) {
            return resultPES.getImage(width, height);
        }
        return null;
    }

    public MPEG2SectionIterator getSectionIterator() {
        return new MPEG2SectionIterator(this);
    }

    @Override
    public BufferedImage getImage() {
        ArrayList<ChartLabel> labels = new ArrayList<ChartLabel>();
        ChartLabel label = null;
        ArrayList<Integer> frameSize = new ArrayList<Integer>();
        int length = 0;
        int count = 0;
        MPEG2SectionIterator iter = this.getSectionIterator();
        VideoMPEG2Section section = iter.next();
        while (section != null) {
            while (section != null && section.startCode == 0) {
                label = new ChartLabel(((PictureHeader)section).getPictureCodingTypeShortString(), (short)count);
                length = section.getLength();
                section = iter.next();
                while (section != null && (section.startCode == 178 || section.startCode == 181)) {
                    length += section.getLength();
                    section = iter.next();
                }
                while (section != null && section.startCode >= 1 && section.startCode <= 175) {
                    length += section.getLength();
                    section = iter.next();
                }
                labels.add(label);
                frameSize.add(length);
                ++count;
                length = 0;
                while (section != null && section.startCode != 0) {
                    section = iter.next();
                }
            }
            section = iter.next();
        }
        Iterator frameSizeIter = frameSize.iterator();
        DefaultKeyedValues2DDataset dataset = new DefaultKeyedValues2DDataset();
        DifferenceBarRenderer renderer = new DifferenceBarRenderer();
        renderer.setShadowVisible(false);
        renderer.setDrawBarOutline(false);
        renderer.setItemMargin(0.0);
        int displayCount = 0;
        for (ChartLabel l : labels) {
            if (!frameSizeIter.hasNext()) continue;
            dataset.setValue((Number)frameSizeIter.next(), (Comparable)((Object)""), (Comparable)l);
            ++displayCount;
        }
        CategoryAxis categoryAxis = new CategoryAxis("time");
        categoryAxis.setCategoryMargin(0.0);
        categoryAxis.setUpperMargin(0.0);
        categoryAxis.setLowerMargin(0.0);
        NumberAxis valueAxis = new NumberAxis("frame size (bytes)");
        CategoryPlot plot = new CategoryPlot((CategoryDataset)dataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        String title = String.valueOf(this.getPID().getLabelMaker()) + " (Transmission Order)";
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, false);
        return chart.createBufferedImage(displayCount * 18 + 100, 640);
    }

    @Override
    protected void collectCEA708Data() {
        for (PesPacketData pesPacket : this.pesPackets) {
            VideoPESDataField videoPesPacket = (VideoPESDataField)pesPacket;
            if (videoPesPacket.hasPTS()) {
                long pts = videoPesPacket.getPts();
                for (VideoMPEG2Section section : videoPesPacket.getSections()) {
                    if (!(section instanceof UserData)) continue;
                    UserData userData = (UserData)section;
                    AuxiliaryData auxData = userData.getAuxData();
                    this.find708AuxData(pts, auxData);
                }
                continue;
            }
            logger.warning("no pts for PES Field, ignoring possible cc_data");
        }
    }

    private class MPEG2SectionIterator {
        Iterator<PesPacketData> pesIterator = null;
        VideoMPEG2Section nextSection = null;
        private Iterator<VideoMPEG2Section> sectionIter;

        public MPEG2SectionIterator(Video138182Handler video138182Handler) {
            this.pesIterator = video138182Handler.pesPackets.iterator();
            this.sectionIter = this.getNextSectionIter();
            if (this.sectionIter != null) {
                this.nextSection = this.sectionIter.next();
            }
        }

        private Iterator<VideoMPEG2Section> getNextSectionIter() {
            VideoPESDataField pesPacket;
            Iterator<VideoMPEG2Section> result = null;
            while (((result = (pesPacket = (VideoPESDataField)this.pesIterator.next()).getSections().iterator()) == null || !result.hasNext()) && this.pesIterator.hasNext()) {
            }
            return result;
        }

        public VideoMPEG2Section next() {
            VideoMPEG2Section result = this.nextSection;
            if (this.sectionIter != null && this.sectionIter.hasNext()) {
                this.nextSection = this.sectionIter.next();
            } else if (this.pesIterator.hasNext()) {
                this.sectionIter = this.getNextSectionIter();
                this.nextSection = this.sectionIter.hasNext() ? this.sectionIter.next() : null;
            } else {
                this.nextSection = null;
            }
            return result;
        }
    }

    public class DifferenceBarRenderer
    extends BarRenderer {
        public Paint getItemPaint(int x_row, int x_col) {
            CategoryDataset l_jfcDataset = this.getPlot().getDataset();
            ChartLabel l_colKey = (ChartLabel)l_jfcDataset.getColumnKey(x_col);
            if ("I".equals(l_colKey.getLabel())) {
                return Color.RED;
            }
            if ("P".equals(l_colKey.getLabel())) {
                return Color.BLUE;
            }
            if ("B".equals(l_colKey.getLabel())) {
                return Color.GREEN;
            }
            return Color.YELLOW;
        }
    }
}

