/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.PictureHeader;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.VideoPESDataField;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.Utils;

public class VideoMPEG2Section
implements TreeNode {
    protected int startCode;
    private int offset;
    private byte[] data;
    protected BitSource bs;

    public VideoMPEG2Section(byte[] data, int offset) {
        this.bs = new BitSource(data, offset);
        this.data = data;
        this.offset = offset;
        this.startCode = this.bs.readBits(8);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP(VideoPESDataField.getSectionTypeString(this.startCode)));
        t.add(new DefaultMutableTreeNode(new KVP("length", this.getLength(), null)));
        t.add(new DefaultMutableTreeNode(new KVP("start_code", this.startCode, VideoPESDataField.getStartCodeString(this.startCode))));
        t.add(new DefaultMutableTreeNode(new KVP("data", this.data, this.offset, this.getLength(), null)));
        return t;
    }

    public int getStartCode() {
        return this.startCode;
    }

    protected int getLength() {
        int i = Utils.indexOf(this.data, new byte[]{0, 0, 1}, this.offset);
        if (i >= 0) {
            return i - this.offset;
        }
        i = Utils.indexOf(this.data, new byte[]{0, 0, 0}, this.offset);
        if (i >= 0) {
            return i - this.offset;
        }
        return this.data.length - this.offset;
    }

    public String toString() {
        if (this.startCode == 0) {
            return VideoPESDataField.getSectionTypeString(this.startCode) + " (" + ((PictureHeader)this).getPictureCodingTypeShortString() + ")";
        }
        return VideoPESDataField.getSectionTypeString(this.startCode);
    }
}

