/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video.common;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.util.Utils;

public class BarData
implements TreeNode {
    int top_bar_flag;
    int bottom_bar_flag;
    int left_bar_flag;
    int right_bar_flag;
    int reserved;
    int marker_bits_top;
    int line_number_end_of_top_bar;
    int marker_bits_bottom;
    int line_number_start_of_bottom_bar;
    int marker_bits_left;
    int pixel_number_end_of_left_bar;
    int marker_bits_right;
    int pixel_number_start_of_right_bar;

    public BarData(byte[] data, int offset, int len) {
        this.top_bar_flag = Utils.getInt(data, offset, 1, 128) >> 7;
        this.bottom_bar_flag = Utils.getInt(data, offset, 1, 64) >> 6;
        this.left_bar_flag = Utils.getInt(data, offset, 1, 32) >> 5;
        this.right_bar_flag = Utils.getInt(data, offset, 1, 16) >> 4;
        this.reserved = Utils.getInt(data, offset, 1, 15);
        int o = offset + 1;
        if (this.top_bar_flag == 1) {
            this.marker_bits_top = Utils.getInt(data, o, 1, 192) >> 6;
            this.line_number_end_of_top_bar = Utils.getInt(data, o, 2, 16383);
            o += 2;
        }
        if (this.bottom_bar_flag == 1) {
            this.marker_bits_bottom = Utils.getInt(data, o, 1, 192) >> 6;
            this.line_number_start_of_bottom_bar = Utils.getInt(data, o, 2, 16383);
            o += 2;
        }
        if (this.left_bar_flag == 1) {
            this.marker_bits_left = Utils.getInt(data, o, 1, 192) >> 6;
            this.pixel_number_end_of_left_bar = Utils.getInt(data, o, 2, 16383);
            o += 2;
        }
        if (this.right_bar_flag == 1) {
            this.marker_bits_right = Utils.getInt(data, o, 1, 192) >> 6;
            this.pixel_number_start_of_right_bar = Utils.getInt(data, o, 2, 16383);
            o += 2;
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("bar_data()"));
        t.add(new DefaultMutableTreeNode(new KVP("top_bar_flag", this.top_bar_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("bottom_bar_flag", this.bottom_bar_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("left_bar_flag", this.left_bar_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("right_bar_flag", this.right_bar_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
        if (this.top_bar_flag == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("marker_bits", this.marker_bits_top, null)));
            t.add(new DefaultMutableTreeNode(new KVP("line_number_end_of_top_bar", this.line_number_end_of_top_bar, null)));
        }
        if (this.bottom_bar_flag == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("marker_bits", this.marker_bits_bottom, null)));
            t.add(new DefaultMutableTreeNode(new KVP("line_number_start_of_bottom_bar", this.line_number_start_of_bottom_bar, null)));
        }
        if (this.left_bar_flag == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("marker_bits", this.marker_bits_left, null)));
            t.add(new DefaultMutableTreeNode(new KVP("pixel_number_end_of_left_bar", this.pixel_number_end_of_left_bar, null)));
        }
        if (this.right_bar_flag == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("marker_bits", this.marker_bits_right, null)));
            t.add(new DefaultMutableTreeNode(new KVP("pixel_number_start_of_right_bar", this.pixel_number_start_of_right_bar, null)));
        }
        return t;
    }
}

