/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video.common;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.common.Construct;
import nl.digitalekabeltelevisie.util.Utils;

public class CCData
implements TreeNode {
    private final int reserved;
    private final int process_cc_data_flag;
    private final int zero_bit;
    private final int cc_count;
    private final int reserved2;
    private final List<Construct> constructs = new ArrayList<Construct>();
    private final int marker_bits;

    public CCData(byte[] data, int offset, int len) {
        this.reserved = Utils.getInt(data, offset, 1, 128) >> 7;
        this.process_cc_data_flag = Utils.getInt(data, offset, 1, 64) >> 6;
        this.zero_bit = Utils.getInt(data, offset, 1, 32) >> 5;
        this.cc_count = Utils.getInt(data, offset, 1, 31);
        this.reserved2 = Utils.getInt(data, offset + 1, 1, 255);
        int localOffset = offset + 2;
        for (int i = 0; i < this.cc_count; ++i) {
            Construct construct = new Construct(data, localOffset);
            this.constructs.add(construct);
            localOffset += 3;
        }
        this.marker_bits = Utils.getInt(data, localOffset, 1, 255);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("cc_data()"));
        t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
        t.add(new DefaultMutableTreeNode(new KVP("process_cc_data_flag", this.process_cc_data_flag, this.process_cc_data_flag == 1 ? "cc_data shall be parsed and its meaning processed" : "cc_data shall be discarded")));
        t.add(new DefaultMutableTreeNode(new KVP("zero_bit", this.zero_bit, null)));
        t.add(new DefaultMutableTreeNode(new KVP("cc_count", this.cc_count, null)));
        t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved2, null)));
        Utils.addListJTree(t, this.constructs, modus, "CC Constructs");
        t.add(new DefaultMutableTreeNode(new KVP("marker_bits", this.marker_bits, null)));
        return t;
    }

    public int getProcess_cc_data_flag() {
        return this.process_cc_data_flag;
    }

    public int getCc_count() {
        return this.cc_count;
    }

    public List<Construct> getConstructs() {
        return this.constructs;
    }

    public int getMarker_bits() {
        return this.marker_bits;
    }
}

