/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.common.AuxiliaryData;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.common.CCData;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.common.Construct;
import nl.digitalekabeltelevisie.gui.HTMLSource;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class Cea608 {
    protected Map<Integer, Map<Long, List<Construct>>> allCcData = new TreeMap<Integer, Map<Long, List<Construct>>>();
    protected Map<Integer, Map<Integer, List<byte[]>>> xdsData = new TreeMap<Integer, Map<Integer, List<byte[]>>>();
    static final int[] BASIC_CHARACTER_SET = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 225, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 233, 93, 237, 243, 250, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 231, 247, 209, 241, 9632};
    static final int[] SPECIAL_CHARACTER_SET = new int[]{174, 176, 189, 191, 8482, 162, 163, 9834, 224, 32, 232, 226, 234, 238, 244, 251};
    LookUpList mpa_rating_lookup = new LookUpList.Builder().add(0, "N/A").add(1, "G").add(2, "PG").add(3, "PG-13").add(4, "R").add(5, "NC-17").add(6, "X").add(7, "Not Rated").build();
    LookUpList ustv_rating_lookup = new LookUpList.Builder().add(0, "None").add(1, "TV-Y (All Children)").add(2, "TV-Y7 (Directed to Older Children)").add(3, "TV-G (General Audience)").add(4, "TV-PG (Parental Guidance Suggested)").add(5, "TV-14 (Parents Strongly Cautioned)").add(6, "TV-MA (Mature Audience Only)").add(7, "None").build();
    LookUpList cgms_lookup = new LookUpList.Builder().add(0, "Copying is permitted without restriction").add(1, "Condition not to be used").add(2, "One generation of copies may be made").add(3, "No copying is permitted").build();
    LookUpList aps_lookup = new LookUpList.Builder().add(0, "No APS").add(1, "PSP On; Split Burst Off").add(2, "PSP On; 2 line Split Burst On").add(3, "PSP On; 4 line Split Burst On").build();
    LookUpList program_type_lookup = new LookUpList.Builder().add(32, "Education").add(33, "Entertainment").add(34, "Movie").add(35, "News").add(36, "Religious").add(37, "Sports").add(38, "OTHER").add(39, "Action").add(40, "Advertisement").add(41, "Animated").add(42, "Anthology").add(43, "Automobile").add(44, "Awards").add(45, "Baseball").add(46, "Basketball").add(47, "Bulletin").add(48, "Business").add(49, "Classical").add(50, "College").add(51, "Combat").add(52, "Comedy").add(53, "Commentary").add(54, "Concert").add(55, "Consumer").add(56, "Contemporary").add(57, "Crime").add(58, "Dance").add(59, "Documentary").add(60, "Drama").add(61, "Elementary").add(62, "Erotica").add(63, "Exercise").add(64, "Fantasy").add(65, "Farm").add(66, "Fashion").add(67, "Fiction").add(68, "Food").add(69, "Football").add(70, "Foreign").add(71, "Fund Raiser").add(72, "Game/Quiz").add(73, "Garden").add(74, "Golf").add(75, "Government").add(76, "Health").add(77, "High School").add(78, "History").add(79, "Hobby").add(80, "Hockey").add(81, "Home").add(82, "Horror").add(83, "Information").add(84, "Instruction").add(85, "International").add(86, "Interview").add(87, "Language").add(88, "Legal").add(89, "Live").add(90, "Local").add(91, "Math").add(92, "Medical").add(93, "Meeting").add(94, "Military").add(95, "Miniseries").add(96, "Music").add(97, "Mystery").add(98, "National").add(99, "Nature").add(100, "Police").add(101, "Politics").add(102, "Premier").add(103, "Prerecorded").add(104, "Product").add(105, "Professional").add(106, "Public").add(107, "Racing").add(108, "Reading").add(109, "Repair").add(110, "Repeat").add(111, "Review").add(112, "Romance").add(113, "Science").add(114, "Series").add(115, "Service").add(116, "Shopping").add(117, "Soap Opera").add(118, "Special").add(119, "Suspense").add(120, "Talk").add(121, "Technical").add(122, "Tennis").add(123, "Travel").add(124, "Variety").add(125, "Video").add(126, "Weather").add(127, "Western").build();
    Function<byte[], String> cea608StringFormat = input -> {
        StringBuilder builder = new StringBuilder();
        for (byte b : input) {
            if (b < 32) continue;
            builder.append((char)BASIC_CHARACTER_SET[b - 32]);
        }
        return builder.toString();
    };
    Function<byte[], String> cea608ProgramTypeFormat = input -> {
        StringBuilder builder = new StringBuilder();
        for (byte b : input) {
            builder.append(this.program_type_lookup.get(b, "??")).append(' ');
        }
        return builder.toString().trim();
    };
    Function<byte[], String> cea608ProgramIdentificationNumberFormat = input -> {
        if (((byte[])input).length != 4) {
            return "invalid length!";
        }
        int minutes = input[0] & 0x3F;
        int hours = input[1] & 0x1F;
        int date = input[2] & 0x1F;
        int month = input[3] & 0xF;
        int tapeDelay = (input[3] & 0x10) >>> 4;
        return String.format("Month: %1$d, Day: %2$d, Hours: %3$d, Minutes: %4$d, Tape delay: %5$d (UTC)", month, date, hours, minutes, tapeDelay);
    };
    Function<byte[], String> cea608LengthTimeInShowFormat = input -> {
        if (((byte[])input).length != 2 && ((byte[])input).length != 4 && ((byte[])input).length != 6) {
            return "invalid length!";
        }
        int minutesLength = input[0] & 0x3F;
        int hoursLength = input[1] & 0x3F;
        Object res = String.format("Length Hours: %1$d, Minutes: %2$d", hoursLength, minutesLength);
        if (((byte[])input).length > 2) {
            int minutesElapsed = input[2] & 0x3F;
            int hoursElapsed = input[3] & 0x3F;
            res = (String)res + String.format(", Elapsed Hours: %1$d, Elapsed Minutes: %2$d", hoursElapsed, minutesElapsed);
            if (((byte[])input).length > 4) {
                int secondsElapsed = input[4] & 0x3F;
                res = (String)res + String.format(", Elapsed Seconds: %1$d", secondsElapsed);
            }
        }
        return res;
    };
    Function<byte[], String> cea608ContentAdvisoryFormat = input -> {
        if (((byte[])input).length != 2) {
            return "invalid length!";
        }
        Object res = "System: ";
        int a1 = (input[0] & 0x10) >>> 4;
        int a0 = (input[0] & 8) >>> 3;
        if (a1 == 0 && a0 == 0) {
            res = (String)res + "MPA, ";
            int ratingR = input[0] & 7;
            res = (String)res + this.mpa_rating_lookup.get(ratingR, "unknown value");
            return res;
        }
        if (a1 == 0 && a0 == 1) {
            res = (String)res + "U.S. TV Parental Guidelines, ";
            int ratingG = input[1] & 7;
            res = (String)res + this.ustv_rating_lookup.get(ratingG, "unknown value");
            if ((input[1] & 0x20) != 0) {
                res = ratingG == 2 ? (String)res + ", FV (Fantasy Violence)" : (String)res + ", V (Violence) ";
            }
            if ((input[1] & 0x10) != 0) {
                res = (String)res + ", S (Sexual Situations)";
            }
            if ((input[1] & 8) != 0) {
                res = (String)res + ", L (Adult Language)";
            }
            if ((input[0] & 0x20) != 0) {
                res = (String)res + ", D (Sexually Suggestive Dialog)";
            }
            return res;
        }
        return "? not implemented";
    };
    Function<byte[], String> cea608CopyGenerationManagementSystemFormat = input -> {
        if (((byte[])input).length != 2) {
            return "invalid length!";
        }
        int cgmsa = (input[0] & 0x18) >>> 3;
        Object res = this.cgms_lookup.get(cgmsa, "unknown value");
        if (cgmsa == 3) {
            int aps = (input[0] & 6) >>> 1;
            res = (String)res + ", " + this.aps_lookup.get(aps, "unknown apsvalue");
            int asb = input[0] & 1;
            res = (String)res + ", Analog Source Bit: " + asb;
        }
        return res;
    };

    Function<byte[], String> getFormatter(int class1, int type) {
        if (class1 == 0) {
            if (type == 1) {
                return this.cea608ProgramIdentificationNumberFormat;
            }
            if (type == 2) {
                return this.cea608LengthTimeInShowFormat;
            }
            if (type == 4) {
                return this.cea608ProgramTypeFormat;
            }
            if (type == 5) {
                return this.cea608ContentAdvisoryFormat;
            }
            if (type == 8) {
                return this.cea608CopyGenerationManagementSystemFormat;
            }
        }
        return this.cea608StringFormat;
    }

    protected void addCCDataToTree(int modus, DefaultMutableTreeNode s) {
        if (!this.allCcData.isEmpty()) {
            this.addRawCCDataToTree(modus, s);
        }
        if (!this.xdsData.isEmpty()) {
            this.addXDSToTree(s);
        }
    }

    void addXDSToTree(DefaultMutableTreeNode s) {
        DefaultMutableTreeNode xdsTree = new DefaultMutableTreeNode(new KVP("XDS"));
        s.add(xdsTree);
        for (Map.Entry<Integer, Map<Integer, List<byte[]>>> xdsEntry : this.xdsData.entrySet()) {
            Integer classValue = xdsEntry.getKey();
            DefaultMutableTreeNode classNode = new DefaultMutableTreeNode(new KVP("class", classValue, Construct.xds_class.get(classValue, "unknown")));
            xdsTree.add(classNode);
            for (Map.Entry<Integer, List<byte[]>> typeList : xdsEntry.getValue().entrySet()) {
                Integer typeValue = typeList.getKey();
                DefaultMutableTreeNode typeNode = new DefaultMutableTreeNode(new KVP("type", typeValue, Construct.getTypeDescription(classValue, typeValue)));
                classNode.add(typeNode);
                for (byte[] value : typeList.getValue()) {
                    DefaultMutableTreeNode valueNode = new DefaultMutableTreeNode(new KVP("value", value, this.getFormatter(classValue, typeValue).apply(value)));
                    typeNode.add(valueNode);
                }
            }
        }
    }

    void addRawCCDataToTree(int modus, DefaultMutableTreeNode s) {
        DefaultMutableTreeNode ccDataTree = new DefaultMutableTreeNode(new KVP("cc_data"));
        s.add(ccDataTree);
        for (Map.Entry<Integer, Map<Long, List<Construct>>> typeEntry : this.allCcData.entrySet()) {
            Map<Long, List<Construct>> typeEntryValue = typeEntry.getValue();
            KVP typeNodeKvp = new KVP("type", typeEntry.getKey(), Construct.cc_type_list.get(typeEntry.getKey()));
            typeNodeKvp.addHTMLSource(() -> typeEntryValue.values().stream().flatMap(Collection::stream).map(HTMLSource::getHTML).collect(Collectors.joining("<br>")), "cc_data");
            DefaultMutableTreeNode typeNode = new DefaultMutableTreeNode(typeNodeKvp);
            ccDataTree.add(typeNode);
            for (Map.Entry<Long, List<Construct>> ptsEntry : typeEntryValue.entrySet()) {
                List<Construct> constructList = ptsEntry.getValue();
                KVP kvp = new KVP("pts", ptsEntry.getKey(), Utils.printTimebase90kHz(ptsEntry.getKey()));
                kvp.addHTMLSource(() -> constructList.stream().map(HTMLSource::getHTML).collect(Collectors.joining("<br>")), "pts");
                DefaultMutableTreeNode ptsNode = new DefaultMutableTreeNode(kvp);
                typeNode.add(ptsNode);
                for (Construct construct : constructList) {
                    ptsNode.add(construct.getJTreeNode(modus));
                }
            }
        }
    }

    void handleXDSData() {
        Map<Long, List<Construct>> field2Data = this.allCcData.get(1);
        ArrayList<Byte> payLoad = null;
        int currentClass = -1;
        int currentType = -1;
        if (field2Data == null || field2Data.isEmpty()) {
            return;
        }
        String state = "initial";
        for (List<Construct> fieldList : field2Data.values()) {
            for (Construct field : fieldList) {
                int cc1WithoutParity = field.getCC1WithoutParity();
                int cc2WithoutParity = field.getCC2WithoutParity();
                if (field.isXDSControl()) {
                    if (cc1WithoutParity == 15) {
                        if (currentClass < 0 || currentType < 0) continue;
                        Map classXDS = this.xdsData.computeIfAbsent(currentClass, k -> new TreeMap());
                        List typeXDSList = classXDS.computeIfAbsent(currentType, k -> new ArrayList());
                        byte[] pay = Utils.bytesListToArray(payLoad);
                        if (typeXDSList.isEmpty()) {
                            typeXDSList.add(pay);
                        } else if (!Utils.listContainsByteArray(typeXDSList, pay)) {
                            typeXDSList.add(pay);
                        }
                        currentClass = -1;
                        currentType = -1;
                        payLoad = null;
                        continue;
                    }
                    int xdsClassRaw = cc1WithoutParity - 1;
                    int startContinu = xdsClassRaw % 2;
                    if (startContinu == 0) {
                        currentClass = xdsClassRaw / 2;
                        payLoad = new ArrayList<Byte>();
                        currentType = cc2WithoutParity;
                        state = "started";
                        continue;
                    }
                    if (!"interrupted".equals(state)) continue;
                    state = "started";
                    continue;
                }
                if (!field.isControl()) {
                    if (!"started".equals(state) || currentClass < 0 || currentType < 0 || payLoad == null) continue;
                    if (cc1WithoutParity != 0) {
                        payLoad.add((byte)cc1WithoutParity);
                    }
                    if (cc2WithoutParity == 0) continue;
                    payLoad.add((byte)cc2WithoutParity);
                    continue;
                }
                state = "interrupted";
            }
        }
    }

    public void find708AuxData(long pts, AuxiliaryData auxData) {
        CCData ccData;
        if (auxData != null && auxData.isDVB1data() && auxData.getUser_data_type_code() == 3 && (ccData = auxData.getCcData()).getProcess_cc_data_flag() == 1) {
            List<Construct> constructs = ccData.getConstructs();
            for (Construct c : constructs) {
                if (c.getCc_valid() != 1 || c.getCc_data_1() == 128 && c.getCc_data_2() == 128) continue;
                Map typeMap = this.allCcData.computeIfAbsent(c.getCc_type(), k -> new TreeMap());
                List constructList = typeMap.computeIfAbsent(pts, k -> new ArrayList());
                constructList.add(c);
            }
        }
    }
}

