/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video.common;

import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.BitSource;

public class SlHdrInfo
implements TreeNode {
    private static final Logger logger = Logger.getLogger(SlHdrInfo.class.getName());
    private int terminal_provider_oriented_code_message_idc;
    private int sl_hdr_mode_value_minus1;
    private int sl_hdr_spec_major_version_idc;
    private int sl_hdr_spec_minor_version_idc;
    private int sl_hdr_cancel_flag;
    private int sl_hdr_persistence_flag;
    private int coded_picture_info_present_flag;
    private int target_picture_info_present_flag;
    private int src_mdcv_info_present_flag;
    private int sl_hdr_extension_present_flag;
    private int sl_hdr_payload_mode;
    private int coded_picture_primaries;
    private int coded_picture_max_luminance;
    private int coded_picture_min_luminance;
    private int target_picture_primaries;
    private int target_picture_max_luminance;
    private int target_picture_min_luminance;
    private int[] src_mdcv_primaries_x = new int[3];
    private int[] src_mdcv_primaries_y = new int[3];
    private int src_mdcv_ref_white_x;
    private int src_mdcv_ref_white_y;
    private int src_mdcv_max_mastering_luminance;
    private int src_mdcv_min_mastering_luminance;
    private int[] matrix_coefficient_value = new int[4];
    private int[] chroma_to_luma_injection = new int[2];
    private int[] k_coefficient_value = new int[3];
    private int tone_mapping_input_signal_black_level_offset;
    private int tone_mapping_input_signal_white_level_offset;
    private int shadow_gain_control;
    private int highlight_gain_control;
    private int mid_tone_width_adjustment_factor;
    private int tone_mapping_output_fine_tuning_num_val;
    private int saturation_gain_num_val;
    private int[] tone_mapping_output_fine_tuning_x;
    private int[] tone_mapping_output_fine_tuning_y;
    private int[] saturation_gain_x;
    private int[] saturation_gain_y;
    private int lm_uniform_sampling_flag;
    private int luminance_mapping_num_val;
    private int[] luminance_mapping_x;
    private int[] luminance_mapping_y;
    private int cc_uniform_sampling_flag;
    private int colour_correction_num_val;
    private int[] colour_correction_x;
    private int[] colour_correction_y;
    private boolean gamutMappingParamsOrSlHdrExtensionPresent;

    public SlHdrInfo(byte[] payload, int offset, int j) {
        BitSource bitSource = new BitSource(payload, offset);
        this.terminal_provider_oriented_code_message_idc = bitSource.u(8);
        this.sl_hdr_mode_value_minus1 = bitSource.u(4);
        this.sl_hdr_spec_major_version_idc = bitSource.u(4);
        this.sl_hdr_spec_minor_version_idc = bitSource.u(7);
        this.sl_hdr_cancel_flag = bitSource.u(1);
        if (this.sl_hdr_cancel_flag != 1) {
            int i;
            this.sl_hdr_persistence_flag = bitSource.u(1);
            this.coded_picture_info_present_flag = bitSource.u(1);
            this.target_picture_info_present_flag = bitSource.u(1);
            this.src_mdcv_info_present_flag = bitSource.u(1);
            this.sl_hdr_extension_present_flag = bitSource.u(1);
            this.sl_hdr_payload_mode = bitSource.u(3);
            if (this.coded_picture_info_present_flag == 1) {
                this.coded_picture_primaries = bitSource.u(8);
                this.coded_picture_max_luminance = bitSource.u(16);
                this.coded_picture_min_luminance = bitSource.u(16);
            }
            if (this.target_picture_info_present_flag == 1) {
                this.target_picture_primaries = bitSource.u(8);
                this.target_picture_max_luminance = bitSource.u(16);
                this.target_picture_min_luminance = bitSource.u(16);
            }
            if (this.src_mdcv_info_present_flag == 1) {
                for (int c = 0; c < 3; ++c) {
                    this.src_mdcv_primaries_x[c] = bitSource.u(16);
                    this.src_mdcv_primaries_y[c] = bitSource.u(16);
                }
                this.src_mdcv_ref_white_x = bitSource.u(16);
                this.src_mdcv_ref_white_y = bitSource.u(16);
                this.src_mdcv_max_mastering_luminance = bitSource.u(16);
                this.src_mdcv_min_mastering_luminance = bitSource.u(16);
            }
            for (i = 0; i < 4; ++i) {
                this.matrix_coefficient_value[i] = bitSource.u(16);
            }
            for (i = 0; i < 2; ++i) {
                this.chroma_to_luma_injection[i] = bitSource.u(16);
            }
            for (i = 0; i < 3; ++i) {
                this.k_coefficient_value[i] = bitSource.u(8);
            }
            if (this.sl_hdr_payload_mode == 0) {
                this.tone_mapping_input_signal_black_level_offset = bitSource.u(8);
                this.tone_mapping_input_signal_white_level_offset = bitSource.u(8);
                this.shadow_gain_control = bitSource.u(8);
                this.highlight_gain_control = bitSource.u(8);
                this.mid_tone_width_adjustment_factor = bitSource.u(8);
                this.tone_mapping_output_fine_tuning_num_val = bitSource.u(4);
                this.saturation_gain_num_val = bitSource.u(4);
                this.tone_mapping_output_fine_tuning_x = new int[this.tone_mapping_output_fine_tuning_num_val];
                this.tone_mapping_output_fine_tuning_y = new int[this.tone_mapping_output_fine_tuning_num_val];
                for (i = 0; i < this.tone_mapping_output_fine_tuning_num_val; ++i) {
                    this.tone_mapping_output_fine_tuning_x[i] = bitSource.u(8);
                    this.tone_mapping_output_fine_tuning_y[i] = bitSource.u(8);
                }
                this.saturation_gain_x = new int[this.saturation_gain_num_val];
                this.saturation_gain_y = new int[this.saturation_gain_num_val];
                for (i = 0; i < this.saturation_gain_num_val; ++i) {
                    this.saturation_gain_x[i] = bitSource.u(8);
                    this.saturation_gain_y[i] = bitSource.u(8);
                }
            } else if (this.sl_hdr_payload_mode == 1) {
                this.lm_uniform_sampling_flag = bitSource.u(1);
                this.luminance_mapping_num_val = bitSource.u(7);
                this.luminance_mapping_x = new int[this.luminance_mapping_num_val];
                this.luminance_mapping_y = new int[this.luminance_mapping_num_val];
                for (i = 0; i < this.luminance_mapping_num_val; ++i) {
                    if (this.lm_uniform_sampling_flag == 0) {
                        this.luminance_mapping_x[i] = bitSource.u(16);
                    }
                    this.luminance_mapping_y[i] = bitSource.u(16);
                }
                this.cc_uniform_sampling_flag = bitSource.u(1);
                this.colour_correction_num_val = bitSource.u(7);
                for (i = 0; i < this.colour_correction_num_val; ++i) {
                    if (this.cc_uniform_sampling_flag == 0) {
                        this.colour_correction_x[i] = bitSource.u(16);
                    }
                    this.colour_correction_y[i] = bitSource.u(16);
                }
            }
            if (bitSource.available() > 0) {
                this.gamutMappingParamsOrSlHdrExtensionPresent = true;
                logger.warning("GamutMappingEnabledFlag or sl_hdr_extension_present_flag set, not implemented");
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("sl_hdr_info"));
        t.add(new DefaultMutableTreeNode(new KVP("terminal_provider_oriented_code_message_idc", this.terminal_provider_oriented_code_message_idc, null)));
        t.add(new DefaultMutableTreeNode(new KVP("sl_hdr_mode_value_minus1", this.sl_hdr_mode_value_minus1, null)));
        t.add(new DefaultMutableTreeNode(new KVP("sl_hdr_spec_major_version_idc", this.sl_hdr_spec_major_version_idc, null)));
        t.add(new DefaultMutableTreeNode(new KVP("sl_hdr_spec_minor_version_idc", this.sl_hdr_spec_minor_version_idc, null)));
        t.add(new DefaultMutableTreeNode(new KVP("sl_hdr_cancel_flag", this.sl_hdr_cancel_flag, null)));
        if (this.sl_hdr_cancel_flag != 1) {
            int i;
            t.add(new DefaultMutableTreeNode(new KVP("sl_hdr_persistence_flag", this.sl_hdr_persistence_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("coded_picture_info_present_flag", this.coded_picture_info_present_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("target_picture_info_present_flag", this.target_picture_info_present_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("src_mdcv_info_present_flag", this.src_mdcv_info_present_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("sl_hdr_extension_present_flag", this.sl_hdr_extension_present_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("sl_hdr_payload_mode", this.sl_hdr_payload_mode, null)));
            if (this.coded_picture_info_present_flag == 1) {
                t.add(new DefaultMutableTreeNode(new KVP("coded_picture_primaries", this.coded_picture_primaries, null)));
                t.add(new DefaultMutableTreeNode(new KVP("coded_picture_max_luminance", this.coded_picture_max_luminance, null)));
                t.add(new DefaultMutableTreeNode(new KVP("coded_picture_min_luminance", this.coded_picture_min_luminance, null)));
            }
            if (this.target_picture_info_present_flag == 1) {
                t.add(new DefaultMutableTreeNode(new KVP("target_picture_primaries", this.target_picture_primaries, null)));
                t.add(new DefaultMutableTreeNode(new KVP("target_picture_max_luminance", this.target_picture_max_luminance, null)));
                t.add(new DefaultMutableTreeNode(new KVP("target_picture_min_luminance", this.target_picture_min_luminance, null)));
            }
            if (this.src_mdcv_info_present_flag == 1) {
                for (int c = 0; c < 3; ++c) {
                    t.add(new DefaultMutableTreeNode(new KVP("src_mdcv_primaries_x[" + c + "]", this.src_mdcv_primaries_x[c], null)));
                    t.add(new DefaultMutableTreeNode(new KVP("src_mdcv_primaries_y[" + c + "]", this.src_mdcv_primaries_y[c], null)));
                }
                t.add(new DefaultMutableTreeNode(new KVP("src_mdcv_ref_white_x", this.src_mdcv_ref_white_x, null)));
                t.add(new DefaultMutableTreeNode(new KVP("src_mdcv_ref_white_y", this.src_mdcv_ref_white_y, null)));
                t.add(new DefaultMutableTreeNode(new KVP("src_mdcv_max_mastering_luminance", this.src_mdcv_max_mastering_luminance, null)));
                t.add(new DefaultMutableTreeNode(new KVP("src_mdcv_min_mastering_luminance", this.src_mdcv_min_mastering_luminance, null)));
            }
            for (i = 0; i < 4; ++i) {
                t.add(new DefaultMutableTreeNode(new KVP("matrix_coefficient_value[" + i + "]", this.matrix_coefficient_value[i], null)));
            }
            for (i = 0; i < 2; ++i) {
                t.add(new DefaultMutableTreeNode(new KVP("chroma_to_luma_injection[" + i + "]", this.chroma_to_luma_injection[i], null)));
            }
            for (i = 0; i < 3; ++i) {
                t.add(new DefaultMutableTreeNode(new KVP("k_coefficient_value[" + i + "]", this.k_coefficient_value[i], null)));
            }
            if (this.sl_hdr_payload_mode == 0) {
                t.add(new DefaultMutableTreeNode(new KVP("tone_mapping_input_signal_black_level_offset", this.tone_mapping_input_signal_black_level_offset, null)));
                t.add(new DefaultMutableTreeNode(new KVP("tone_mapping_input_signal_white_level_offset", this.tone_mapping_input_signal_white_level_offset, null)));
                t.add(new DefaultMutableTreeNode(new KVP("shadow_gain_control", this.shadow_gain_control, null)));
                t.add(new DefaultMutableTreeNode(new KVP("highlight_gain_control", this.highlight_gain_control, null)));
                t.add(new DefaultMutableTreeNode(new KVP("mid_tone_width_adjustment_factor", this.mid_tone_width_adjustment_factor, null)));
                t.add(new DefaultMutableTreeNode(new KVP("tone_mapping_output_fine_tuning_num_val", this.tone_mapping_output_fine_tuning_num_val, null)));
                t.add(new DefaultMutableTreeNode(new KVP("saturation_gain_num_val", this.saturation_gain_num_val, null)));
                for (i = 0; i < this.tone_mapping_output_fine_tuning_num_val; ++i) {
                    t.add(new DefaultMutableTreeNode(new KVP("tone_mapping_output_fine_tuning_x[" + i + "]", this.tone_mapping_output_fine_tuning_x[i], null)));
                    t.add(new DefaultMutableTreeNode(new KVP("tone_mapping_output_fine_tuning_y[" + i + "]", this.tone_mapping_output_fine_tuning_y[i], null)));
                }
                for (i = 0; i < this.saturation_gain_num_val; ++i) {
                    t.add(new DefaultMutableTreeNode(new KVP("saturation_gain_x[" + i + "]", this.saturation_gain_x[i], null)));
                    t.add(new DefaultMutableTreeNode(new KVP("saturation_gain_y[" + i + "]", this.saturation_gain_y[i], null)));
                }
            } else if (this.sl_hdr_payload_mode == 1) {
                t.add(new DefaultMutableTreeNode(new KVP("lm_uniform_sampling_flag", this.lm_uniform_sampling_flag, null)));
                t.add(new DefaultMutableTreeNode(new KVP("luminance_mapping_num_val", this.luminance_mapping_num_val, null)));
                for (i = 0; i < this.luminance_mapping_num_val; ++i) {
                    if (this.lm_uniform_sampling_flag == 0) {
                        t.add(new DefaultMutableTreeNode(new KVP("luminance_mapping_x[" + i + "]", this.luminance_mapping_x[i], null)));
                    }
                    t.add(new DefaultMutableTreeNode(new KVP("luminance_mapping_y[" + i + "]", this.luminance_mapping_y[i], null)));
                }
                t.add(new DefaultMutableTreeNode(new KVP("cc_uniform_sampling_flag", this.cc_uniform_sampling_flag, null)));
                t.add(new DefaultMutableTreeNode(new KVP("colour_correction_num_val", this.colour_correction_num_val, null)));
                for (i = 0; i < this.colour_correction_num_val; ++i) {
                    if (this.cc_uniform_sampling_flag == 0) {
                        t.add(new DefaultMutableTreeNode(new KVP("colour_correction_x[" + i + "]", this.colour_correction_x[i], null)));
                    }
                    t.add(new DefaultMutableTreeNode(new KVP("colour_correction_y[" + i + "]", this.colour_correction_y[i], null)));
                }
            }
            if (this.gamutMappingParamsOrSlHdrExtensionPresent) {
                t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("GamutMappingEnabledFlag or sl_hdr_extension_present_flag set")));
            }
        }
        return t;
    }
}

