/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video264;

import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.RBSP;

public class Pic_parameter_set_rbsp
extends RBSP {
    private static final Logger logger = Logger.getLogger(Pic_parameter_set_rbsp.class.getName());
    private final int pic_parameter_set_id;
    private final int seq_parameter_set_id;
    private final int entropy_coding_mode_flag;
    private final int pic_order_present_flag;
    private final int num_slice_groups_minus1;
    private final int num_ref_idx_l0_active_minus1;
    private final int num_ref_idx_l1_active_minus1;
    private final int weighted_pred_flag;
    private final int weighted_bipred_idc;
    private final int pic_init_qp_minus26;
    private final int pic_init_qs_minus26;
    private final int chroma_qp_index_offset;
    private final int deblocking_filter_control_present_flag;
    private final int constrained_intra_pred_flag;
    private final int redundant_pic_cnt_present_flag;
    private int transform_8x8_mode_flag;
    private int pic_scaling_matrix_present_flag;
    private final int[] pic_scaling_list_present_flag = new int[8];
    private final int[][] delta_scale = new int[8][];
    private final int[] deltas_read = new int[8];
    private int second_chroma_qp_index_offset;

    protected Pic_parameter_set_rbsp(byte[] rbsp_bytes, int numBytesInRBSP) {
        super(rbsp_bytes, numBytesInRBSP);
        this.pic_parameter_set_id = this.bitSource.ue();
        this.seq_parameter_set_id = this.bitSource.ue();
        this.entropy_coding_mode_flag = this.bitSource.u(1);
        this.pic_order_present_flag = this.bitSource.u(1);
        this.num_slice_groups_minus1 = this.bitSource.ue();
        if (this.num_slice_groups_minus1 > 0) {
            logger.warning(" (num_slice_groups_minus1 > 0 not implemented");
        }
        this.num_ref_idx_l0_active_minus1 = this.bitSource.ue();
        this.num_ref_idx_l1_active_minus1 = this.bitSource.ue();
        this.weighted_pred_flag = this.bitSource.u(1);
        this.weighted_bipred_idc = this.bitSource.u(2);
        this.pic_init_qp_minus26 = this.bitSource.se();
        this.pic_init_qs_minus26 = this.bitSource.se();
        this.chroma_qp_index_offset = this.bitSource.se();
        this.deblocking_filter_control_present_flag = this.bitSource.u(1);
        this.constrained_intra_pred_flag = this.bitSource.u(1);
        this.redundant_pic_cnt_present_flag = this.bitSource.u(1);
        if (this.bitSource.available() >= 10) {
            this.transform_8x8_mode_flag = this.bitSource.u(1);
            this.pic_scaling_matrix_present_flag = this.bitSource.u(1);
            if (this.pic_scaling_matrix_present_flag != 0) {
                for (int i = 0; i < 6 + 2 * this.transform_8x8_mode_flag; ++i) {
                    this.pic_scaling_list_present_flag[i] = this.bitSource.u(1);
                    if (this.pic_scaling_list_present_flag[i] == 0) continue;
                    if (i < 6) {
                        this.delta_scale[i] = new int[16];
                        this.deltas_read[i] = Pic_parameter_set_rbsp.scaling_list(this.delta_scale[i], 16, this.bitSource);
                        continue;
                    }
                    this.delta_scale[i] = new int[64];
                    this.deltas_read[i] = Pic_parameter_set_rbsp.scaling_list(this.delta_scale[i], 64, this.bitSource);
                }
            }
            this.second_chroma_qp_index_offset = this.bitSource.se();
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("pic_parameter_set_rbsp"));
        t.add(new DefaultMutableTreeNode(new KVP("pic_parameter_set_id", this.pic_parameter_set_id, null)));
        t.add(new DefaultMutableTreeNode(new KVP("seq_parameter_set_id", this.seq_parameter_set_id, null)));
        t.add(new DefaultMutableTreeNode(new KVP("entropy_coding_mode_flag", this.entropy_coding_mode_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("pic_order_present_flag", this.pic_order_present_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("num_slice_groups_minus1", this.num_slice_groups_minus1, null)));
        t.add(new DefaultMutableTreeNode(new KVP("num_ref_idx_l0_active_minus1", this.num_ref_idx_l0_active_minus1, null)));
        t.add(new DefaultMutableTreeNode(new KVP("num_ref_idx_l1_active_minus1", this.num_ref_idx_l1_active_minus1, null)));
        t.add(new DefaultMutableTreeNode(new KVP("weighted_pred_flag", this.weighted_pred_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("weighted_bipred_idc", this.weighted_bipred_idc, null)));
        t.add(new DefaultMutableTreeNode(new KVP("pic_init_qp_minus26", this.pic_init_qp_minus26, null)));
        t.add(new DefaultMutableTreeNode(new KVP("pic_init_qs_minus26", this.pic_init_qs_minus26, null)));
        t.add(new DefaultMutableTreeNode(new KVP("chroma_qp_index_offset", this.chroma_qp_index_offset, null)));
        t.add(new DefaultMutableTreeNode(new KVP("deblocking_filter_control_present_flag", this.deblocking_filter_control_present_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("constrained_intra_pred_flag", this.constrained_intra_pred_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("redundant_pic_cnt_present_flag", this.redundant_pic_cnt_present_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("transform_8x8_mode_flag", this.transform_8x8_mode_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("pic_scaling_matrix_present_flag", this.pic_scaling_matrix_present_flag, null)));
        if (this.pic_scaling_matrix_present_flag != 0) {
            for (int i = 0; i < 6 + 2 * this.transform_8x8_mode_flag; ++i) {
                t.add(new DefaultMutableTreeNode(new KVP("pic_scaling_list_present_flag[" + i + "]", this.pic_scaling_list_present_flag[i], null)));
                if (this.pic_scaling_list_present_flag[i] == 0) continue;
                if (i < 6) {
                    t.add(Pic_parameter_set_rbsp.getScalingListJTree(this.delta_scale[i], i, 16, this.deltas_read[i]));
                    continue;
                }
                t.add(Pic_parameter_set_rbsp.getScalingListJTree(this.delta_scale[i], i, 64, this.deltas_read[i]));
            }
        }
        t.add(new DefaultMutableTreeNode(new KVP("second_chroma_qp_index_offset", this.second_chroma_qp_index_offset, null)));
        return t;
    }

    public int getPic_parameter_set_id() {
        return this.pic_parameter_set_id;
    }

    public int getSeq_parameter_set_id() {
        return this.seq_parameter_set_id;
    }

    public int getEntropy_coding_mode_flag() {
        return this.entropy_coding_mode_flag;
    }

    public int getPic_order_present_flag() {
        return this.pic_order_present_flag;
    }

    public int getNum_slice_groups_minus1() {
        return this.num_slice_groups_minus1;
    }

    public int getNum_ref_idx_l0_active_minus1() {
        return this.num_ref_idx_l0_active_minus1;
    }

    public int getNum_ref_idx_l1_active_minus1() {
        return this.num_ref_idx_l1_active_minus1;
    }

    public int getWeighted_pred_flag() {
        return this.weighted_pred_flag;
    }

    public int getWeighted_bipred_idc() {
        return this.weighted_bipred_idc;
    }

    public int getPic_init_qp_minus26() {
        return this.pic_init_qp_minus26;
    }

    public int getPic_init_qs_minus26() {
        return this.pic_init_qs_minus26;
    }

    public int getChroma_qp_index_offset() {
        return this.chroma_qp_index_offset;
    }

    public int getDeblocking_filter_control_present_flag() {
        return this.deblocking_filter_control_present_flag;
    }

    public int getConstrained_intra_pred_flag() {
        return this.constrained_intra_pred_flag;
    }

    public int getRedundant_pic_cnt_present_flag() {
        return this.redundant_pic_cnt_present_flag;
    }

    public int getTransform_8x8_mode_flag() {
        return this.transform_8x8_mode_flag;
    }

    public int getPic_scaling_matrix_present_flag() {
        return this.pic_scaling_matrix_present_flag;
    }

    public int[] getPic_scaling_list_present_flag() {
        return this.pic_scaling_list_present_flag;
    }

    public int[][] getDelta_scale() {
        return this.delta_scale;
    }

    public int[] getDeltas_read() {
        return this.deltas_read;
    }

    public int getSecond_chroma_qp_index_offset() {
        return this.second_chroma_qp_index_offset;
    }
}

