/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video264;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.util.BitSource;

public class Slice_header
implements TreeNode {
    private int first_mb_in_slice;
    private int slice_type;
    private int pic_parameter_set_id;

    public Slice_header(BitSource bitSource) {
        this.first_mb_in_slice = bitSource.ue();
        this.slice_type = bitSource.ue();
        this.pic_parameter_set_id = bitSource.ue();
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("slice_header"));
        s.add(new DefaultMutableTreeNode(new KVP("first_mb_in_slice", this.first_mb_in_slice, null)));
        s.add(new DefaultMutableTreeNode(new KVP("slice_type", this.slice_type, Slice_header.getSlice_typeString(this.slice_type))));
        s.add(new DefaultMutableTreeNode(new KVP("pic_parameter_set_id", this.pic_parameter_set_id, null)));
        return s;
    }

    public static String getSlice_typeString(int slice_type) {
        switch (slice_type) {
            case 0: {
                return "P";
            }
            case 1: {
                return "B";
            }
            case 2: {
                return "I";
            }
            case 3: {
                return "SP";
            }
            case 4: {
                return "SI";
            }
            case 5: {
                return "P";
            }
            case 6: {
                return "B";
            }
            case 7: {
                return "I";
            }
            case 8: {
                return "SP";
            }
            case 9: {
                return "SI";
            }
        }
        return "illegal value";
    }

    public int getFirst_mb_in_slice() {
        return this.first_mb_in_slice;
    }

    public int getSlice_type() {
        return this.slice_type;
    }

    public int getPic_parameter_set_id() {
        return this.pic_parameter_set_id;
    }
}

